/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.api.models;

import java.io.Serializable;
import java.util.Objects;
import java.util.UUID;

public class TargetValue
implements Serializable {
    private static final long serialVersionUID = 4273827699580322524L;
    private final String name = UUID.randomUUID().toString();
    private final String value;
    private final String displayValue;
    private final Double priorProbability;
    private final Double defaultValue;

    public TargetValue(String value, String displayValue, Number priorProbability, Number defaultValue) {
        this.value = value;
        this.displayValue = displayValue;
        this.priorProbability = priorProbability != null ? Double.valueOf(priorProbability.doubleValue()) : null;
        this.defaultValue = defaultValue != null ? Double.valueOf(defaultValue.doubleValue()) : null;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public String getDisplayValue() {
        return this.displayValue;
    }

    public Double getPriorProbability() {
        return this.priorProbability;
    }

    public Double getDefaultValue() {
        return this.defaultValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TargetValue that = (TargetValue)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.value, that.value) && Objects.equals(this.displayValue, that.displayValue) && Objects.equals(this.priorProbability, that.priorProbability) && Objects.equals(this.defaultValue, that.defaultValue);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.value, this.displayValue, this.priorProbability, this.defaultValue);
    }

    public String toString() {
        return "TargetValue{name='" + this.name + '\'' + ", value='" + this.value + '\'' + ", displayValue='" + this.displayValue + '\'' + ", priorProbability=" + this.priorProbability + ", defaultValue=" + this.defaultValue + '}';
    }
}

