/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.core.timer;

import org.drools.core.time.JobContext;
import org.jbpm.process.core.timer.NamedJobContext;
import org.jbpm.process.instance.timer.TimerManager;

public class JobNameHelper {
    private JobNameHelper() {
    }

    public static String getJobName(JobContext ctx, long id) {
        return JobNameHelper.getJobName(ctx, JobNameHelper.getGroupName(ctx), id);
    }

    public static String getJobName(JobContext ctx, String groupName, long id) {
        String jobName;
        if (ctx instanceof TimerManager.ProcessJobContext) {
            TimerManager.ProcessJobContext processCtx = (TimerManager.ProcessJobContext)ctx;
            String timerName = "-" + JobNameHelper.getTimerName(processCtx);
            jobName = processCtx instanceof TimerManager.StartProcessJobContext ? groupName + "-StartProcess-" + ((TimerManager.StartProcessJobContext)processCtx).getProcessId() + timerName : processCtx.getSessionId() + "-" + processCtx.getProcessInstanceId() + timerName;
        } else {
            jobName = ctx instanceof NamedJobContext ? ((NamedJobContext)ctx).getJobName() : "Timer-" + ctx.getClass().getSimpleName() + "-" + id;
        }
        return jobName;
    }

    private static String getTimerName(TimerManager.ProcessJobContext ctx) {
        String timerName = ctx.getTimer().getName();
        return (timerName != null && !timerName.isEmpty() ? timerName + "-" : "") + ctx.getTimer().getId();
    }

    public static String getGroupName(JobContext ctx) {
        String deploymentId;
        String groupName = "jbpm";
        if (ctx instanceof TimerManager.ProcessJobContext) {
            TimerManager.ProcessJobContext processCtx = (TimerManager.ProcessJobContext)ctx;
            String deploymentId2 = (String)processCtx.getKnowledgeRuntime().getEnvironment().get("deploymentId");
            if (deploymentId2 != null) {
                groupName = deploymentId2;
            }
        } else if (ctx instanceof NamedJobContext && (deploymentId = ((NamedJobContext)ctx).getDeploymentId()) != null) {
            groupName = deploymentId;
        }
        return groupName;
    }
}

