/*
 * Decompiled with CFR 0.152.
 */
package org.kie.wb.selenium.model.persps;

import org.jboss.arquillian.graphene.Graphene;
import org.jboss.arquillian.graphene.page.Page;
import org.kie.wb.selenium.model.PageObject;
import org.kie.wb.selenium.model.PrimaryNavbar;
import org.kie.wb.selenium.model.widgets.Panel;
import org.kie.wb.selenium.util.BusyPopup;
import org.kie.wb.selenium.util.ByUtil;
import org.kie.wb.selenium.util.Waits;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public abstract class AbstractPerspective
extends PageObject {
    @Page
    private PrimaryNavbar navbar;
    @FindBy(css="input[type='submit']")
    private WebElement loginAgainButton;

    public PrimaryNavbar getNavbar() {
        return this.navbar;
    }

    public void logout() {
        this.navbar.logout();
        Graphene.waitModel().until().element(this.loginAgainButton).is().present();
        this.loginAgainButton.click();
    }

    public abstract boolean isDisplayed();

    public void waitForLoaded() {
    }

    public <T extends Panel> T createPanel(Class<T> panelClass, String title) {
        By panelLoc = ByUtil.jquery(".uf-listbar-panel:contains('%s')", title);
        WebElement panelRoot = Waits.elementPresent(panelLoc, 3);
        return (T)((Panel)Graphene.createPageFragment(panelClass, (WebElement)panelRoot));
    }

    public void click(By locatorOfThingToClick) {
        WebElement thingToClick = Waits.elementPresent(locatorOfThingToClick);
        BusyPopup.retryClickUntilPopupDisappears(thingToClick);
    }
}

