/*
 * Decompiled with CFR 0.152.
 */
package org.kie.wb.selenium.ui;

import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.guvnor.rest.client.CloneProjectRequest;
import org.guvnor.rest.client.Space;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.wb.selenium.model.KieSeleniumTest;
import org.kie.wb.selenium.util.Waits;
import org.kie.wb.test.rest.client.RestWorkbenchClient;
import org.kie.wb.test.rest.client.WorkbenchClient;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriverException;

public class StandalonePerspectivesIntegrationTest
extends KieSeleniumTest {
    private static final String PROJECT_URL = "https://github.com/Rikkola/single-project-test-repository.git";
    private static final String SPACE_NAME = "Standalone_space";
    private static final String PROJECT_NAME = "Standalone_project";
    private static final String BASE_URL = System.getProperty("kie.wb.url");
    private static final String APP_CONTEXT = "kie-wb.jsp";
    private static final String STANDALONE_PARAMETER = "?standalone";
    private static final String PERSPECTIVE_PARAMETER = "&perspective=";
    private static final String HEADER_PARAMETER = "&header=UberfireBreadcrumbsContainer";
    private static final String PERSPECTIVE_FULL_URL = BASE_URL + "/" + "kie-wb.jsp" + "?standalone" + "&perspective=";
    private static final String PROJECT_ASSET_PATH = "&path=default://master@Standalone_space/Standalone_project/src/main/java/mortgages/mortgages/Applicant.java";
    private static final String EDITOR_FULL_URL = BASE_URL + "/" + "kie-wb.jsp" + "?standalone" + "&path=default://master@Standalone_space/Standalone_project/src/main/java/mortgages/mortgages/Applicant.java";
    private static final By CONTENT_MANAGEMENT = By.cssSelector((String)"[title='Content Manager']");
    private static final By DATA_OBJECT = By.cssSelector((String)"[title='Applicant.java - Data Objects']");
    private static final By HEADER = By.id((String)"workbenchHeaderPanel");
    private static final By LIBRARY = By.className((String)"toolbar-data-title-kie");

    @BeforeClass
    public static void cloneTestingProject() {
        WorkbenchClient workbenchClient = RestWorkbenchClient.createWorkbenchClient((String)BASE_URL, (String)"restAll", (String)"restAll1234;");
        Space space = new Space();
        space.setName(SPACE_NAME);
        space.setOwner("donald@duck.gov");
        space.setDefaultGroupId("gov.duck");
        workbenchClient.createSpace(space);
        CloneProjectRequest cloneReq = new CloneProjectRequest();
        cloneReq.setGitURL(PROJECT_URL);
        cloneReq.setName(PROJECT_NAME);
        workbenchClient.cloneRepository(SPACE_NAME, cloneReq);
    }

    @Before
    public void setUp() {
        this.login.get();
        if (this.login.isDisplayed()) {
            this.login.loginDefaultUser();
        }
    }

    @Test
    public void testLibraryPerspectiveWithoutHeader() {
        String perspective = "LibraryPerspective";
        driver.get(PERSPECTIVE_FULL_URL + perspective);
        this.verifyPerspectiveIsLoaded(LIBRARY);
        this.verifyPresenceOfHeader(false);
    }

    @Test
    public void testLibraryPerspectiveWithHeader() {
        String perspective = "LibraryPerspective";
        driver.get(PERSPECTIVE_FULL_URL + perspective + HEADER_PARAMETER);
        this.verifyPerspectiveIsLoaded(LIBRARY);
        this.verifyPresenceOfHeader(true);
    }

    @Test
    public void testStandaloneEditorPerspective() {
        driver.get(EDITOR_FULL_URL);
        this.verifyPerspectiveIsLoaded(DATA_OBJECT);
    }

    @Test
    public void testContentManagerPerspective() {
        String perspective = "ContentManagerPerspective";
        driver.get(PERSPECTIVE_FULL_URL + perspective);
        this.verifyPerspectiveIsLoaded(CONTENT_MANAGEMENT);
    }

    private void verifyPerspectiveIsLoaded(By verifier) {
        try {
            Waits.elementPresent((By)verifier, (int)15);
        }
        catch (WebDriverException exception) {
            Assertions.fail((String)"The standalone perspective was not loaded.", (Throwable)exception);
        }
    }

    private void verifyPresenceOfHeader(boolean headerIncluded) {
        int actualHeaderCount = driver.findElements(HEADER).size();
        int expectedHeaderCount = headerIncluded ? 1 : 0;
        String headerAssertionMessage = String.format("There should %s be UberfireBreadcrumbsContainer on the page.", headerIncluded ? "" : "NOT");
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualHeaderCount).as(headerAssertionMessage, new Object[0])).isEqualTo(expectedHeaderCount);
    }
}

