/*
 * Decompiled with CFR 0.152.
 */
package org.kie.wb.selenium.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.kie.wb.selenium.model.KieWbDistribution;
import org.kie.wb.selenium.model.persps.AbstractPerspective;
import org.kie.wb.selenium.model.persps.AdminPagePerspective;
import org.kie.wb.selenium.model.persps.ArtifactRepositoryPerspective;
import org.kie.wb.selenium.model.persps.ContentManagerPerspective;
import org.kie.wb.selenium.model.persps.ExecutionErrorsPerspective;
import org.kie.wb.selenium.model.persps.ExecutionServersPerspective;
import org.kie.wb.selenium.model.persps.HomePerspective;
import org.kie.wb.selenium.model.persps.JobsPerspective;
import org.kie.wb.selenium.model.persps.ProcessDashboardPerspective;
import org.kie.wb.selenium.model.persps.ProcessDefinitionsPerspective;
import org.kie.wb.selenium.model.persps.ProcessInstancesPerspective;
import org.kie.wb.selenium.model.persps.ProjectLibraryPerspective;
import org.kie.wb.selenium.model.persps.ProvisioningManagementPerspective;
import org.kie.wb.selenium.model.persps.TaskAdminPerspective;
import org.kie.wb.selenium.model.persps.TaskDashboardPerspective;
import org.kie.wb.selenium.model.persps.TasksPerspective;

public class Persp<T extends AbstractPerspective> {
    public static final Persp<HomePerspective> HOME = new Persp<HomePerspective>("N/A", "Home", HomePerspective.class);
    public static final Persp<AdminPagePerspective> ADMIN = new Persp<AdminPagePerspective>("N/A", "Admin", AdminPagePerspective.class);
    public static final Persp<ArtifactRepositoryPerspective> ARTIFACTS = new Persp<ArtifactRepositoryPerspective>("N/A", "Artifacts", ArtifactRepositoryPerspective.class);
    public static final Persp<ProjectLibraryPerspective> PROJECTS = new Persp<ProjectLibraryPerspective>("Design", "Projects", ProjectLibraryPerspective.class, KieWbDistribution.BUSINESS_CENTRAL);
    public static final Persp<ContentManagerPerspective> PAGES = new Persp<ContentManagerPerspective>("Design", "Pages", ContentManagerPerspective.class, KieWbDistribution.BUSINESS_CENTRAL);
    public static final Persp<ProvisioningManagementPerspective> PROVISIONING = new Persp<ProvisioningManagementPerspective>("Deploy", "Provisioning", ProvisioningManagementPerspective.class);
    public static final Persp<ExecutionServersPerspective> EXECUTION_SERVERS = new Persp<ExecutionServersPerspective>("Deploy", "Execution Servers", ExecutionServersPerspective.class);
    public static final Persp<ProcessDefinitionsPerspective> PROCESS_DEFINITIONS = new Persp<ProcessDefinitionsPerspective>("Manage", "Process Definitions", ProcessDefinitionsPerspective.class, KieWbDistribution.BUSINESS_CENTRAL, KieWbDistribution.BUSINESS_MONITORING);
    public static final Persp<ProcessInstancesPerspective> PROCESS_INSTANCES = new Persp<ProcessInstancesPerspective>("Manage", "Process Instances", ProcessInstancesPerspective.class, KieWbDistribution.BUSINESS_CENTRAL, KieWbDistribution.BUSINESS_MONITORING);
    public static final Persp<TaskAdminPerspective> TASKS = new Persp<TaskAdminPerspective>("Manage", "Tasks", TaskAdminPerspective.class, KieWbDistribution.BUSINESS_CENTRAL, KieWbDistribution.BUSINESS_MONITORING);
    public static final Persp<JobsPerspective> JOBS = new Persp<JobsPerspective>("Manage", "Jobs", JobsPerspective.class, KieWbDistribution.BUSINESS_CENTRAL, KieWbDistribution.BUSINESS_MONITORING);
    public static final Persp<ExecutionErrorsPerspective> EXECUTION_ERRORS = new Persp<ExecutionErrorsPerspective>("Manage", "Execution Errors", ExecutionErrorsPerspective.class, KieWbDistribution.BUSINESS_CENTRAL, KieWbDistribution.BUSINESS_MONITORING);
    public static final Persp<TasksPerspective> TASK_INBOX = new Persp<TasksPerspective>("Track", "Task Inbox", TasksPerspective.class, KieWbDistribution.BUSINESS_CENTRAL, KieWbDistribution.BUSINESS_MONITORING);
    public static final Persp<ProcessDashboardPerspective> PROCESS_REPORTS = new Persp<ProcessDashboardPerspective>("Track", "Process Reports", ProcessDashboardPerspective.class, KieWbDistribution.BUSINESS_CENTRAL, KieWbDistribution.BUSINESS_MONITORING);
    public static final Persp<TaskDashboardPerspective> TASK_REPORTS = new Persp<TaskDashboardPerspective>("Track", "Task Reports", TaskDashboardPerspective.class, KieWbDistribution.BUSINESS_CENTRAL, KieWbDistribution.BUSINESS_MONITORING);
    private static final List<Persp<? extends AbstractPerspective>> ALL_PERSPECTIVES = Collections.unmodifiableList(Arrays.asList(ADMIN, HOME, PROJECTS, PAGES, PROVISIONING, EXECUTION_SERVERS, PROCESS_DEFINITIONS, PROCESS_INSTANCES, TASKS, JOBS, EXECUTION_ERRORS, TASK_INBOX, PROCESS_REPORTS, TASK_REPORTS));
    private final String parentMenu;
    private final String menuItem;
    private final Class<T> perspPageObjectClass;
    private final List<KieWbDistribution> kieWbDistributions;

    private Persp(String parentMenu, String menuItem, Class<T> perspPageObjectClass) {
        this(parentMenu, menuItem, perspPageObjectClass, KieWbDistribution.BUSINESS_CENTRAL, KieWbDistribution.BUSINESS_MONITORING);
    }

    private Persp(String parentMenu, String menuItem, Class<T> perspPageObjectClass, KieWbDistribution ... distributions) {
        this.parentMenu = parentMenu;
        this.menuItem = menuItem;
        this.perspPageObjectClass = perspPageObjectClass;
        this.kieWbDistributions = Arrays.asList(distributions);
    }

    public static List<Persp<? extends AbstractPerspective>> getAllPerspectives(KieWbDistribution distribution) {
        return ALL_PERSPECTIVES.stream().filter(perspective -> perspective.getKieWbDistributions().contains((Object)distribution)).collect(Collectors.toList());
    }

    public String getMenu() {
        return this.parentMenu;
    }

    public String getName() {
        return this.menuItem;
    }

    public Class<T> getPerspectivePageObjectClass() {
        return this.perspPageObjectClass;
    }

    public List<KieWbDistribution> getKieWbDistributions() {
        return this.kieWbDistributions;
    }

    public String toString() {
        return this.getName().replace(' ', '_');
    }
}

