/*
 * Decompiled with CFR 0.152.
 */
package org.kie.wb.selenium.model.widgets;

import org.jboss.arquillian.graphene.Graphene;
import org.kie.wb.selenium.model.PageObject;
import org.kie.wb.selenium.util.ByUtil;
import org.kie.wb.selenium.util.Waits;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public class ModalDialog
extends PageObject {
    @FindBy(className="close")
    private WebElement closeButton;

    public static <T extends ModalDialog> T newInstance(Class<T> pageFragmentClass, String modalTitle) {
        By modalRootLocator = ByUtil.xpath("//div[@class='modal-content' and div[@class='modal-header'][h4[contains(text(),'%s')]]]", modalTitle);
        WebElement modalRoot = Waits.elementPresent(modalRootLocator);
        return (T)((ModalDialog)Graphene.createPageFragment(pageFragmentClass, (WebElement)modalRoot));
    }

    public void close() {
        this.closeButton.click();
    }

    public void ok() {
        this.clickButton("Ok");
        this.waitForDisappearance();
    }

    public void finish() {
        this.clickButton("Finish");
        this.waitForDisappearance();
    }

    public void next() {
        this.clickButton("Next");
    }

    protected void clickButton(String buttonText) {
        By buttonLoc = ByUtil.xpath("//div[@class='modal-footer']/button[contains(@class,'btn') and contains(text(),'%s')]", buttonText);
        WebElement button = Waits.elementPresent(buttonLoc);
        button.click();
    }

    protected void waitForDisappearance() {
        Waits.elementAbsent(By.cssSelector((String)".modal.in"));
    }
}

