/*
 * Decompiled with CFR 0.152.
 */
package org.kie.wb.selenium.model.persps;

import org.jboss.arquillian.graphene.findby.ByJQuery;
import org.kie.wb.selenium.model.persps.AbstractPerspective;
import org.kie.wb.selenium.model.persps.authoring.ConflictingRepositoriesModal;
import org.kie.wb.selenium.model.persps.authoring.ImportProjectsScreen;
import org.kie.wb.selenium.model.persps.authoring.ImportRepositoryModal;
import org.kie.wb.selenium.util.Repository;
import org.kie.wb.selenium.util.Waits;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectLibraryPerspective
extends AbstractPerspective {
    private static final Logger LOG = LoggerFactory.getLogger(ProjectLibraryPerspective.class);
    private static final By SPACES_BREADCRUMB = ByJQuery.linkText((String)"Spaces");
    private static final By PROJECT_ACTIONS_BUTTON = By.id((String)"add-project-dropdown");
    private static final By IMPORT_PROJECT_ACTION_BUTTON = By.linkText((String)"Import Project");
    private static final By TRY_SAMPLES_ACTION_BUTTON = By.linkText((String)"Try Samples");
    private static final By IMPORT_PROJECT_BUTTON = By.xpath((String)"//button[@data-field='import-project']");
    private static final By TRY_SAMPLES_BUTTON = By.xpath((String)"//button[@data-field='try-samples']");
    private static final By DEPLOY_BUTTON = By.id((String)"deploy");
    private static final By DEFAULT_SPACE_CARD = By.className((String)"card-pf-view-single-select");
    private static final By PROJECTS_LOADING = By.xpath((String)"//div[contains(@class, 'spinner')]");

    @Override
    public void waitForLoaded() {
        this.isDisplayed();
    }

    @Override
    public boolean isDisplayed() {
        Waits.elementPresent(PROJECTS_LOADING, 60);
        Waits.elementInvisible(PROJECTS_LOADING, 60);
        return Waits.elementClickable(SPACES_BREADCRUMB, 60) != null;
    }

    private ImportRepositoryModal importProject() {
        if (Waits.isElementPresent(IMPORT_PROJECT_BUTTON)) {
            this.click(IMPORT_PROJECT_BUTTON);
        } else {
            this.click(PROJECT_ACTIONS_BUTTON);
            this.click(IMPORT_PROJECT_ACTION_BUTTON);
        }
        return ImportRepositoryModal.newInstance();
    }

    private ImportProjectsScreen trySamples() {
        if (Waits.isElementPresent(TRY_SAMPLES_BUTTON)) {
            this.click(TRY_SAMPLES_BUTTON);
        } else {
            this.click(PROJECT_ACTIONS_BUTTON);
            this.click(TRY_SAMPLES_ACTION_BUTTON);
        }
        return ImportProjectsScreen.newInstance();
    }

    public void enterDefaultSpace() {
        this.click(DEFAULT_SPACE_CARD);
    }

    public void buildAndDeployProject() {
        this.click(DEPLOY_BUTTON);
        this.possiblyOverrideGavConflict();
    }

    public void importStockExampleProject(String ... projects) {
        ImportProjectsScreen importProjectsScreen = this.trySamples();
        importProjectsScreen.selectProjects(projects).ok();
    }

    public void importCustomExampleProject(Repository repo, String ... projects) {
        ImportRepositoryModal modal = this.importProject();
        modal.selectCustomRepository(repo.getUrl());
        ImportProjectsScreen importProjectsScreen = modal.importProjects();
        importProjectsScreen.selectProjects(projects).ok();
    }

    private void possiblyOverrideGavConflict() {
        try {
            ConflictingRepositoriesModal modal = ConflictingRepositoriesModal.newInstance();
            modal.overrideArtifactInMavenRepo();
        }
        catch (NoSuchElementException | TimeoutException ignored) {
            LOG.info("Modal showing GAV conflict didn't appear");
        }
    }
}

