/*
 * Decompiled with CFR 0.152.
 */
package org.kie.wb.selenium.model.persps.authoring;

import org.jboss.arquillian.graphene.Graphene;
import org.kie.wb.selenium.model.PageObject;
import org.kie.wb.selenium.util.BusyPopup;
import org.kie.wb.selenium.util.ByUtil;
import org.kie.wb.selenium.util.Waits;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public class ImportProjectsScreen
extends PageObject {
    @FindBy(css=".uf-workbench-layout")
    private WebElement screenRoot;
    @FindBy(css="button.btn-primary")
    private WebElement okButton;

    public ImportProjectsScreen selectProjects(String ... projects) {
        for (String project : projects) {
            By projectCardLocator = ByUtil.xpath("//h2[@class='card-pf-title' and contains(text(), '%s')]", project);
            WebElement projectCard = Waits.elementPresent(projectCardLocator);
            this.waitForLoaded();
            projectCard.click();
        }
        return this;
    }

    public void ok() {
        this.okButton.click();
        Waits.pause(5000);
    }

    public static ImportProjectsScreen newInstance() {
        By screenRootLocator = By.cssSelector((String)".uf-workbench-layout");
        WebElement screenRoot = Waits.elementPresent(screenRootLocator);
        return (ImportProjectsScreen)Graphene.createPageFragment(ImportProjectsScreen.class, (WebElement)screenRoot);
    }

    public void waitForLoaded() {
        BusyPopup.waitForDisappearance();
    }
}

