/*
 * Decompiled with CFR 0.152.
 */
package org.kie.wb.test.rest.client;

import java.util.Collection;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.guvnor.rest.client.CloneProjectJobRequest;
import org.guvnor.rest.client.CloneProjectRequest;
import org.guvnor.rest.client.CompileProjectRequest;
import org.guvnor.rest.client.CreateProjectJobRequest;
import org.guvnor.rest.client.CreateProjectRequest;
import org.guvnor.rest.client.DeleteProjectRequest;
import org.guvnor.rest.client.DeployProjectRequest;
import org.guvnor.rest.client.InstallProjectRequest;
import org.guvnor.rest.client.JobRequest;
import org.guvnor.rest.client.JobResult;
import org.guvnor.rest.client.JobStatus;
import org.guvnor.rest.client.ProjectResponse;
import org.guvnor.rest.client.RemoveSpaceRequest;
import org.guvnor.rest.client.Space;
import org.guvnor.rest.client.SpaceRequest;
import org.guvnor.rest.client.TestProjectRequest;
import org.kie.wb.test.rest.client.Authenticator;
import org.kie.wb.test.rest.client.ClientRequestTimedOutException;
import org.kie.wb.test.rest.client.SpacesScreenLibraryPreference;
import org.kie.wb.test.rest.client.WorkbenchClient;
import org.kie.workbench.common.screens.library.api.SpacesScreenService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestWorkbenchClient
implements WorkbenchClient {
    private static final Logger log = LoggerFactory.getLogger(RestWorkbenchClient.class);
    private static final int DEFAULT_JOB_TIMEOUT_SECONDS = 60;
    private static final int DEFAULT_PROJECT_JOB_TIMEOUT_SECONDS = 60;
    private static final int DEFAULT_CLONE_REPO_TIMEOUT_SECONDS = 60;
    private final int jobTimeoutSeconds;
    private final int projectJobTimeoutSeconds;
    private final int cloneRepoTimeoutSeconds;
    private static final MediaType MEDIA_TYPE = MediaType.APPLICATION_JSON_TYPE;
    private final boolean async;
    private final WebTarget target;

    private RestWorkbenchClient(String appUrl, String userId, String password, boolean async, int jobTimeoutSeconds, int projectJobTimeoutSeconds, int cloneRepoTimeoutSeconds) {
        this.async = async;
        Client client = ClientBuilder.newClient();
        if (userId != null && password != null) {
            client.register((Object)new Authenticator(userId, password));
        }
        this.target = client.target(appUrl).path("rest");
        this.jobTimeoutSeconds = jobTimeoutSeconds;
        this.projectJobTimeoutSeconds = projectJobTimeoutSeconds;
        this.cloneRepoTimeoutSeconds = cloneRepoTimeoutSeconds;
    }

    private RestWorkbenchClient(String appUrl, String userId, String password, boolean async) {
        this(appUrl, userId, password, async, 60, 60, 60);
    }

    public static WorkbenchClient createAsyncWorkbenchClient(String appUrl, String userId, String password) {
        return new RestWorkbenchClient(appUrl, userId, password, true);
    }

    public static WorkbenchClient createWorkbenchClient(String appUrl, String userId, String password) {
        return new RestWorkbenchClient(appUrl, userId, password, false);
    }

    public static WorkbenchClient createWorkbenchClient(String appUrl, String userId, String password, int jobTimeoutSeconds, int projectJobTimeoutSeconds, int cloneRepoTimeoutSeconds) {
        return new RestWorkbenchClient(appUrl, userId, password, false, jobTimeoutSeconds, projectJobTimeoutSeconds, cloneRepoTimeoutSeconds);
    }

    @Override
    public JobResult getJob(String jobId) {
        log.info("Getting job '{}'", (Object)jobId);
        return (JobResult)this.target.path("jobs/{jobId}").resolveTemplate("jobId", (Object)jobId).request().get(JobResult.class);
    }

    @Override
    public JobResult deleteJob(String jobId) {
        log.info("Deleting job '{}'", (Object)jobId);
        return (JobResult)this.target.path("jobs/{jobId}").resolveTemplate("jobId", (Object)jobId).request().delete(JobResult.class);
    }

    @Override
    public ProjectResponse getProject(String spaceName, String projectName) {
        log.info("Getting project '{}'", (Object)spaceName);
        return (ProjectResponse)this.target.path("spaces/{spaceName}/projects/{projectName}").resolveTemplate("spaceName", (Object)spaceName).resolveTemplate("projectName", (Object)projectName).request().get(ProjectResponse.class);
    }

    @Override
    public CloneProjectJobRequest cloneRepository(String spaceName, CloneProjectRequest cloneProjectRequest) {
        log.info("Cloning a project '{}'", (Object)cloneProjectRequest.getName());
        CloneProjectJobRequest request = (CloneProjectJobRequest)this.target.path("/spaces/{spaceName}/git/clone").resolveTemplate("spaceName", (Object)spaceName).request().post(this.createEntity(cloneProjectRequest), CloneProjectJobRequest.class);
        return this.waitUntilJobFinished(request, this.cloneRepoTimeoutSeconds);
    }

    @Override
    public CreateProjectJobRequest createProject(String spaceName, String projectName, String groupId, String version) {
        return this.createProject(spaceName, projectName, groupId, version, null);
    }

    @Override
    public CreateProjectJobRequest createProject(String spaceName, String projectName, String groupId, String version, String description) {
        CreateProjectRequest createProjectRequest = new CreateProjectRequest();
        createProjectRequest.setGroupId(groupId);
        createProjectRequest.setVersion(version);
        createProjectRequest.setName(projectName);
        createProjectRequest.setDescription(description);
        return this.createProject(spaceName, createProjectRequest);
    }

    @Override
    public CreateProjectJobRequest createProject(String spaceName, CreateProjectRequest createProjectRequest) {
        log.info("Creating project '{}' in space '{}'", (Object)createProjectRequest.getName(), (Object)spaceName);
        CreateProjectJobRequest request = (CreateProjectJobRequest)this.target.path("spaces/{spaceName}/projects").resolveTemplate("spaceName", (Object)spaceName).request().post(this.createEntity(createProjectRequest), CreateProjectJobRequest.class);
        return this.waitUntilJobFinished(request, this.projectJobTimeoutSeconds);
    }

    @Override
    public DeleteProjectRequest deleteProject(String spaceName, String projectName) {
        log.info("Removing project '{}' from space '{}'", (Object)projectName, (Object)spaceName);
        DeleteProjectRequest request = (DeleteProjectRequest)this.target.path("spaces/{spaceName}/projects/{projectName}").resolveTemplate("spaceName", (Object)spaceName).resolveTemplate("projectName", (Object)projectName).request().delete(DeleteProjectRequest.class);
        return this.waitUntilJobFinished(request, this.projectJobTimeoutSeconds);
    }

    @Override
    public Collection<ProjectResponse> getProjects(String spaceName) {
        log.info("Retrieving all projects from space '{}'", (Object)spaceName);
        return (Collection)this.target.path("spaces/{spaceName}/projects").resolveTemplate("spaceName", (Object)spaceName).request().get((GenericType)new GenericType<Collection<ProjectResponse>>(){});
    }

    @Override
    public Collection<Space> getSpaces() {
        log.info("Getting all spaces");
        return (Collection)this.target.path("spaces").request().get((GenericType)new GenericType<Collection<Space>>(){});
    }

    @Override
    public SpaceRequest createSpace(String spaceName, String owner) {
        return this.createSpace(spaceName, owner, null);
    }

    @Override
    public SpaceRequest createSpace(String spaceName, String owner, String description) {
        return this.createSpace(spaceName, owner, description, null);
    }

    @Override
    public SpaceRequest createSpace(String spaceName, String owner, String description, String groupId) {
        Space space = new Space();
        space.setName(spaceName);
        space.setOwner(owner);
        space.setDescription(description);
        space.setDefaultGroupId(groupId);
        return this.createSpace(space);
    }

    @Override
    public SpaceRequest createSpace(Space spaceName) {
        log.info("Creating space '{}' ", (Object)spaceName.getName());
        SpaceRequest request = (SpaceRequest)this.target.path("spaces").request().post(this.createEntity(spaceName), SpaceRequest.class);
        return this.waitUntilJobFinished(request);
    }

    @Override
    public Space getSpace(String spaceNameName) {
        log.info("Getting space '{}'", (Object)spaceNameName);
        return (Space)this.target.path("spaces/{spaceName}").resolveTemplate("spaceName", (Object)spaceNameName).request().get(Space.class);
    }

    @Override
    public String isReady() {
        log.info("Getting readiness status");
        return (String)this.target.path("ready").request().get(String.class);
    }

    @Override
    public String isHealthy() {
        log.info("Getting health status");
        return (String)this.target.path("healthy").request().get(String.class);
    }

    @Override
    public RemoveSpaceRequest deleteSpace(String name) {
        log.info("Deleting space '{}'", (Object)name);
        RemoveSpaceRequest request = (RemoveSpaceRequest)this.target.path("spaces/{spaceName}").resolveTemplate("spaceName", (Object)name).request().delete(RemoveSpaceRequest.class);
        return this.waitUntilJobFinished(request);
    }

    private <T extends JobRequest> T postMavenRequest(String spaceName, String projectName, String phase, Class<T> requestType) {
        return (T)((JobRequest)this.target.path("spaces/{spaceName}/projects/{projectName}/maven/{phase}").resolveTemplate("spaceName", (Object)spaceName).resolveTemplate("projectName", (Object)projectName).resolveTemplate("phase", (Object)phase).request().post(this.createEntity(""), requestType));
    }

    @Override
    public CompileProjectRequest compileProject(String spaceName, String projectName) {
        log.info("Compiling project '{}' from space '{}'", (Object)projectName, (Object)spaceName);
        CompileProjectRequest request = this.postMavenRequest(spaceName, projectName, "compile", CompileProjectRequest.class);
        return this.waitUntilJobFinished(request, this.projectJobTimeoutSeconds);
    }

    @Override
    public InstallProjectRequest installProject(String spaceName, String projectName) {
        log.info("Installing project '{}' from space '{}'", (Object)projectName, (Object)spaceName);
        InstallProjectRequest request = this.postMavenRequest(spaceName, projectName, "install", InstallProjectRequest.class);
        return this.waitUntilJobFinished(request, this.projectJobTimeoutSeconds);
    }

    @Override
    public TestProjectRequest testProject(String spaceName, String projectName) {
        log.info("Testing project '{}' from space '{}'", (Object)projectName, (Object)spaceName);
        TestProjectRequest request = this.postMavenRequest(spaceName, projectName, "test", TestProjectRequest.class);
        return this.waitUntilJobFinished(request, this.projectJobTimeoutSeconds);
    }

    @Override
    public DeployProjectRequest deployProject(String spaceName, String projectName) {
        log.info("Deploying project '{}' from space '{}'", (Object)projectName, (Object)spaceName);
        DeployProjectRequest request = this.postMavenRequest(spaceName, projectName, "deploy", DeployProjectRequest.class);
        return this.waitUntilJobFinished(request, this.projectJobTimeoutSeconds);
    }

    @Override
    public Response spacesScreen_getSpaces() {
        return this.target.path("spacesScreen/spaces").request().get();
    }

    @Override
    public Response spacesScreen_savePreference(SpacesScreenLibraryPreference preference) {
        return this.target.path("spacesScreen/libraryPreference").request().put(this.createEntity(preference));
    }

    @Override
    public Response spacesScreen_getSpace(String name) {
        return this.target.path("spacesScreen/spaces/{name}").resolveTemplate("name", (Object)name).request().get();
    }

    @Override
    public boolean spacesScreen_isValidGroupId(String groupId) {
        return (Boolean)this.target.path("spacesScreen/spaces/validGroupId").queryParam("groupId", new Object[]{groupId}).request().get(Boolean.class);
    }

    @Override
    public Response spacesScreen_postSpace(SpacesScreenService.NewSpace newSpace) {
        return this.target.path("spacesScreen/spaces").request().post(this.createEntity(newSpace));
    }

    private <T extends JobRequest> T waitUntilJobFinished(T request) {
        return this.waitUntilJobFinished(request, this.jobTimeoutSeconds);
    }

    private <T extends JobRequest> T waitUntilJobFinished(T request, int seconds) {
        JobResult jobResult;
        if (this.async) {
            return request;
        }
        int totalSecondsWaited = 0;
        block4: while ((jobResult = this.getJob(request.getJobId())).getStatus() != JobStatus.SUCCESS && seconds-- > 0) {
            switch (jobResult.getStatus()) {
                case ACCEPTED: 
                case APPROVED: {
                    this.sleepForSecond();
                    ++totalSecondsWaited;
                    continue block4;
                }
                case SUCCESS: {
                    log.info("  It took {} seconds to complete the job", (Object)totalSecondsWaited);
                    return request;
                }
            }
            log.warn("  Timeout waiting {} seconds for job to succeed", (Object)totalSecondsWaited);
            throw new ClientRequestTimedOutException(jobResult, totalSecondsWaited);
        }
        if (jobResult.getStatus() != JobStatus.SUCCESS) {
            log.warn("  Timeout waiting {} seconds for job to succeed", (Object)totalSecondsWaited);
            throw new ClientRequestTimedOutException(jobResult, totalSecondsWaited);
        }
        return request;
    }

    private void sleepForSecond() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private <T> Entity<T> createEntity(T body) {
        return Entity.entity(body, (MediaType)MEDIA_TYPE);
    }
}

