/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datasource.management.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import javax.enterprise.context.ApplicationScoped;
import org.apache.maven.project.MavenProject;
import org.appformer.maven.integration.Aether;
import org.appformer.maven.integration.embedder.MavenProjectLoader;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResult;
import org.guvnor.common.services.project.backend.server.utils.POMContentHandler;
import org.guvnor.common.services.project.model.Dependency;
import org.guvnor.common.services.project.model.GAV;
import org.guvnor.common.services.project.model.POM;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class MavenArtifactResolver {
    private static final Logger logger = LoggerFactory.getLogger(MavenArtifactResolver.class);
    private static final String JAR_ARTIFACT = "jar";
    private POMContentHandler pomContentHandler = new POMContentHandler();

    public URI resolve(String groupId, String artifactId, String version) throws Exception {
        return this.internalResolver(MavenProjectLoader.IS_FORCE_OFFLINE, groupId, artifactId, version);
    }

    URI internalResolver(boolean isOffline, String groupId, String artifactId, String version) throws Exception {
        try {
            if (!isOffline) {
                return this.resolveEmbedded(groupId, artifactId, version);
            }
            GAV gav = new GAV(groupId, artifactId, version);
            DefaultArtifact jarArtifact = new DefaultArtifact(gav.getGroupId(), gav.getArtifactId(), JAR_ARTIFACT, gav.getVersion());
            RepositorySystemSession session = Aether.getAether().getSession();
            ArtifactRequest artifactReq = new ArtifactRequest();
            artifactReq.setArtifact((Artifact)jarArtifact);
            ArtifactResult result = Aether.getAether().getSystem().resolveArtifact(session, artifactReq);
            return result.getArtifact().getFile().toURI();
        }
        catch (Exception e) {
            logger.error("Unable to get artifact: " + groupId + ":" + artifactId + ":" + version + " from maven repository", (Throwable)e);
            throw new Exception("Unable to get artifact: " + groupId + ":" + artifactId + ":" + version + " from maven repository", e);
        }
    }

    URI resolveEmbedded(String groupId, String artifactId, String version) throws IOException {
        POM projectPom = new POM(new GAV("resolver-dummy-group", "resolver-dummy-artifact", "resolver-dummy-version"));
        projectPom.getDependencies().add(new Dependency(new GAV(groupId, artifactId, version)));
        String pomXML = this.pomContentHandler.toString(projectPom);
        ByteArrayInputStream pomStream = new ByteArrayInputStream(pomXML.getBytes(StandardCharsets.UTF_8));
        MavenProject mavenProject = MavenProjectLoader.parseMavenPom((InputStream)pomStream);
        for (org.apache.maven.artifact.Artifact mavenArtifact : mavenProject.getArtifacts()) {
            if (!groupId.equals(mavenArtifact.getGroupId()) || !artifactId.equals(mavenArtifact.getArtifactId()) || !version.equals(mavenArtifact.getVersion()) || !mavenArtifact.getFile().exists()) continue;
            return mavenArtifact.getFile().toURI();
        }
        return null;
    }
}

