/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.graph.processing.layout.sugiyama;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.kie.workbench.common.stunner.core.graph.processing.layout.OrientedEdgeImpl;
import org.kie.workbench.common.stunner.core.graph.processing.layout.ReorderedGraph;
import org.kie.workbench.common.stunner.core.graph.processing.layout.sugiyama.GraphLayer;
import org.kie.workbench.common.stunner.core.graph.processing.layout.sugiyama.OrientedEdge;

public final class LayeredGraph
implements ReorderedGraph {
    private final List<String> vertices = new ArrayList<String>();
    private final List<OrientedEdge> edges = new ArrayList<OrientedEdge>();
    private final List<GraphLayer> layers = new ArrayList<GraphLayer>();

    public LayeredGraph() {
    }

    public LayeredGraph(String[][] edgesMatrix) {
        this();
        for (String[] edge : edgesMatrix) {
            this.addEdge(edge[0], edge[1]);
        }
    }

    public void addEdge(String from, String to) {
        this.addEdge(new OrientedEdgeImpl(from, to));
    }

    public void addEdge(OrientedEdgeImpl edge) {
        if (!this.edges.contains(edge)) {
            this.edges.add(edge);
        }
        if (!this.vertices.contains(edge.getFromVertexId())) {
            this.vertices.add(edge.getFromVertexId());
        }
        if (!this.vertices.contains(edge.getToVertexId())) {
            this.vertices.add(edge.getToVertexId());
        }
    }

    public List<GraphLayer> getLayers() {
        return this.layers;
    }

    public List<String> getVertices() {
        return this.vertices;
    }

    public List<OrientedEdge> getEdges() {
        return this.edges;
    }

    public boolean isAcyclic() {
        HashSet<String> visited = new HashSet<String>();
        for (String vertex : this.vertices) {
            if (!this.leadsToACycle(vertex, visited)) continue;
            return false;
        }
        return true;
    }

    private boolean leadsToACycle(String vertex, HashSet<String> visited) {
        String[] verticesFromThis;
        if (visited.contains(vertex)) {
            return true;
        }
        visited.add(vertex);
        for (String nextVertex : verticesFromThis = this.getVerticesFrom(vertex)) {
            if (!this.leadsToACycle(nextVertex, visited)) continue;
            return true;
        }
        visited.remove(vertex);
        return false;
    }

    public String[] getVerticesFrom(String vertex) {
        HashSet<String> verticesFrom = new HashSet<String>();
        for (OrientedEdge edge : this.edges) {
            if (!Objects.equals(edge.getFromVertexId(), vertex)) continue;
            verticesFrom.add(edge.getToVertexId());
        }
        return verticesFrom.toArray(new String[0]);
    }
}

