/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.projecteditor.backend.server;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.guvnor.common.services.project.model.POM;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.guvnor.common.services.project.service.DeploymentMode;
import org.guvnor.common.services.project.service.POMService;
import org.guvnor.common.services.project.service.WorkspaceProjectService;
import org.guvnor.common.services.shared.metadata.MetadataService;
import org.guvnor.structure.repositories.Branch;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryCopier;
import org.guvnor.structure.repositories.RepositoryService;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.workbench.common.screens.projecteditor.backend.server.ProjectScreenModelLoader;
import org.kie.workbench.common.screens.projecteditor.backend.server.ProjectScreenModelSaver;
import org.kie.workbench.common.screens.projecteditor.model.ProjectScreenModel;
import org.kie.workbench.common.screens.projecteditor.service.ProjectScreenService;
import org.kie.workbench.common.services.shared.project.KieModuleService;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.java.nio.file.Path;

@Service
@ApplicationScoped
public class ProjectScreenServiceImpl
implements ProjectScreenService {
    private WorkspaceProjectService projectService;
    private RepositoryService repositoryService;
    private KieModuleService moduleService;
    private ProjectScreenModelLoader loader;
    private ProjectScreenModelSaver saver;
    private RepositoryCopier repositoryCopier;
    private POMService pomService;
    private MetadataService metadataService;

    public ProjectScreenServiceImpl() {
    }

    @Inject
    public ProjectScreenServiceImpl(WorkspaceProjectService projectService, RepositoryService repositoryService, KieModuleService moduleService, ProjectScreenModelLoader loader, ProjectScreenModelSaver saver, RepositoryCopier repositoryCopier, POMService pomService, MetadataService metadataService) {
        this.projectService = projectService;
        this.repositoryService = repositoryService;
        this.moduleService = moduleService;
        this.loader = loader;
        this.saver = saver;
        this.repositoryCopier = repositoryCopier;
        this.pomService = pomService;
        this.metadataService = metadataService;
    }

    public ProjectScreenModel load(org.uberfire.backend.vfs.Path pathToPom) {
        return this.loader.load(pathToPom);
    }

    public void save(org.uberfire.backend.vfs.Path pathToPomXML, ProjectScreenModel model, String comment) {
        this.save(pathToPomXML, model, comment, DeploymentMode.VALIDATED);
    }

    public WorkspaceProject save(org.uberfire.backend.vfs.Path pathToPomXML, ProjectScreenModel model, String comment, DeploymentMode mode) {
        this.saver.save(pathToPomXML, model, mode, comment);
        return this.projectService.resolveProject(pathToPomXML);
    }

    public void delete(WorkspaceProject project) {
        this.repositoryService.removeRepository(project.getRepository().getSpace(), project.getRepository().getAlias());
    }

    public void copy(WorkspaceProject project, String newName) {
        String newUniqueName = this.projectService.createFreshProjectName(project.getOrganizationalUnit(), newName);
        Repository copy = this.repositoryCopier.copy(project.getOrganizationalUnit(), newName, project.getRootPath());
        if (!copy.getDefaultBranch().isPresent()) {
            throw new IllegalStateException("Copy should have at least one branch.");
        }
        org.uberfire.backend.vfs.Path newPomPath = Paths.convert((Path)Paths.convert((org.uberfire.backend.vfs.Path)((Branch)copy.getDefaultBranch().get()).getPath()).resolve("pom.xml"));
        POM pom = (POM)this.pomService.load(newPomPath);
        if (pom != null) {
            pom.setName(newUniqueName);
            pom.getGav().setArtifactId(newName);
            this.pomService.save(newPomPath, pom, this.metadataService.getMetadata(newPomPath), "Renaming the project.", true);
        }
    }

    public void reImport(org.uberfire.backend.vfs.Path pathToPomXML) {
        this.moduleService.reImport(pathToPomXML);
    }
}

