/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.migration;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.spaces.SpacesAPIImpl;
import org.uberfire.commons.cluster.ClusterParameters;
import org.uberfire.commons.services.cdi.Startup;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.IOException;
import org.uberfire.java.nio.file.CopyOption;
import org.uberfire.java.nio.file.DeleteOption;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.FileSystemAlreadyExistsException;
import org.uberfire.java.nio.file.FileVisitResult;
import org.uberfire.java.nio.file.FileVisitor;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.SimpleFileVisitor;
import org.uberfire.java.nio.file.attribute.BasicFileAttributes;
import org.uberfire.java.nio.fs.jgit.JGitFileSystem;
import org.uberfire.spaces.SpacesAPI;

@ApplicationScoped
@Startup
public class DashbuilderDataMigration {
    private static final Logger LOGGER = LoggerFactory.getLogger(DashbuilderDataMigration.class);
    private IOService ioService;
    private FileSystem datasetsFS;
    private FileSystem pluginsFS;
    private FileSystem perspectivesFS;
    private FileSystem navigationFS;
    private ClusterParameters clusterParameters = new ClusterParameters();

    public DashbuilderDataMigration() {
    }

    @Inject
    public DashbuilderDataMigration(@Named(value="ioStrategy") IOService ioService, @Named(value="datasetsFS") FileSystem datasetsFS, @Named(value="pluginsFS") FileSystem pluginsFS, @Named(value="perspectivesFS") FileSystem perspectivesFS, @Named(value="navigationFS") FileSystem navigationFS) {
        this.ioService = ioService;
        this.datasetsFS = datasetsFS;
        this.pluginsFS = pluginsFS;
        this.perspectivesFS = perspectivesFS;
        this.navigationFS = navigationFS;
    }

    @PostConstruct
    private void init() {
        try {
            if (!this.clusterParameters.isAppFormerClustered()) {
                this.migrateDatasets();
                this.migratePerspectives();
                this.migrateNavigation();
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed during dashbuilder migration process.");
            LOGGER.debug("Error during dashbuilder migration", (Throwable)e);
        }
    }

    private void migrateDatasets() {
        FileSystem oldDatasetsFS = this.lookupOldDataSetsFS();
        this.migrateDatasets(oldDatasetsFS, this.datasetsFS);
        this.cleanupDataSets(oldDatasetsFS);
    }

    private FileSystem lookupOldDataSetsFS() {
        FileSystem oldDatasetsFS;
        URI uri = new SpacesAPIImpl().resolveFileSystemURI(SpacesAPI.Scheme.DEFAULT, SpacesAPI.DEFAULT_SPACE, "datasets");
        try {
            oldDatasetsFS = this.ioService.newFileSystem(uri, (Map)new HashMap<String, Object>(){
                {
                    this.put("init", Boolean.TRUE);
                    this.put("internal", Boolean.TRUE);
                }
            });
        }
        catch (FileSystemAlreadyExistsException e) {
            oldDatasetsFS = this.ioService.getFileSystem(uri);
        }
        return oldDatasetsFS;
    }

    private void cleanupDataSets(FileSystem oldDatasetsFS) {
        Path oldDatasetsRoot = this.getRoot(oldDatasetsFS);
        if (oldDatasetsRoot != null && oldDatasetsFS instanceof JGitFileSystem) {
            try {
                Path fsPath = oldDatasetsFS.getPath("", new String[0]);
                Files.delete((Path)fsPath, (DeleteOption[])new DeleteOption[0]);
            }
            catch (Exception e) {
                LOGGER.error("Failed to remove the datasets git repository.");
                LOGGER.debug("Error during dashbuilder migration", (Throwable)e);
            }
        }
    }

    private void migratePerspectives() {
        this.migratePerspectives(this.pluginsFS, this.perspectivesFS);
    }

    private void migrateNavigation() {
        this.migrateNavigation(this.pluginsFS, this.navigationFS);
    }

    public void migrateDatasets(FileSystem sourceFS, FileSystem targetFS) {
        LOGGER.info("attempt to migrate datasets");
        this.migrate(sourceFS, targetFS, path -> !path.getFileName().toString().equals("readme.md"));
    }

    public void migratePerspectives(FileSystem sourceFS, FileSystem targetFS) {
        LOGGER.info("attempt to migrate perspectives");
        this.migrate(sourceFS, targetFS, path -> path.getFileName().toString().startsWith("perspective_layout"));
    }

    public void migrateNavigation(FileSystem sourceFS, FileSystem targetFS) {
        LOGGER.info("attempt to migrate navigation");
        this.migrate(sourceFS, targetFS, path -> path.getFileName().toString().equals("navtree.json"));
    }

    private void migrate(FileSystem sourceFS, FileSystem targetFS, final Predicate<Path> predicate) {
        Path sourceRoot = this.getRoot(sourceFS);
        final Path targetRoot = this.getRoot(targetFS);
        if (sourceRoot == null) {
            LOGGER.info("source does not exists");
            return;
        }
        if (targetRoot == null) {
            LOGGER.error("target does not exists");
            return;
        }
        LOGGER.info("moving from " + sourceFS.getName() + " to " + targetFS.getName());
        Files.walkFileTree((Path)sourceRoot, (FileVisitor)new SimpleFileVisitor<Path>(){

            public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
                PortablePreconditions.checkNotNull((String)"file", (Object)path);
                PortablePreconditions.checkNotNull((String)"attrs", (Object)attrs);
                Path targetPath = targetRoot.resolve(path.toString());
                if (!predicate.test(path)) {
                    LOGGER.debug("skip file " + path.toString());
                } else if (DashbuilderDataMigration.this.ioService.exists(targetPath)) {
                    LOGGER.debug("file " + path.toString() + " already exists on target");
                    Files.delete((Path)path, (DeleteOption[])new DeleteOption[0]);
                } else {
                    LOGGER.debug("moving file " + path.toString());
                    Files.copy((Path)path, (Path)targetPath, (CopyOption[])new CopyOption[0]);
                    Files.delete((Path)path, (DeleteOption[])new DeleteOption[0]);
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private Path getRoot(FileSystem fileSystem) {
        try {
            return (Path)fileSystem.getRootDirectories().iterator().next();
        }
        catch (Exception e) {
            LOGGER.debug("could not get filesystem root", (Throwable)e);
            return null;
        }
    }
}

