/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.marshaller;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.jboss.errai.common.client.api.annotations.MapsTo;
import org.jboss.errai.common.client.api.annotations.Portable;
import org.kie.workbench.common.stunner.core.marshaller.MarshallingMessage;
import org.kie.workbench.common.stunner.core.util.HashUtil;

@Portable
public class MarshallingResponse<T> {
    private final List<MarshallingMessage> messages;
    private final State state;
    private final Optional<T> result;

    private MarshallingResponse(@MapsTo(value="messages") List<MarshallingMessage> messages, @MapsTo(value="state") State state, @MapsTo(value="result") Optional<T> result) {
        this.messages = messages;
        this.state = state;
        this.result = result;
    }

    public List<MarshallingMessage> getMessages() {
        return this.messages;
    }

    public State getState() {
        return this.state;
    }

    public Optional<T> getResult() {
        return this.result;
    }

    public static <T> MarshallingResponseBuilder<T> builder() {
        return new MarshallingResponseBuilder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("MarshallingResponse{");
        sb.append("messages=").append(this.messages);
        sb.append(", state=").append((Object)this.state);
        sb.append(", result=").append(this.result);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MarshallingResponse)) {
            return false;
        }
        MarshallingResponse that = (MarshallingResponse)o;
        return Objects.equals(this.getMessages(), that.getMessages()) && this.getState() == that.getState() && Objects.equals(this.getResult(), that.getResult());
    }

    public int hashCode() {
        return HashUtil.combineHashCodes((int[])new int[]{Objects.hashCode(this.getMessages()), Objects.hashCode((Object)this.getState()), Objects.hashCode(this.getResult())});
    }

    public boolean isSuccess() {
        return State.SUCCESS.equals((Object)this.state);
    }

    public boolean isError() {
        return State.ERROR.equals((Object)this.state);
    }

    public static class MarshallingResponseBuilder<T> {
        private final List<MarshallingMessage> messages = new ArrayList<MarshallingMessage>();
        private State state;
        private Optional<T> result = Optional.empty();

        public MarshallingResponseBuilder<T> messages(List<MarshallingMessage> messages) {
            this.messages.addAll(messages);
            return this;
        }

        public MarshallingResponseBuilder<T> addMessage(MarshallingMessage message) {
            this.messages.add(message);
            return this;
        }

        public MarshallingResponseBuilder<T> state(State state) {
            this.state = state;
            return this;
        }

        public MarshallingResponseBuilder<T> result(T result) {
            this.result = Optional.ofNullable(result);
            return this;
        }

        public MarshallingResponse build() {
            return new MarshallingResponse(this.messages, this.state, this.result);
        }
    }

    public static enum State {
        ERROR,
        SUCCESS;

    }
}

