/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.backend.runner;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.scenariosimulation.api.model.ScenarioWithIndex;
import org.drools.scenariosimulation.api.model.SimulationRunMetadata;
import org.drools.scenariosimulation.backend.runner.model.ScenarioResultMetadata;

public class SimulationRunMetadataBuilder {
    protected List<ScenarioResultMetadata> scenarioResultMetadata = new ArrayList<ScenarioResultMetadata>();

    private SimulationRunMetadataBuilder() {
    }

    public SimulationRunMetadataBuilder addScenarioResultMetadata(ScenarioResultMetadata scenarioResultMetadata) {
        this.scenarioResultMetadata.add(scenarioResultMetadata);
        return this;
    }

    public SimulationRunMetadata build() {
        int available = 0;
        HashMap outputCounter = new HashMap();
        HashMap<ScenarioWithIndex, Map<String, Integer>> scenarioCounter = new HashMap<ScenarioWithIndex, Map<String, Integer>>();
        for (ScenarioResultMetadata scenarioResultMetadatum : this.scenarioResultMetadata) {
            available = scenarioResultMetadatum.getAvailable().size();
            scenarioResultMetadatum.getExecutedWithCounter().forEach((name, counter) -> outputCounter.compute(name, (key, number) -> number == null ? counter : number + counter));
        }
        for (ScenarioResultMetadata scenarioResultMetadatum : this.scenarioResultMetadata) {
            scenarioCounter.put(scenarioResultMetadatum.getScenarioWithIndex(), scenarioResultMetadatum.getExecutedWithCounter());
        }
        return new SimulationRunMetadata(available, outputCounter.keySet().size(), outputCounter, scenarioCounter);
    }

    public static SimulationRunMetadataBuilder create() {
        return new SimulationRunMetadataBuilder();
    }
}

