/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.navigation.storage;

import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.dashbuilder.navigation.NavTree;
import org.dashbuilder.navigation.json.NavTreeJSONMarshaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;

@ApplicationScoped
public class NavTreeStorage {
    private IOService ioService;
    private NavTreeJSONMarshaller jsonMarshaller;
    private Path root;
    private Logger log = LoggerFactory.getLogger(NavTreeStorage.class);
    private FileSystem fileSystem;

    public NavTreeStorage() {
    }

    @Inject
    public NavTreeStorage(@Named(value="ioStrategy") IOService ioService, @Named(value="navigationFS") FileSystem fileSystem) {
        this.ioService = ioService;
        this.fileSystem = fileSystem;
        this.jsonMarshaller = NavTreeJSONMarshaller.get();
    }

    @PostConstruct
    public void init() {
        this.root = (Path)this.fileSystem.getRootDirectories().iterator().next();
    }

    protected Path getNavRootPath() {
        return this.root.resolve("navigation");
    }

    protected Path getNavTreePath() {
        return this.getNavRootPath().resolve("navtree.json");
    }

    public NavTree loadNavTree() {
        Path path = this.getNavTreePath();
        if (!this.ioService.exists(path)) {
            return null;
        }
        try {
            String json = this.ioService.readAllString(path);
            return this.jsonMarshaller.fromJson(json);
        }
        catch (Exception e) {
            this.log.error("Error parsing json definition: " + path.getFileName(), (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveNavTree(NavTree navTree) {
        this.ioService.startBatch(this.fileSystem);
        try {
            String json = this.jsonMarshaller.toJson(navTree).toString();
            Path path = this.getNavTreePath();
            this.ioService.write(path, json, new OpenOption[0]);
        }
        catch (Exception e) {
            this.log.error("Can't save the navigation tree.", (Throwable)e);
        }
        finally {
            this.ioService.endBatch();
        }
    }
}

