/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import org.eclipse.bpmn2.Assignment;
import org.eclipse.bpmn2.DataInput;
import org.eclipse.bpmn2.DataInputAssociation;
import org.eclipse.bpmn2.DataOutput;
import org.eclipse.bpmn2.DataOutputAssociation;
import org.eclipse.bpmn2.FormalExpression;
import org.eclipse.bpmn2.impl.PropertyImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties.InitializedVariable;
import org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties.VariableDeclaration;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.Ids;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.FlatVariableScope;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.VariableScope;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.Scripts;

public class InitializedVariableTest {
    private VariableScope varScope;

    @Test
    public void urlDecodeConstants() throws UnsupportedEncodingException {
        String expected = "<<<#!!!#>>>";
        String encoded = URLEncoder.encode(expected, "UTF-8");
        VariableDeclaration variable = new VariableDeclaration("ID", "Object");
        InitializedVariable.InputConstant c = new InitializedVariable.InputConstant("PARENT", variable, encoded);
        Assignment assignment = (Assignment)c.getDataInputAssociation().getAssignment().get(0);
        FormalExpression to = (FormalExpression)assignment.getTo();
        Assert.assertEquals((Object)Ids.dataInput((String)"PARENT", (String)"ID"), (Object)to.getBody());
        FormalExpression from = (FormalExpression)assignment.getFrom();
        Assert.assertEquals((Object)Scripts.asCData((String)expected), (Object)from.getBody());
    }

    @Before
    public void setup() {
        this.varScope = new FlatVariableScope();
        this.varScope.declare("", "BooleanSource", "Boolean");
        this.varScope.declare("", "BooleanTarget", "Boolean");
    }

    @Test
    public void testGetDataInput() {
        String SOURCE_VAR = "BooleanSource";
        String DATA_INPUT_ID = "_Data-Input-TestInputX";
        String DATA_INPUT_NAME = "Data Input Test";
        String DATA_INPUT_ASSOCIATION_ID = "Data Input Test";
        String DATA_INPUT_ASSOCIATION_VALUE = "BooleanSource";
        String INIT_INPUT_VAR_ID = "Data-Input-Test";
        String INIT_INPUT_VAR_TYPE = "Boolean";
        VariableDeclaration varDeclaration = new VariableDeclaration("Data Input Test", "Boolean");
        InitializedVariable.InputVariableReference initializedInputVar = new InitializedVariable.InputVariableReference("", this.varScope, varDeclaration, "BooleanSource");
        DataInput dataInput = initializedInputVar.getDataInput();
        DataInputAssociation dataInputAssociation = initializedInputVar.getDataInputAssociation();
        List sourceRef = dataInputAssociation.getSourceRef();
        PropertyImpl source = (PropertyImpl)sourceRef.get(0);
        DataInput target = (DataInput)dataInputAssociation.getTargetRef();
        String dataInputId = dataInput.getId();
        String dataInputName = dataInput.getName();
        String dataInputAssociationID = target.getName();
        String dataInputAssociationValue = source.getId();
        String initVarID = initializedInputVar.getIdentifier();
        String initVarType = initializedInputVar.getType();
        Assert.assertEquals((Object)dataInputId, (Object)"_Data-Input-TestInputX");
        Assert.assertEquals((Object)dataInputName, (Object)"Data Input Test");
        Assert.assertEquals((Object)dataInputAssociationID, (Object)"Data Input Test");
        Assert.assertEquals((Object)dataInputAssociationValue, (Object)"BooleanSource");
        Assert.assertEquals((Object)initVarID, (Object)"Data-Input-Test");
        Assert.assertEquals((Object)initVarType, (Object)"Boolean");
    }

    @Test
    public void testGetDataOuput() {
        VariableDeclaration varDeclaration = new VariableDeclaration("Data Output Test", "Boolean");
        String TARGET_VAR = "BooleanTarget";
        String DATA_OUTPUT_ID = "_Data-Output-TestOutputX";
        String DATA_OUTPUT_NAME = "Data Output Test";
        String DATA_OUTPUT_ASSOCIATION_ID = "Data Output Test";
        String DATA_OUTPUT_ASSOCIATION_VALUE = "BooleanTarget";
        String INIT_OUTPUT_VAR_ID = "Data-Output-Test";
        String INIT_OUTPUT_VAR_TYPE = "Boolean";
        InitializedVariable.OutputVariableReference initializedOutputVar = new InitializedVariable.OutputVariableReference("", this.varScope, varDeclaration, "BooleanTarget");
        DataOutput dataOuput = initializedOutputVar.getDataOutput();
        DataOutputAssociation dataOutputAssociation = initializedOutputVar.getDataOutputAssociation();
        List sourceRef = dataOutputAssociation.getSourceRef();
        DataOutput source = (DataOutput)sourceRef.get(0);
        PropertyImpl target = (PropertyImpl)dataOutputAssociation.getTargetRef();
        String dataOuputID = dataOuput.getId();
        String dataOutputName = dataOuput.getName();
        String dataOutputAssociationID = source.getName();
        String dataOutputAssocationValue = target.getId();
        String initVarID = initializedOutputVar.getIdentifier();
        String initVarType = initializedOutputVar.getType();
        Assert.assertEquals((Object)dataOuputID, (Object)"_Data-Output-TestOutputX");
        Assert.assertEquals((Object)dataOutputName, (Object)"Data Output Test");
        Assert.assertEquals((Object)dataOutputAssociationID, (Object)"Data Output Test");
        Assert.assertEquals((Object)dataOutputAssocationValue, (Object)"BooleanTarget");
        Assert.assertEquals((Object)initVarID, (Object)"Data-Output-Test");
        Assert.assertEquals((Object)initVarType, (Object)"Boolean");
    }
}

