/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties;

import org.assertj.core.api.Assertions;
import org.eclipse.bpmn2.FormalExpression;
import org.eclipse.bpmn2.MultiInstanceLoopCharacteristics;
import org.eclipse.bpmn2.SubProcess;
import org.junit.Test;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.Factories;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.FlatVariableScope;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.MultipleInstanceSubProcessPropertyWriter;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.VariableScope;

public class MultipleInstanceSubProcessPropertyWriterTest {
    @Test
    public void nullInputOutputsShouldNotThrow() {
        SubProcess subProcess = Factories.bpmn2.createSubProcess();
        MultipleInstanceSubProcessPropertyWriter p = new MultipleInstanceSubProcessPropertyWriter(subProcess, (VariableScope)new FlatVariableScope());
        Assertions.assertThatCode(() -> {
            p.setInput(null);
            p.setOutput(null);
            MultipleInstanceSubProcessPropertyWriter.createDataInput(null, null);
            MultipleInstanceSubProcessPropertyWriter.createDataOutput(null, null);
            p.setCompletionCondition(null);
        }).doesNotThrowAnyException();
    }

    @Test
    public void completionConditionMustBeWrappedInCdata() {
        String expression = "x<1";
        String expected = "<![CDATA[" + expression + "]]>";
        SubProcess subProcess = Factories.bpmn2.createSubProcess();
        MultipleInstanceSubProcessPropertyWriter p = new MultipleInstanceSubProcessPropertyWriter(subProcess, (VariableScope)new FlatVariableScope());
        p.setCompletionCondition(expression);
        MultiInstanceLoopCharacteristics loopCharacteristics = (MultiInstanceLoopCharacteristics)subProcess.getLoopCharacteristics();
        FormalExpression completionCondition = (FormalExpression)loopCharacteristics.getCompletionCondition();
        Assertions.assertThat((String)expected).isEqualTo((Object)completionCondition.getBody());
    }
}

