/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.di.BPMNEdge;
import org.eclipse.bpmn2.di.BPMNShape;
import org.eclipse.dd.dc.Bounds;
import org.eclipse.dd.dc.Point;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.BasePropertyWriter;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.util.PropertyWriterUtils;
import org.kie.workbench.common.stunner.bpmn.definition.BPMNViewDefinition;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.relationship.Dock;
import org.kie.workbench.common.stunner.core.graph.content.view.Connection;
import org.kie.workbench.common.stunner.core.graph.content.view.ControlPoint;
import org.kie.workbench.common.stunner.core.graph.content.view.Point2D;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.content.view.ViewConnector;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class PropertyWriterUtilsTest {
    private static final String SOURCE_SHAPE_ID = "SOURCE_SHAPE_ID";
    private static final String TARGET_SHAPE_ID = "TARGET_SHAPE_ID";
    @Mock
    private BasePropertyWriter sourceWriter;
    @Mock
    private BaseElement sourceElement;
    @Mock
    private BasePropertyWriter targetWriter;
    @Mock
    private BaseElement targetElement;

    @Before
    public void setUp() {
        Mockito.when((Object)this.sourceWriter.getElement()).thenReturn((Object)this.sourceElement);
        Mockito.when((Object)this.targetWriter.getElement()).thenReturn((Object)this.targetElement);
    }

    @Test
    public void testCreateBPMNEdge() {
        BPMNShape sourceShape = PropertyWriterUtilsTest.mockShape(SOURCE_SHAPE_ID, 1.0f, 1.0f, 4.0f, 4.0f);
        BPMNShape targetShape = PropertyWriterUtilsTest.mockShape(TARGET_SHAPE_ID, 10.0f, 10.0f, 4.0f, 4.0f);
        Mockito.when((Object)this.sourceWriter.getShape()).thenReturn((Object)sourceShape);
        Mockito.when((Object)this.targetWriter.getShape()).thenReturn((Object)targetShape);
        Connection sourceConnection = PropertyWriterUtilsTest.mockConnection(1.0, 1.0);
        Connection targetConnection = PropertyWriterUtilsTest.mockConnection(10.0, 10.0);
        ControlPoint[] controlPoints = new ControlPoint[]{new ControlPoint(Point2D.create((double)3.0, (double)3.0)), new ControlPoint(Point2D.create((double)4.0, (double)4.0)), new ControlPoint(Point2D.create((double)5.0, (double)5.0))};
        BPMNEdge edge = PropertyWriterUtils.createBPMNEdge((BasePropertyWriter)this.sourceWriter, (BasePropertyWriter)this.targetWriter, (Connection)sourceConnection, (ControlPoint[])controlPoints, (Connection)targetConnection);
        Assert.assertEquals((Object)"edge_SOURCE_SHAPE_ID_to_TARGET_SHAPE_ID", (Object)edge.getId());
        PropertyWriterUtilsTest.assertWaypoint(2.0f, 2.0f, 0, edge.getWaypoint());
        PropertyWriterUtilsTest.assertWaypoint(3.0f, 3.0f, 1, edge.getWaypoint());
        PropertyWriterUtilsTest.assertWaypoint(4.0f, 4.0f, 2, edge.getWaypoint());
        PropertyWriterUtilsTest.assertWaypoint(5.0f, 5.0f, 3, edge.getWaypoint());
        PropertyWriterUtilsTest.assertWaypoint(20.0f, 20.0f, 4, edge.getWaypoint());
    }

    @Test
    public void testGetDockSourceNodeWhenDocked() {
        Node dockSourceNode = (Node)Mockito.mock(Node.class);
        Node<? extends View, Edge> node = PropertyWriterUtilsTest.mockDockedNode(dockSourceNode);
        Optional result = PropertyWriterUtils.getDockSourceNode(node);
        Assert.assertTrue((boolean)result.isPresent());
        Assert.assertEquals((Object)dockSourceNode, result.get());
    }

    @Test
    public void testGetDockSourceNodeWhenNotDocked() {
        Node node = (Node)Mockito.mock(Node.class);
        ArrayList edges = new ArrayList();
        Mockito.when((Object)node.getInEdges()).thenReturn(edges);
        Optional result = PropertyWriterUtils.getDockSourceNode((Node)node);
        Assert.assertFalse((boolean)result.isPresent());
    }

    public static void assertWaypoint(float x, float y, int index, List<Point> waypoints) {
        Assert.assertEquals((float)x, (float)waypoints.get(index).getX(), (float)0.0f);
        Assert.assertEquals((float)y, (float)waypoints.get(index).getY(), (float)0.0f);
    }

    public static BPMNShape mockShape(String id, float x, float y, float width, float height) {
        BPMNShape shape = (BPMNShape)Mockito.mock(BPMNShape.class);
        Mockito.when((Object)shape.getId()).thenReturn((Object)id);
        Bounds bounds = (Bounds)Mockito.mock(Bounds.class);
        Mockito.when((Object)Float.valueOf(bounds.getX())).thenReturn((Object)Float.valueOf(x));
        Mockito.when((Object)Float.valueOf(bounds.getY())).thenReturn((Object)Float.valueOf(y));
        Mockito.when((Object)Float.valueOf(bounds.getHeight())).thenReturn((Object)Float.valueOf(height));
        Mockito.when((Object)Float.valueOf(bounds.getWidth())).thenReturn((Object)Float.valueOf(width));
        Mockito.when((Object)shape.getBounds()).thenReturn((Object)bounds);
        return shape;
    }

    public static Connection mockConnection(double x, double y) {
        Connection connection = (Connection)Mockito.mock(Connection.class);
        Point2D locationPoint = Point2D.create((double)x, (double)y);
        Mockito.when((Object)connection.getLocation()).thenReturn((Object)locationPoint);
        return connection;
    }

    public static ViewConnector<? extends BPMNViewDefinition> mockConnector(double sourceX, double sourceY, double targetX, double targetY, ControlPoint[] controlPoints) {
        ViewConnector connector = (ViewConnector)Mockito.mock(ViewConnector.class);
        Connection sourceConnection = PropertyWriterUtilsTest.mockConnection(sourceX, sourceY);
        Connection targetConnection = PropertyWriterUtilsTest.mockConnection(targetX, targetY);
        Optional<Connection> sourceConnectionOpt = Optional.of(sourceConnection);
        Optional<Connection> targetConnectionOpt = Optional.of(targetConnection);
        Mockito.when((Object)connector.getSourceConnection()).thenReturn(sourceConnectionOpt);
        Mockito.when((Object)connector.getTargetConnection()).thenReturn(targetConnectionOpt);
        Mockito.when((Object)connector.getControlPoints()).thenReturn((Object)controlPoints);
        return connector;
    }

    private static Node<? extends View, Edge> mockDockedNode(Node dockSourceNode) {
        Dock dockContent = (Dock)Mockito.mock(Dock.class);
        Edge edge = (Edge)Mockito.mock(Edge.class);
        List<Edge> inEdges = Collections.singletonList(edge);
        Mockito.when((Object)edge.getContent()).thenReturn((Object)dockContent);
        Mockito.when((Object)edge.getSourceNode()).thenReturn((Object)dockSourceNode);
        Node node = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)node.getInEdges()).thenReturn(inEdges);
        return node;
    }
}

