/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.tasks;

import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.bpmn2.ExtensionDefinition;
import org.eclipse.bpmn2.Task;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.bpmn.backend.converters.TypedFactoryManager;
import org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties.CustomAttribute;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.BpmnNode;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.PropertyReaderFactory;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.ServiceTaskPropertyReader;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.TaskPropertyReader;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.UserTaskPropertyReader;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.tasks.BaseTaskConverter;
import org.kie.workbench.common.stunner.bpmn.definition.NoneTask;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.BaseUserTaskExecutionSet;
import org.kie.workbench.common.stunner.bpmn.workitem.ServiceTask;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class BaseTaskConverterTest {
    protected BaseTaskConverter tested;
    @Mock
    protected TypedFactoryManager factoryManager;
    @Mock
    protected PropertyReaderFactory propertyReaderFactory;
    @Mock
    protected Task serviceTask;
    @Mock
    protected ExtensionDefinition serviceTaskDef;
    @Mock
    protected FeatureMap attributes;
    @Mock
    protected FeatureMap.Entry businessRuleAttr;
    @Mock
    protected EStructuralFeature businessRuleFeature;
    @Mock
    protected View<NoneTask> noneTaskContent;
    protected NoneTask noneTaskDefinition;
    @Mock
    protected TaskPropertyReader taskPropertyReader;
    @Mock
    private Node<View<NoneTask>, Edge> noneTaskNode;
    @Mock
    private Node<View<ServiceTask>, Edge> serviceTaskNode;
    @Mock
    private View<ServiceTask> serviceTaskContent;
    private ServiceTask serviceTaskDefinition;
    @Mock
    private ServiceTaskPropertyReader serviceTaskPropertyReader;

    @Before
    public void setUp() {
        this.noneTaskDefinition = new NoneTask();
        this.serviceTaskDefinition = new ServiceTask();
        Mockito.when((Object)this.factoryManager.newNode(Matchers.anyString(), (Class)Matchers.eq(NoneTask.class))).thenReturn(this.noneTaskNode);
        Mockito.when((Object)this.noneTaskNode.getContent()).thenReturn(this.noneTaskContent);
        Mockito.when((Object)this.noneTaskContent.getDefinition()).thenReturn((Object)this.noneTaskDefinition);
        Mockito.when((Object)this.factoryManager.newNode(Matchers.anyString(), (Class)Matchers.eq(ServiceTask.class))).thenReturn(this.serviceTaskNode);
        Mockito.when((Object)this.serviceTaskNode.getContent()).thenReturn(this.serviceTaskContent);
        Mockito.when((Object)this.serviceTaskContent.getDefinition()).thenReturn((Object)this.serviceTaskDefinition);
        Mockito.when((Object)this.propertyReaderFactory.of(this.serviceTask)).thenReturn((Object)this.taskPropertyReader);
        Mockito.when((Object)this.propertyReaderFactory.ofCustom(this.serviceTask)).thenReturn(Optional.of(this.serviceTaskPropertyReader));
        this.tested = this.createTaskConverter();
    }

    protected BaseTaskConverter createTaskConverter() {
        return (BaseTaskConverter)Mockito.spy((Object)new BaseTaskConverter(this.factoryManager, this.propertyReaderFactory){

            protected Node<View, Edge> createNode(String id) {
                return null;
            }

            protected BaseUserTaskExecutionSet createUserTaskExecutionSet(UserTaskPropertyReader p) {
                return null;
            }
        });
    }

    @Test
    public void convertBusinessRuleServiceTask() {
        Mockito.when((Object)this.serviceTask.getExtensionDefinitions()).thenReturn(Arrays.asList(this.serviceTaskDef));
        Mockito.when((Object)this.serviceTaskDef.getName()).thenReturn((Object)CustomAttribute.serviceTaskName.name());
        Mockito.when((Object)this.serviceTask.getAnyAttribute()).thenReturn((Object)this.attributes);
        Mockito.when((Object)this.attributes.stream()).thenReturn(Stream.of(this.businessRuleAttr));
        Mockito.when((Object)this.businessRuleAttr.getEStructuralFeature()).thenReturn((Object)this.businessRuleFeature);
        Mockito.when((Object)this.businessRuleFeature.getName()).thenReturn((Object)CustomAttribute.serviceTaskName.name());
        Mockito.when((Object)this.serviceTask.getName()).thenReturn((Object)CustomAttribute.serviceTaskName.name());
        Mockito.when((Object)this.businessRuleAttr.getValue()).thenReturn((Object)"BusinessRuleTask");
        BpmnNode converted = this.tested.convert(this.serviceTask);
        Assert.assertNotEquals((Object)converted.value(), this.noneTaskNode);
        Assert.assertEquals((Object)converted.value(), this.serviceTaskNode);
    }
}

