/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.forms.conditions;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.bpmn.backend.forms.conditions.Bean1;
import org.kie.workbench.common.stunner.bpmn.backend.forms.conditions.Bean2;
import org.kie.workbench.common.stunner.bpmn.backend.forms.conditions.parser.ConditionTestCommons;
import org.kie.workbench.common.stunner.bpmn.forms.conditions.Condition;
import org.kie.workbench.common.stunner.bpmn.forms.conditions.ConditionEditorService;
import org.kie.workbench.common.stunner.bpmn.forms.conditions.FieldMetadata;
import org.kie.workbench.common.stunner.bpmn.forms.conditions.GenerateConditionResult;
import org.kie.workbench.common.stunner.bpmn.forms.conditions.ParseConditionResult;
import org.kie.workbench.common.stunner.bpmn.forms.conditions.TypeMetadata;
import org.kie.workbench.common.stunner.bpmn.forms.conditions.TypeMetadataQuery;
import org.kie.workbench.common.stunner.bpmn.forms.conditions.TypeMetadataQueryResult;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.backend.vfs.Path;

@RunWith(value=MockitoJUnitRunner.class)
public abstract class ConditionEditorServiceBaseTest {
    protected ConditionEditorService service;
    protected Path path;

    @Before
    public void setUp() {
        this.service = this.createService();
    }

    protected abstract ConditionEditorService createService();

    @Test
    public void testFindAvailableFunctions() {
        String[] numericFunctions = new String[]{"between", "equalsTo", "greaterThan", "greaterOrEqualThan", "lessThan", "lessOrEqualThan", "isNull"};
        String[] stringFunctions = new String[]{"contains", "isEmpty", "startsWith", "endsWith", "equalsTo", "isNull"};
        String[] booleanFunctions = new String[]{"isTrue", "isFalse", "isNull"};
        String[] objectFunctions = new String[]{"isNull"};
        this.testFindAvailableFunctions(Short.class.getName(), numericFunctions);
        this.testFindAvailableFunctions(Integer.class.getName(), numericFunctions);
        this.testFindAvailableFunctions(Long.class.getName(), numericFunctions);
        this.testFindAvailableFunctions(Float.class.getName(), numericFunctions);
        this.testFindAvailableFunctions(Double.class.getName(), numericFunctions);
        this.testFindAvailableFunctions(BigDecimal.class.getName(), numericFunctions);
        this.testFindAvailableFunctions(BigInteger.class.getName(), numericFunctions);
        this.testFindAvailableFunctions(String.class.getName(), stringFunctions);
        this.testFindAvailableFunctions(Boolean.class.getName(), booleanFunctions);
        this.testFindAvailableFunctions(Object.class.getName(), objectFunctions);
    }

    private void testFindAvailableFunctions(String clazz, String[] expectedFunctions) {
        List functionDefs = this.service.findAvailableFunctions(this.path, clazz);
        Assert.assertEquals((long)functionDefs.size(), (long)expectedFunctions.length);
        for (String expectedFunction : expectedFunctions) {
            Assert.assertTrue((boolean)functionDefs.stream().anyMatch(functionDef -> expectedFunction.equals(functionDef.getName())));
        }
    }

    @Test
    public void testFindMetadata() {
        HashSet<String> types = new HashSet<String>();
        types.add(Bean1.class.getName());
        types.add(Bean2.class.getName());
        types.add("non.existing.class.Bean");
        TypeMetadataQuery query = new TypeMetadataQuery(this.path, types);
        TypeMetadataQueryResult result = this.service.findMetadata(query);
        Assert.assertTrue((boolean)result.getMissingTypes().contains("non.existing.class.Bean"));
        TypeMetadata bean1Metadata = result.getTypeMetadatas().stream().filter(typeMetadata -> typeMetadata.getType().equals(Bean1.class.getName())).findFirst().orElse(null);
        TypeMetadata bean2Metadata = result.getTypeMetadatas().stream().filter(typeMetadata -> typeMetadata.getType().equals(Bean2.class.getName())).findFirst().orElse(null);
        Assert.assertNotNull((Object)bean1Metadata);
        Assert.assertNotNull((Object)bean2Metadata);
        this.assertHasField(bean1Metadata, "fieldBean1_1", String.class.getName(), "getFieldBean1_1", "setFieldBean1_1");
        this.assertHasField(bean1Metadata, "fieldBean1_2", "int", "getFieldBean1_2", null);
        this.assertHasField(bean1Metadata, "fieldBean1_3", "boolean", "isFieldBean1_3", "setFieldBean1_3");
        this.assertHasField(bean1Metadata, "fieldBean1_4", Integer.class.getName(), null, "setFieldBean1_4");
        this.assertHasField(bean2Metadata, "fieldBean1_1", String.class.getName(), "getFieldBean1_1", "setFieldBean1_1");
        this.assertHasField(bean2Metadata, "fieldBean1_2", "int", "getFieldBean1_2", null);
        this.assertHasField(bean2Metadata, "fieldBean1_3", "boolean", "isFieldBean1_3", "setFieldBean1_3");
        this.assertHasField(bean2Metadata, "fieldBean1_4", Integer.class.getName(), null, "setFieldBean1_4");
        this.assertHasField(bean2Metadata, "fieldBean2_1", String.class.getName(), "getFieldBean2_1", "setFieldBean2_1");
        this.assertHasField(bean2Metadata, "fieldBean2_2", Object.class.getName(), "getFieldBean2_2", "setFieldBean2_2");
    }

    private void assertHasField(TypeMetadata typeMetadata, String fieldName, String type, String accessor, String mutator) {
        FieldMetadata fieldMetadata = typeMetadata.getFieldMetadata().stream().filter(fieldMetadata1 -> fieldMetadata1.getName().equals(fieldName)).findFirst().orElse(null);
        Assert.assertNotNull((Object)fieldMetadata);
        Assert.assertEquals((Object)type, (Object)fieldMetadata.getType());
        Assert.assertEquals((Object)accessor, (Object)fieldMetadata.getAccessor());
        Assert.assertEquals((Object)mutator, (Object)fieldMetadata.getMutator());
    }

    @Test
    public void testParseConditionSuccessful() {
        for (String function : ConditionTestCommons.binaryFunctions) {
            this.testParseConditionSuccessful(function);
        }
    }

    @Test
    public void testParseConditionUnsuccessful() {
        for (String function : ConditionTestCommons.binaryFunctions) {
            this.testParseConditionUnsuccessful(function);
        }
    }

    @Test
    public void testGenerateConditionSuccessful() {
        for (String function : ConditionTestCommons.binaryFunctions) {
            this.testGenerateConditionSuccessful(function);
        }
    }

    @Test
    public void testGenerateConditionUnSuccessful() {
        GenerateConditionResult result = this.service.generateCondition(null);
        Assert.assertTrue((boolean)result.hasError());
        Assert.assertEquals((Object)"A condition must be provided", (Object)result.getError());
        Condition condition = new Condition("SomeNonExistingFunction");
        result = this.service.generateCondition(condition);
        Assert.assertTrue((boolean)result.hasError());
        Assert.assertEquals((Object)"Function SomeNonExistingFunction was not found in current functions definitions", (Object)result.getError());
        condition = new Condition("startsWith");
        condition.addParam("variable");
        condition.addParam(null);
        result = this.service.generateCondition(condition);
        Assert.assertTrue((boolean)result.hasError());
        Assert.assertEquals((Object)"Parameter can not be null nor empty", (Object)result.getError());
    }

    private void testParseConditionSuccessful(String function) {
        List<String> conditions = ConditionTestCommons.buildBinaryConditionScripts(function);
        for (int i = 0; i < conditions.size(); ++i) {
            ParseConditionResult result = this.service.parseCondition(conditions.get(i));
            Assert.assertFalse((boolean)result.hasError());
            Assert.assertEquals((Object)function, (Object)result.getCondition().getFunction());
            Assert.assertEquals((long)2L, (long)result.getCondition().getParams().size());
            Assert.assertEquals((Object)ConditionTestCommons.variableParams.get(i), result.getCondition().getParams().get(0));
            Assert.assertEquals((Object)ConditionTestCommons.stringParams.get(i), result.getCondition().getParams().get(1));
        }
    }

    private void testParseConditionUnsuccessful(String function) {
        ConditionTestCommons.failingBinaryFunctionExpressions.forEach(binaryFunctionExpression -> {
            String expression = String.format(binaryFunctionExpression, "KieFunctions." + function);
            ParseConditionResult result = this.service.parseCondition(expression);
            Assert.assertTrue((boolean)result.hasError());
        });
    }

    private void testGenerateConditionSuccessful(String function) {
        for (int i = 0; i < ConditionTestCommons.variableParams.size(); ++i) {
            Condition condition = new Condition(function);
            condition.addParam(ConditionTestCommons.variableParams.get(i));
            condition.addParam(ConditionTestCommons.stringParams.get(i));
            GenerateConditionResult result = this.service.generateCondition(condition);
            Assert.assertFalse((boolean)result.hasError());
            String expectedScript = ConditionTestCommons.buildBinaryConditionScript(function, ConditionTestCommons.variableParams.get(i), ConditionTestCommons.stringParams.get(i));
            Assert.assertEquals((Object)expectedScript, (Object)result.getExpression());
        }
    }
}

