/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.forms.conditions.parser;

import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.kie.workbench.common.stunner.bpmn.backend.forms.conditions.parser.ConditionGenerator;
import org.kie.workbench.common.stunner.bpmn.backend.forms.conditions.parser.ConditionTestCommons;
import org.kie.workbench.common.stunner.bpmn.backend.forms.conditions.parser.GenerateConditionException;
import org.kie.workbench.common.stunner.bpmn.forms.conditions.Condition;

public class ConditionGeneratorTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void testGenerateUnaryFunctions() throws Exception {
        for (String function : ConditionTestCommons.unaryFunctions) {
            this.testGenerateUnaryCondition(function);
        }
    }

    @Test
    public void testGenerateBinaryFunctions() throws Exception {
        for (String function : ConditionTestCommons.binaryFunctions) {
            this.testGenerateBinaryFunction(function);
        }
    }

    @Test
    public void testGenerateTernaryFunctions() throws Exception {
        for (String function : ConditionTestCommons.ternaryFunctions) {
            this.testGenerateTernaryFunction(function);
        }
    }

    @Test
    public void testMissingConditionError() throws Exception {
        ConditionGenerator generator = new ConditionGenerator();
        this.expectedException.expectMessage("A condition must be provided");
        generator.generateScript(null);
    }

    @Test
    public void testFunctionNotFoundError() throws Exception {
        ConditionGenerator generator = new ConditionGenerator();
        Condition condition = new Condition("SomeNonExistingFunction");
        this.expectedException.expectMessage("Function SomeNonExistingFunction was not found in current functions definitions");
        generator.generateScript(condition);
    }

    @Test
    public void testParamIsNullError() throws Exception {
        ConditionGenerator generator = new ConditionGenerator();
        Condition condition = new Condition("startsWith");
        condition.addParam("variable");
        condition.addParam(null);
        this.expectedException.expectMessage("Parameter can not be null nor empty");
        generator.generateScript(condition);
    }

    private void testGenerateUnaryCondition(String function) throws GenerateConditionException {
        ConditionGenerator generator = new ConditionGenerator();
        for (String param : ConditionTestCommons.variableParams) {
            Condition condition = new Condition(function);
            condition.addParam(param);
            String expectedScript = ConditionTestCommons.buildUnaryConditionScript(function, param);
            Assert.assertEquals((Object)expectedScript, (Object)generator.generateScript(condition));
        }
    }

    private void testGenerateBinaryFunction(String function) throws GenerateConditionException {
        ConditionGenerator generator = new ConditionGenerator();
        for (int i = 0; i < ConditionTestCommons.variableParams.size(); ++i) {
            Condition condition = new Condition(function);
            condition.addParam(ConditionTestCommons.variableParams.get(i));
            condition.addParam(ConditionTestCommons.stringParams.get(i));
            String expectedScript = ConditionTestCommons.buildBinaryConditionScript(function, ConditionTestCommons.variableParams.get(i), ConditionTestCommons.stringParams.get(i));
            Assert.assertEquals((Object)expectedScript, (Object)generator.generateScript(condition));
        }
    }

    private void testGenerateTernaryFunction(String function) throws GenerateConditionException {
        ConditionGenerator generator = new ConditionGenerator();
        for (int i = 0; i < ConditionTestCommons.variableParams.size(); ++i) {
            Condition condition = new Condition(function);
            condition.addParam(ConditionTestCommons.variableParams.get(i));
            condition.addParam(ConditionTestCommons.stringParams.get(i));
            condition.addParam(ConditionTestCommons.stringParams.get(i));
            String expectedScript = ConditionTestCommons.buildTernaryConditionScript(function, ConditionTestCommons.variableParams.get(i), ConditionTestCommons.stringParams.get(i), ConditionTestCommons.stringParams.get(i));
            Assert.assertEquals((Object)expectedScript, (Object)generator.generateScript(condition));
        }
    }
}

