/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.service.diagram.marshalling.events;

import org.junit.Assert;
import org.junit.Test;
import org.kie.workbench.common.stunner.bpmn.backend.service.diagram.marshalling.events.StartEventTest;
import org.kie.workbench.common.stunner.bpmn.definition.StartErrorEvent;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.BaseStartEventExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.error.InterruptingErrorEventExecutionSet;
import org.kie.workbench.common.stunner.core.definition.service.DiagramMarshaller;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.graph.Graph;

public class StartErrorEventTest
extends StartEventTest<StartErrorEvent> {
    private static final String BPMN_START_EVENT_FILE_PATH = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/startErrorEvents.bpmn";
    private static final String FILLED_TOP_LEVEL_EVENT_ID = "470CB3B0-B2E6-4252-B41E-353AED109847";
    private static final String EMPTY_TOP_LEVEL_EVENT_ID = "A180871D-2E3A-4CD3-AED7-43E8397FF30C";
    private static final String FILLED_SUBPROCESS_LEVEL_EVENT_ID = "25676AF3-FD4D-4A07-BA58-4D0E331D0579";
    private static final String EMPTY_SUBPROCESS_LEVEL_EVENT_ID = "1BB182E3-B7B9-45DB-8579-66A2F1B4DC53";
    private static final String SLA_DUE_DATE = "12/25/1983";
    private static final int AMOUNT_OF_NODES_IN_DIAGRAM = 11;

    @Override
    @Test
    public void testUnmarshallTopLevelEventFilledProperties() throws Exception {
        String EVENT_NAME = "Filled Top-Level Error start event";
        String EVENT_DOCUMENTATION = "Some documentation\n~`!@#$%^&*()_+=-{}|\\][:\";'?><,./\n";
        String ERROR_REF = "Error1";
        String EVENT_DATA_OUTPUT = "||someVar:String||[dout]someVar->prVar";
        Diagram<Graph, Metadata> diagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, BPMN_START_EVENT_FILE_PATH);
        this.assertDiagram(diagram, 11);
        StartErrorEvent filledTop = this.getStartNodeById(diagram, FILLED_TOP_LEVEL_EVENT_ID, this.getStartEventType());
        this.assertGeneralSet(filledTop.getGeneral(), "Filled Top-Level Error start event", "Some documentation\n~`!@#$%^&*()_+=-{}|\\][:\";'?><,./\n");
        this.assertErrorEventExecutionSet(filledTop.getExecutionSet(), "Error1", true, SLA_DUE_DATE);
        this.assertDataIOSet(filledTop.getDataIOSet(), "||someVar:String||[dout]someVar->prVar");
    }

    @Override
    @Test
    public void testUnmarshallTopLevelEmptyEventProperties() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, BPMN_START_EVENT_FILE_PATH);
        this.assertDiagram(diagram, 11);
        StartErrorEvent emptyTop = this.getStartNodeById(diagram, EMPTY_TOP_LEVEL_EVENT_ID, this.getStartEventType());
        this.assertGeneralSet(emptyTop.getGeneral(), "", "");
        this.assertErrorEventExecutionSet(emptyTop.getExecutionSet(), "", false, "");
        this.assertDataIOSet(emptyTop.getDataIOSet(), "");
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelEventFilledProperties() throws Exception {
        String EVENT_NAME = "Event subprocess filled error event";
        String EVENT_DOCUMENTATION = "Some documentation as well\n~`!@#$%^&*()_+=-{}|\\][:\";'?><,./";
        String EVENT_REF = "Error2";
        String EVENT_DATA_OUTPUT = "||newVar:String||[dout]newVar->prVar";
        Diagram<Graph, Metadata> diagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, BPMN_START_EVENT_FILE_PATH);
        this.assertDiagram(diagram, 11);
        StartErrorEvent filledSubprocess = this.getStartNodeById(diagram, FILLED_SUBPROCESS_LEVEL_EVENT_ID, this.getStartEventType());
        this.assertGeneralSet(filledSubprocess.getGeneral(), "Event subprocess filled error event", "Some documentation as well\n~`!@#$%^&*()_+=-{}|\\][:\";'?><,./");
        this.assertErrorEventExecutionSet(filledSubprocess.getExecutionSet(), "Error2", true, SLA_DUE_DATE);
        this.assertDataIOSet(filledSubprocess.getDataIOSet(), "||newVar:String||[dout]newVar->prVar");
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelEventEmptyProperties() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, BPMN_START_EVENT_FILE_PATH);
        this.assertDiagram(diagram, 11);
        StartErrorEvent emptySubprocess = this.getStartNodeById(diagram, EMPTY_SUBPROCESS_LEVEL_EVENT_ID, this.getStartEventType());
        this.assertGeneralSet(emptySubprocess.getGeneral(), "", "");
        this.assertErrorEventExecutionSet(emptySubprocess.getExecutionSet(), "", false, "");
        this.assertDataIOSet(emptySubprocess.getDataIOSet(), "");
    }

    @Override
    public Class<StartErrorEvent> getStartEventType() {
        return StartErrorEvent.class;
    }

    @Override
    String getBpmnStartEventFilePath() {
        return BPMN_START_EVENT_FILE_PATH;
    }

    @Override
    String getFilledTopLevelEventId() {
        return FILLED_TOP_LEVEL_EVENT_ID;
    }

    @Override
    String getEmptyTopLevelEventId() {
        return EMPTY_TOP_LEVEL_EVENT_ID;
    }

    @Override
    String getFilledSubprocessLevelEventId() {
        return FILLED_SUBPROCESS_LEVEL_EVENT_ID;
    }

    @Override
    String getEmptySubprocessLevelEventId() {
        return EMPTY_SUBPROCESS_LEVEL_EVENT_ID;
    }

    private void assertErrorEventExecutionSet(InterruptingErrorEventExecutionSet executionSet, String eventName, boolean isInterrupting, String slaDueDate) {
        Assert.assertNotNull((Object)executionSet);
        Assert.assertNotNull((Object)executionSet.getErrorRef());
        Assert.assertEquals((Object)eventName, (Object)executionSet.getErrorRef().getValue());
        this.assertStartEventIsInterrupting((BaseStartEventExecutionSet)executionSet, isInterrupting);
        this.assertStartEventSlaDueDate((BaseStartEventExecutionSet)executionSet, slaDueDate);
    }
}

