/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.service.diagram.marshalling.events;

import org.junit.Assert;
import org.junit.Test;
import org.kie.workbench.common.stunner.bpmn.backend.service.diagram.marshalling.BPMNDiagramMarshallerBaseTest;
import org.kie.workbench.common.stunner.bpmn.definition.BaseStartEvent;
import org.kie.workbench.common.stunner.bpmn.definition.property.dataio.AssignmentsInfo;
import org.kie.workbench.common.stunner.bpmn.definition.property.dataio.DataIOSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.BaseStartEventExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.general.BPMNGeneralSet;
import org.kie.workbench.common.stunner.core.definition.service.DiagramMarshaller;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;

public abstract class StartEventTest<T extends BaseStartEvent>
extends BPMNDiagramMarshallerBaseTest {
    static final String EMPTY_VALUE = "";
    static final boolean NON_INTERRUPTING = false;
    static final boolean INTERRUPTING = true;

    StartEventTest() {
    }

    @Test
    public void testMarshallTopLevelEventFilledProperties() throws Exception {
        this.checkEventMarshalling(this.getStartEventType(), this.getFilledTopLevelEventId());
    }

    @Test
    public void testMarshallTopLevelEmptyEventProperties() throws Exception {
        this.checkEventMarshalling(this.getStartEventType(), this.getEmptyTopLevelEventId());
    }

    @Test
    public void testMarshallSubprocessLevelEventFilledProperties() throws Exception {
        this.checkEventMarshalling(this.getStartEventType(), this.getFilledSubprocessLevelEventId());
    }

    @Test
    public void testMarshallSubprocessLevelEventEmptyProperties() throws Exception {
        this.checkEventMarshalling(this.getStartEventType(), this.getEmptySubprocessLevelEventId());
    }

    public abstract void testUnmarshallTopLevelEventFilledProperties() throws Exception;

    public abstract void testUnmarshallTopLevelEmptyEventProperties() throws Exception;

    public abstract void testUnmarshallSubprocessLevelEventFilledProperties() throws Exception;

    public abstract void testUnmarshallSubprocessLevelEventEmptyProperties() throws Exception;

    abstract Class<T> getStartEventType();

    abstract String getBpmnStartEventFilePath();

    abstract String getFilledTopLevelEventId();

    abstract String getEmptyTopLevelEventId();

    abstract String getFilledSubprocessLevelEventId();

    abstract String getEmptySubprocessLevelEventId();

    private void assertNodesEqualsAfterMarshalling(Diagram<Graph, Metadata> before, Diagram<Graph, Metadata> after, String nodeId, Class<T> startType) {
        T nodeBeforeMarshalling = this.getStartNodeById(before, nodeId, startType);
        T nodeAfterMarshalling = this.getStartNodeById(after, nodeId, startType);
        Assert.assertEquals(nodeBeforeMarshalling, nodeAfterMarshalling);
    }

    T getStartNodeById(Diagram<Graph, Metadata> diagram, String id, Class<T> type) {
        Node node = diagram.getGraph().getNode(id);
        Assert.assertNotNull((Object)node);
        Assert.assertEquals((long)1L, (long)node.getOutEdges().size());
        return (T)((BaseStartEvent)type.cast(((Definition)node.getContent()).getDefinition()));
    }

    void assertGeneralSet(BPMNGeneralSet generalSet, String nodeName, String documentation) {
        Assert.assertNotNull((Object)generalSet);
        Assert.assertNotNull((Object)generalSet.getName());
        Assert.assertNotNull((Object)generalSet.getDocumentation());
        Assert.assertEquals((Object)nodeName, (Object)generalSet.getName().getValue());
        Assert.assertEquals((Object)documentation, (Object)generalSet.getDocumentation().getValue());
    }

    void assertDataIOSet(DataIOSet dataIOSet, String value) {
        Assert.assertNotNull((Object)dataIOSet);
        AssignmentsInfo assignmentsInfo = dataIOSet.getAssignmentsinfo();
        Assert.assertNotNull((Object)assignmentsInfo);
        Assert.assertEquals((Object)value, (Object)assignmentsInfo.getValue());
    }

    void checkEventMarshalling(Class startNodeType, String nodeID) throws Exception {
        Diagram<Graph, Metadata> initialDiagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, this.getBpmnStartEventFilePath());
        int AMOUNT_OF_NODES_IN_DIAGRAM = this.getNodes(initialDiagram).size();
        String resultXml = this.marshaller.marshall(initialDiagram);
        Diagram<Graph, Metadata> marshalledDiagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, this.getStream(resultXml));
        this.assertDiagram(marshalledDiagram, AMOUNT_OF_NODES_IN_DIAGRAM);
        this.assertNodesEqualsAfterMarshalling(initialDiagram, marshalledDiagram, nodeID, startNodeType);
    }

    protected void assertStartEventSlaDueDate(BaseStartEventExecutionSet executionSet, String slaDueDate) {
        Assert.assertNotNull((Object)executionSet.getSlaDueDate());
        Assert.assertEquals((Object)slaDueDate, (Object)executionSet.getSlaDueDate().getValue());
    }

    protected void assertStartEventIsInterrupting(BaseStartEventExecutionSet executionSet, boolean isInterrupting) {
        Assert.assertNotNull((Object)executionSet.getIsInterrupting());
        Assert.assertEquals((Object)isInterrupting, (Object)executionSet.getIsInterrupting().getValue());
    }
}

