/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.service.diagram.marshalling.events;

import org.junit.Assert;
import org.junit.Test;
import org.kie.workbench.common.stunner.bpmn.backend.service.diagram.marshalling.events.StartEventTest;
import org.kie.workbench.common.stunner.bpmn.definition.StartSignalEvent;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.BaseStartEventExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.signal.InterruptingSignalEventExecutionSet;
import org.kie.workbench.common.stunner.core.definition.service.DiagramMarshaller;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.graph.Graph;

public class StartSignalEventTest
extends StartEventTest<StartSignalEvent> {
    private static final String BPMN_START_EVENT_FILE_PATH = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/signalStartEvents.bpmn";
    private static final String FILLED_TOP_LEVEL_EVENT_ID = "40270ECD-79FB-4211-BBF5-B1B6DF39CC24";
    private static final String EMPTY_TOP_LEVEL_EVENT_ID = "6DF9C3AB-7A3B-44D0-AAE1-C0E09D60ACC6";
    private static final String FILLED_SUBPROCESS_LEVEL_EVENT_ID = "EEC78B63-5E63-4301-9B7F-30A26634091C";
    private static final String EMPTY_SUBPROCESS_LEVEL_EVENT_ID = "E49AC940-F618-4F25-AE18-74AFDC923A7C";
    private static final String SLA_DUE_DATE = "12/25/1983";
    private static final int AMOUNT_OF_NODES_IN_DIAGRAM = 11;

    @Override
    @Test
    public void testUnmarshallTopLevelEventFilledProperties() throws Exception {
        String EVENT_NAME = "Signal Start Event with Name";
        String EVENT_DOCUMENTATION = "Non empty\nDocumentation\n~`!@#$%^&*()_+=-{}|\\][:\";'?><,./";
        String SIGNAL_REF = "Signal1";
        String EVENT_DATA_OUTPUT = "||event:String||[dout]event->processVar";
        Diagram<Graph, Metadata> diagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, BPMN_START_EVENT_FILE_PATH);
        this.assertDiagram(diagram, 11);
        StartSignalEvent filledTop = this.getStartNodeById(diagram, FILLED_TOP_LEVEL_EVENT_ID, StartSignalEvent.class);
        this.assertGeneralSet(filledTop.getGeneral(), "Signal Start Event with Name", "Non empty\nDocumentation\n~`!@#$%^&*()_+=-{}|\\][:\";'?><,./");
        this.assertSignalEventExecutionSet(filledTop.getExecutionSet(), "Signal1", true, SLA_DUE_DATE);
        this.assertDataIOSet(filledTop.getDataIOSet(), "||event:String||[dout]event->processVar");
    }

    @Override
    @Test
    public void testUnmarshallTopLevelEmptyEventProperties() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, BPMN_START_EVENT_FILE_PATH);
        this.assertDiagram(diagram, 11);
        StartSignalEvent emptyTop = this.getStartNodeById(diagram, EMPTY_TOP_LEVEL_EVENT_ID, StartSignalEvent.class);
        this.assertGeneralSet(emptyTop.getGeneral(), "", "");
        this.assertSignalEventExecutionSet(emptyTop.getExecutionSet(), "", false, "");
        this.assertDataIOSet(emptyTop.getDataIOSet(), "");
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelEventFilledProperties() throws Exception {
        String EVENT_NAME = "Signal inside of Event sub-process";
        String EVENT_DOCUMENTATION = "Non empty Signal Event\nDocumentation\n~`!@#$%^&*()_+=-{}|\\][:\";'?><,./";
        String SIGNAL_REF = "AnotherSignal";
        String EVENT_DATA_OUTPUT = "||hello:String||[dout]hello->processVar";
        Diagram<Graph, Metadata> diagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, BPMN_START_EVENT_FILE_PATH);
        this.assertDiagram(diagram, 11);
        StartSignalEvent filledSubprocess = this.getStartNodeById(diagram, FILLED_SUBPROCESS_LEVEL_EVENT_ID, StartSignalEvent.class);
        this.assertGeneralSet(filledSubprocess.getGeneral(), "Signal inside of Event sub-process", "Non empty Signal Event\nDocumentation\n~`!@#$%^&*()_+=-{}|\\][:\";'?><,./");
        this.assertSignalEventExecutionSet(filledSubprocess.getExecutionSet(), "AnotherSignal", true, SLA_DUE_DATE);
        this.assertDataIOSet(filledSubprocess.getDataIOSet(), "||hello:String||[dout]hello->processVar");
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelEventEmptyProperties() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, BPMN_START_EVENT_FILE_PATH);
        this.assertDiagram(diagram, 11);
        StartSignalEvent emptySubprocess = this.getStartNodeById(diagram, EMPTY_SUBPROCESS_LEVEL_EVENT_ID, StartSignalEvent.class);
        this.assertGeneralSet(emptySubprocess.getGeneral(), "", "");
        this.assertSignalEventExecutionSet(emptySubprocess.getExecutionSet(), "", false, "");
        this.assertDataIOSet(emptySubprocess.getDataIOSet(), "");
    }

    @Override
    String getBpmnStartEventFilePath() {
        return BPMN_START_EVENT_FILE_PATH;
    }

    @Override
    String getFilledTopLevelEventId() {
        return FILLED_TOP_LEVEL_EVENT_ID;
    }

    @Override
    String getEmptyTopLevelEventId() {
        return EMPTY_TOP_LEVEL_EVENT_ID;
    }

    @Override
    String getFilledSubprocessLevelEventId() {
        return FILLED_SUBPROCESS_LEVEL_EVENT_ID;
    }

    @Override
    String getEmptySubprocessLevelEventId() {
        return EMPTY_SUBPROCESS_LEVEL_EVENT_ID;
    }

    @Override
    Class<StartSignalEvent> getStartEventType() {
        return StartSignalEvent.class;
    }

    private void assertSignalEventExecutionSet(InterruptingSignalEventExecutionSet executionSet, String eventName, boolean isInterrupting, String slaDueDate) {
        Assert.assertNotNull((Object)executionSet);
        Assert.assertNotNull((Object)executionSet.getSignalRef());
        Assert.assertEquals((Object)eventName, (Object)executionSet.getSignalRef().getValue());
        this.assertStartEventIsInterrupting((BaseStartEventExecutionSet)executionSet, isInterrupting);
        this.assertStartEventSlaDueDate((BaseStartEventExecutionSet)executionSet, slaDueDate);
    }
}

