/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.service.diagram.marshalling.events.intermediate;

import org.junit.Assert;
import org.junit.Test;
import org.kie.workbench.common.stunner.bpmn.backend.service.diagram.marshalling.events.intermediate.BoundaryCatchingIntermediateEventTest;
import org.kie.workbench.common.stunner.bpmn.definition.IntermediateErrorEventCatching;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.BaseCancellingEventExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.error.CancellingErrorEventExecutionSet;
import org.kie.workbench.common.stunner.core.definition.service.DiagramMarshaller;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.graph.Graph;

public class BoundaryCatchingIntermediateErrorEventTest
extends BoundaryCatchingIntermediateEventTest<IntermediateErrorEventCatching> {
    private static final String BPMN_CATCHING_INTERMEDIATE_EVENT_FILE_PATH = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/boundaryErrorEvents.bpmn";
    private static final String EMPTY_TOP_LEVEL_EVENT_ID = "_DFCE579D-A3FB-4CA3-A41C-8D2C9C3E45E1";
    private static final String FILLED_TOP_LEVEL_EVENT_ID = "_12D62443-49D0-4AEB-B39A-06AB0470E66C";
    private static final String EMPTY_SUBPROCESS_LEVEL_EVENT_ID = "_81024F0B-3151-48B4-B17C-AE7F0CA419A6";
    private static final String FILLED_SUBPROCESS_LEVEL_EVENT_ID = "_2CA5D491-6AD9-42B1-8FE8-B18AA20D7D1C";
    private static final String EMPTY_WITH_OUTGOING_EDGE_TOP_LEVEL_EVENT_ID = "_10E9AA6A-5BAA-4A23-A9E9-63D285677BFC";
    private static final String FILLED_WITH_OUTGOING_EDGE_TOP_LEVEL_EVENT_ID = "_C5C81EDA-355E-4431-97EC-9F0ED0A78685";
    private static final String EMPTY_WITH_OUTGOING_EDGE_SUBPROCESS_LEVEL_EVENT_ID = "_38C1EB4D-2196-487E-A1C6-C3BC16FDC5D6";
    private static final String FILLED_WITH_OUTGOING_EDGE_SUBPROCESS_LEVEL_EVENT_ID = "_00D797D8-20D0-4CF0-A6C0-B9FE3034FAE6";
    private static final String SLA_DUE_DATE = "12/25/1983";
    private static final int AMOUNT_OF_NODES_IN_DIAGRAM = 31;

    @Override
    @Test
    public void testUnmarshallTopLevelEventFilledProperties() throws Exception {
        String EVENT_NAME = "Boundary error01 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String EVENT_DOCUMENTATION = "error01 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String EVENT_REF = "error01";
        String EVENT_DATA_OUTPUT = "||error01:String||[dout]error01->processGlobalVar";
        Diagram<Graph, Metadata> diagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, BPMN_CATCHING_INTERMEDIATE_EVENT_FILE_PATH);
        this.assertDiagram(diagram, 31);
        IntermediateErrorEventCatching filledTopEvent = (IntermediateErrorEventCatching)this.getCatchingIntermediateNodeById(diagram, FILLED_TOP_LEVEL_EVENT_ID, false, false);
        this.assertGeneralSet(filledTopEvent.getGeneral(), "Boundary error01 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "error01 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertErrorEventExecutionSet(filledTopEvent.getExecutionSet(), "error01", true, SLA_DUE_DATE);
        this.assertDataIOSet(filledTopEvent.getDataIOSet(), "||error01:String||[dout]error01->processGlobalVar");
    }

    @Override
    @Test
    public void testUnmarshallTopLevelEmptyEventProperties() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, BPMN_CATCHING_INTERMEDIATE_EVENT_FILE_PATH);
        this.assertDiagram(diagram, 31);
        IntermediateErrorEventCatching emptyTopEvent = (IntermediateErrorEventCatching)this.getCatchingIntermediateNodeById(diagram, EMPTY_TOP_LEVEL_EVENT_ID, false, false);
        this.assertGeneralSet(emptyTopEvent.getGeneral(), "", "");
        this.assertErrorEventExecutionSet(emptyTopEvent.getExecutionSet(), "", true, "");
        this.assertDataIOSet(emptyTopEvent.getDataIOSet(), "");
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelEventFilledProperties() throws Exception {
        String EVENT_NAME = "Boundary error03 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String EVENT_DOCUMENTATION = "error03 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String EVENT_REF = "error03";
        String EVENT_DATA_OUTPUT = "||error03:String||[dout]error03->processGlobalVar";
        Diagram<Graph, Metadata> diagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, BPMN_CATCHING_INTERMEDIATE_EVENT_FILE_PATH);
        this.assertDiagram(diagram, 31);
        IntermediateErrorEventCatching filledSubprocessEvent = (IntermediateErrorEventCatching)this.getCatchingIntermediateNodeById(diagram, FILLED_SUBPROCESS_LEVEL_EVENT_ID, false, false);
        this.assertGeneralSet(filledSubprocessEvent.getGeneral(), "Boundary error03 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "error03 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertErrorEventExecutionSet(filledSubprocessEvent.getExecutionSet(), "error03", true, SLA_DUE_DATE);
        this.assertDataIOSet(filledSubprocessEvent.getDataIOSet(), "||error03:String||[dout]error03->processGlobalVar");
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelEventEmptyProperties() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, BPMN_CATCHING_INTERMEDIATE_EVENT_FILE_PATH);
        this.assertDiagram(diagram, 31);
        IntermediateErrorEventCatching emptySubprocessEvent = (IntermediateErrorEventCatching)this.getCatchingIntermediateNodeById(diagram, EMPTY_SUBPROCESS_LEVEL_EVENT_ID, false, false);
        this.assertGeneralSet(emptySubprocessEvent.getGeneral(), "", "");
        this.assertErrorEventExecutionSet(emptySubprocessEvent.getExecutionSet(), "", true, "");
        this.assertDataIOSet(emptySubprocessEvent.getDataIOSet(), "");
    }

    @Override
    @Test
    public void testUnmarshallTopLevelEventWithEdgesFilledProperties() throws Exception {
        String EVENT_NAME = "Boundary error02 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String EVENT_DOCUMENTATION = "error02 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String EVENT_REF = "error02";
        String EVENT_DATA_OUTPUT = "||error02:String||[dout]error02->processGlobalVar";
        Diagram<Graph, Metadata> diagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, BPMN_CATCHING_INTERMEDIATE_EVENT_FILE_PATH);
        this.assertDiagram(diagram, 31);
        IntermediateErrorEventCatching filledSubprocessEvent = (IntermediateErrorEventCatching)this.getCatchingIntermediateNodeById(diagram, FILLED_WITH_OUTGOING_EDGE_TOP_LEVEL_EVENT_ID, false, true);
        this.assertGeneralSet(filledSubprocessEvent.getGeneral(), "Boundary error02 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "error02 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertErrorEventExecutionSet(filledSubprocessEvent.getExecutionSet(), "error02", true, SLA_DUE_DATE);
        this.assertDataIOSet(filledSubprocessEvent.getDataIOSet(), "||error02:String||[dout]error02->processGlobalVar");
    }

    @Override
    @Test
    public void testUnmarshallTopLevelEventWithEdgesEmptyProperties() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, BPMN_CATCHING_INTERMEDIATE_EVENT_FILE_PATH);
        this.assertDiagram(diagram, 31);
        IntermediateErrorEventCatching emptyEvent = (IntermediateErrorEventCatching)this.getCatchingIntermediateNodeById(diagram, EMPTY_WITH_OUTGOING_EDGE_TOP_LEVEL_EVENT_ID, false, true);
        this.assertGeneralSet(emptyEvent.getGeneral(), "", "");
        this.assertErrorEventExecutionSet(emptyEvent.getExecutionSet(), "", true, "");
        this.assertDataIOSet(emptyEvent.getDataIOSet(), "");
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelEventWithEdgesEmptyProperties() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, BPMN_CATCHING_INTERMEDIATE_EVENT_FILE_PATH);
        this.assertDiagram(diagram, 31);
        IntermediateErrorEventCatching emptySubprocessEvent = (IntermediateErrorEventCatching)this.getCatchingIntermediateNodeById(diagram, EMPTY_WITH_OUTGOING_EDGE_SUBPROCESS_LEVEL_EVENT_ID, false, true);
        this.assertGeneralSet(emptySubprocessEvent.getGeneral(), "", "");
        this.assertErrorEventExecutionSet(emptySubprocessEvent.getExecutionSet(), "", true, "");
        this.assertDataIOSet(emptySubprocessEvent.getDataIOSet(), "");
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelEventWithEdgesFilledProperties() throws Exception {
        String EVENT_NAME = "Boundary error04 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String EVENT_DOCUMENTATION = "error04 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String EVENT_REF = "error04";
        String EVENT_DATA_OUTPUT = "||error04:String||[dout]error04->processGlobalVar";
        Diagram<Graph, Metadata> diagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, BPMN_CATCHING_INTERMEDIATE_EVENT_FILE_PATH);
        this.assertDiagram(diagram, 31);
        IntermediateErrorEventCatching filledSubprocessEvent = (IntermediateErrorEventCatching)this.getCatchingIntermediateNodeById(diagram, FILLED_WITH_OUTGOING_EDGE_SUBPROCESS_LEVEL_EVENT_ID, false, true);
        this.assertGeneralSet(filledSubprocessEvent.getGeneral(), "Boundary error04 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "error04 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertErrorEventExecutionSet(filledSubprocessEvent.getExecutionSet(), "error04", true, SLA_DUE_DATE);
        this.assertDataIOSet(filledSubprocessEvent.getDataIOSet(), "||error04:String||[dout]error04->processGlobalVar");
    }

    @Override
    String getBpmnCatchingIntermediateEventFilePath() {
        return BPMN_CATCHING_INTERMEDIATE_EVENT_FILE_PATH;
    }

    @Override
    Class<IntermediateErrorEventCatching> getCatchingIntermediateEventType() {
        return IntermediateErrorEventCatching.class;
    }

    @Override
    String getFilledTopLevelEventId() {
        return FILLED_TOP_LEVEL_EVENT_ID;
    }

    @Override
    String getEmptyTopLevelEventId() {
        return EMPTY_TOP_LEVEL_EVENT_ID;
    }

    @Override
    String getFilledSubprocessLevelEventId() {
        return FILLED_SUBPROCESS_LEVEL_EVENT_ID;
    }

    @Override
    String getEmptySubprocessLevelEventId() {
        return EMPTY_SUBPROCESS_LEVEL_EVENT_ID;
    }

    @Override
    String getFilledTopLevelEventWithEdgesId() {
        return FILLED_WITH_OUTGOING_EDGE_TOP_LEVEL_EVENT_ID;
    }

    @Override
    String getEmptyTopLevelEventWithEdgesId() {
        return EMPTY_WITH_OUTGOING_EDGE_TOP_LEVEL_EVENT_ID;
    }

    @Override
    String getFilledSubprocessLevelEventWithEdgesId() {
        return FILLED_WITH_OUTGOING_EDGE_SUBPROCESS_LEVEL_EVENT_ID;
    }

    @Override
    String getEmptySubprocessLevelEventWithEdgesId() {
        return EMPTY_WITH_OUTGOING_EDGE_SUBPROCESS_LEVEL_EVENT_ID;
    }

    private void assertErrorEventExecutionSet(CancellingErrorEventExecutionSet executionSet, String eventName, boolean isCancelling, String slaDueDate) {
        Assert.assertNotNull((Object)executionSet);
        Assert.assertNotNull((Object)executionSet.getErrorRef());
        this.assertEventCancelActivity((BaseCancellingEventExecutionSet)executionSet, isCancelling);
        this.assertTimerEventSlaDueDate((BaseCancellingEventExecutionSet)executionSet, slaDueDate);
        Assert.assertEquals((Object)eventName, (Object)executionSet.getErrorRef().getValue());
    }
}

