/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.service.diagram.marshalling.events.intermediate;

import org.junit.Assert;
import org.junit.Test;
import org.kie.workbench.common.stunner.bpmn.backend.service.diagram.marshalling.BPMNDiagramMarshallerBaseTest;
import org.kie.workbench.common.stunner.bpmn.definition.BaseCatchingIntermediateEvent;
import org.kie.workbench.common.stunner.bpmn.definition.property.dataio.AssignmentsInfo;
import org.kie.workbench.common.stunner.bpmn.definition.property.dataio.DataIOSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.BaseCancellingEventExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.general.BPMNGeneralSet;
import org.kie.workbench.common.stunner.core.definition.service.DiagramMarshaller;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;

public abstract class CatchingIntermediateEventTest<T extends BaseCatchingIntermediateEvent>
extends BPMNDiagramMarshallerBaseTest {
    static final String EMPTY_VALUE = "";
    static final boolean CANCELLING = true;
    static final boolean NON_CANCELLING = false;
    static final boolean HAS_INCOME_EDGE = true;
    static final boolean HAS_NO_INCOME_EDGE = false;
    static final boolean HAS_OUTGOING_EDGE = true;
    static final boolean HAS_NO_OUTGOING_EDGE = false;
    private static final int DEFAULT_AMOUNT_OF_INCOME_EDGES = 1;

    CatchingIntermediateEventTest() {
    }

    @Test
    public void testMarshallTopLevelEventFilledProperties() throws Exception {
        this.checkEventMarshalling(this.getFilledTopLevelEventId(), false, true);
    }

    @Test
    public void testMarshallTopLevelEventEmptyProperties() throws Exception {
        this.checkEventMarshalling(this.getEmptyTopLevelEventId(), false, true);
    }

    @Test
    public void testMarshallSubprocessLevelEventFilledProperties() throws Exception {
        this.checkEventMarshalling(this.getFilledSubprocessLevelEventId(), false, true);
    }

    @Test
    public void testMarshallSubprocessLevelEventEmptyProperties() throws Exception {
        this.checkEventMarshalling(this.getEmptySubprocessLevelEventId(), false, true);
    }

    @Test
    public void testMarshallTopLevelEventWithEdgesFilledProperties() throws Exception {
        this.checkEventMarshalling(this.getFilledTopLevelEventWithEdgesId(), true, true);
    }

    @Test
    public void testMarshallTopLevelEventWithEdgesEmptyProperties() throws Exception {
        this.checkEventMarshalling(this.getEmptyTopLevelEventWithEdgesId(), true, true);
    }

    @Test
    public void testMarshallSubprocessLevelEventWithEdgesFilledProperties() throws Exception {
        this.checkEventMarshalling(this.getFilledSubprocessLevelEventWithEdgesId(), true, true);
    }

    @Test
    public void testMarshallSubprocessLevelEventWithEdgesEmptyProperties() throws Exception {
        this.checkEventMarshalling(this.getEmptySubprocessLevelEventWithEdgesId(), true, true);
    }

    protected void assertTimerEventSlaDueDate(BaseCancellingEventExecutionSet executionSet, String slaDueDate) {
        Assert.assertNotNull((Object)executionSet.getSlaDueDate());
        Assert.assertEquals((Object)slaDueDate, (Object)executionSet.getSlaDueDate().getValue());
    }

    protected void assertEventCancelActivity(BaseCancellingEventExecutionSet executionSet, boolean isCancelling) {
        Assert.assertNotNull((Object)executionSet.getCancelActivity());
        Assert.assertEquals((Object)isCancelling, (Object)executionSet.getCancelActivity().getValue());
    }

    public abstract void testUnmarshallTopLevelEventFilledProperties() throws Exception;

    public abstract void testUnmarshallTopLevelEmptyEventProperties() throws Exception;

    public abstract void testUnmarshallSubprocessLevelEventFilledProperties() throws Exception;

    public abstract void testUnmarshallSubprocessLevelEventEmptyProperties() throws Exception;

    public abstract void testUnmarshallTopLevelEventWithEdgesFilledProperties() throws Exception;

    public abstract void testUnmarshallTopLevelEventWithEdgesEmptyProperties() throws Exception;

    public abstract void testUnmarshallSubprocessLevelEventWithEdgesEmptyProperties() throws Exception;

    public abstract void testUnmarshallSubprocessLevelEventWithEdgesFilledProperties() throws Exception;

    abstract String getBpmnCatchingIntermediateEventFilePath();

    abstract Class<T> getCatchingIntermediateEventType();

    abstract String getFilledTopLevelEventId();

    abstract String getEmptyTopLevelEventId();

    abstract String getFilledSubprocessLevelEventId();

    abstract String getEmptySubprocessLevelEventId();

    abstract String getFilledTopLevelEventWithEdgesId();

    abstract String getEmptyTopLevelEventWithEdgesId();

    abstract String getFilledSubprocessLevelEventWithEdgesId();

    abstract String getEmptySubprocessLevelEventWithEdgesId();

    private void assertNodesEqualsAfterMarshalling(Diagram<Graph, Metadata> before, Diagram<Graph, Metadata> after, String nodeId, boolean hasIncomeEdge, boolean hasOutgoingEdge) {
        T nodeBeforeMarshalling = this.getCatchingIntermediateNodeById(before, nodeId, hasIncomeEdge, hasOutgoingEdge);
        T nodeAfterMarshalling = this.getCatchingIntermediateNodeById(after, nodeId, hasIncomeEdge, hasOutgoingEdge);
        Assert.assertEquals(nodeBeforeMarshalling, nodeAfterMarshalling);
    }

    T getCatchingIntermediateNodeById(Diagram<Graph, Metadata> diagram, String id, boolean hasIncomeEdge, boolean hasOutgoingEdge) {
        Node node = diagram.getGraph().getNode(id);
        Assert.assertNotNull((Object)node);
        int incomeEdges = hasIncomeEdge ? this.getDefaultAmountOfIncomdeEdges() + 1 : this.getDefaultAmountOfIncomdeEdges();
        Assert.assertEquals((long)incomeEdges, (long)node.getInEdges().size());
        int outgoingEdges = hasOutgoingEdge ? 1 : 0;
        Assert.assertEquals((long)outgoingEdges, (long)node.getOutEdges().size());
        return (T)((BaseCatchingIntermediateEvent)this.getCatchingIntermediateEventType().cast(((Definition)node.getContent()).getDefinition()));
    }

    void checkEventMarshalling(String nodeID, boolean hasIncomeEdge, boolean hasOutgoingEdge) throws Exception {
        Diagram<Graph, Metadata> initialDiagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, this.getBpmnCatchingIntermediateEventFilePath());
        int AMOUNT_OF_NODES_IN_DIAGRAM = this.getNodes(initialDiagram).size();
        String resultXml = this.marshaller.marshall(initialDiagram);
        Diagram<Graph, Metadata> marshalledDiagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, this.getStream(resultXml));
        this.assertDiagram(marshalledDiagram, AMOUNT_OF_NODES_IN_DIAGRAM);
        this.assertNodesEqualsAfterMarshalling(initialDiagram, marshalledDiagram, nodeID, hasIncomeEdge, hasOutgoingEdge);
    }

    void assertGeneralSet(BPMNGeneralSet generalSet, String nodeName, String documentation) {
        Assert.assertNotNull((Object)generalSet);
        Assert.assertNotNull((Object)generalSet.getName());
        Assert.assertNotNull((Object)generalSet.getDocumentation());
        Assert.assertEquals((Object)nodeName, (Object)generalSet.getName().getValue());
        Assert.assertEquals((Object)documentation, (Object)generalSet.getDocumentation().getValue());
    }

    void assertDataIOSet(DataIOSet dataIOSet, String value) {
        Assert.assertNotNull((Object)dataIOSet);
        AssignmentsInfo assignmentsInfo = dataIOSet.getAssignmentsinfo();
        Assert.assertNotNull((Object)assignmentsInfo);
        Assert.assertEquals((Object)value, (Object)assignmentsInfo.getValue());
    }

    protected int getDefaultAmountOfIncomdeEdges() {
        return 1;
    }
}

