/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.service.diagram.marshalling.events.intermediate;

import org.junit.Assert;
import org.junit.Test;
import org.kie.workbench.common.stunner.bpmn.backend.service.diagram.marshalling.events.intermediate.ThrowingIntermediateEventTest;
import org.kie.workbench.common.stunner.bpmn.definition.IntermediateEscalationEventThrowing;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.escalation.EscalationEventExecutionSet;
import org.kie.workbench.common.stunner.core.definition.service.DiagramMarshaller;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.graph.Graph;

public class ThrowingIntermediateEscalationEventTest
extends ThrowingIntermediateEventTest<IntermediateEscalationEventThrowing> {
    private static final String BPMN_THROWING_INTERMEDIATE_EVENT_FILE_PATH = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/throwingIntermediateEscalationEvents.bpmn";
    private static final String EMPTY_TOP_LEVEL_EVENT_ID = "_3DD234F9-171A-4B8D-AA38-853A4B99CBC5";
    private static final String FILLED_TOP_LEVEL_EVENT_ID = "_068F0418-AB4E-4DD0-814C-AD8E001BFC50";
    private static final String EMPTY_SUBPROCESS_LEVEL_EVENT_ID = "_210EE227-2031-4750-B323-A73ADE4E2FDE";
    private static final String FILLED_SUBPROCESS_LEVEL_EVENT_ID = "_6FECB1BF-BF5A-4E04-9D0D-30AA643DCBF5";
    private static final String EMPTY_WITH_INCOME_TOP_LEVEL_EVENT_ID = "_DB9AB0EA-CA45-4224-AB4C-F0EB59397848";
    private static final String FILLED_WITH_INCOME_TOP_LEVEL_EVENT_ID = "_0019B4E6-5B69-4123-BB42-9D5F39E0E04D";
    private static final String EMPTY_WITH_INCOME_SUBPROCESS_LEVEL_EVENT_ID = "_BF3082B5-F7BF-4042-AD99-6FCB53586AA5";
    private static final String FILLED_WITH_INCOME_SUBPROCESS_LEVEL_EVENT_ID = "_CBE4DC6E-49DD-4B50-A970-352C5D412BBD";
    private static final int AMOUNT_OF_NODES_IN_DIAGRAM = 23;

    @Override
    @Test
    public void testUnmarshallTopLevelEventFilledProperties() throws Exception {
        String EVENT_NAME = "Escalation event01 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String EVENT_DOCUMENTATION = "Escalation event01 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String EVENT_REF = "escalation01";
        String EVENT_DATA_INPUT = "input:String||||[din]processGlobalVar->input";
        Diagram<Graph, Metadata> diagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, BPMN_THROWING_INTERMEDIATE_EVENT_FILE_PATH);
        this.assertDiagram(diagram, 23);
        IntermediateEscalationEventThrowing filledTopEvent = (IntermediateEscalationEventThrowing)this.getThrowingIntermediateNodeById(diagram, FILLED_TOP_LEVEL_EVENT_ID, false);
        this.assertGeneralSet(filledTopEvent.getGeneral(), "Escalation event01 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "Escalation event01 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertEscalationEventExecutionSet(filledTopEvent.getExecutionSet(), "escalation01");
        this.assertDataIOSet(filledTopEvent.getDataIOSet(), "input:String||||[din]processGlobalVar->input");
    }

    @Override
    @Test
    public void testUnmarshallTopLevelEmptyEventProperties() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, BPMN_THROWING_INTERMEDIATE_EVENT_FILE_PATH);
        this.assertDiagram(diagram, 23);
        IntermediateEscalationEventThrowing emptyTopEvent = (IntermediateEscalationEventThrowing)this.getThrowingIntermediateNodeById(diagram, EMPTY_TOP_LEVEL_EVENT_ID, false);
        this.assertGeneralSet(emptyTopEvent.getGeneral(), "", "");
        this.assertEscalationEventExecutionSet(emptyTopEvent.getExecutionSet(), "");
        this.assertDataIOSet(emptyTopEvent.getDataIOSet(), "");
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelEventFilledProperties() throws Exception {
        String EVENT_NAME = "Escalation event03 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String EVENT_DOCUMENTATION = "Escalation event03 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String EVENT_REF = "escalation03";
        String EVENT_DATA_INPUT = "input:String||||[din]processGlobalVar->input";
        Diagram<Graph, Metadata> diagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, BPMN_THROWING_INTERMEDIATE_EVENT_FILE_PATH);
        this.assertDiagram(diagram, 23);
        IntermediateEscalationEventThrowing filledSubprocessEvent = (IntermediateEscalationEventThrowing)this.getThrowingIntermediateNodeById(diagram, FILLED_SUBPROCESS_LEVEL_EVENT_ID, false);
        this.assertGeneralSet(filledSubprocessEvent.getGeneral(), "Escalation event03 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "Escalation event03 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertEscalationEventExecutionSet(filledSubprocessEvent.getExecutionSet(), "escalation03");
        this.assertDataIOSet(filledSubprocessEvent.getDataIOSet(), "input:String||||[din]processGlobalVar->input");
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelEventEmptyProperties() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, BPMN_THROWING_INTERMEDIATE_EVENT_FILE_PATH);
        this.assertDiagram(diagram, 23);
        IntermediateEscalationEventThrowing emptySubprocessEvent = (IntermediateEscalationEventThrowing)this.getThrowingIntermediateNodeById(diagram, EMPTY_SUBPROCESS_LEVEL_EVENT_ID, false);
        this.assertGeneralSet(emptySubprocessEvent.getGeneral(), "", "");
        this.assertEscalationEventExecutionSet(emptySubprocessEvent.getExecutionSet(), "");
        this.assertDataIOSet(emptySubprocessEvent.getDataIOSet(), "");
    }

    @Override
    @Test
    public void testUnmarshallTopLevelEventWithIncomeFilledProperties() throws Exception {
        String EVENT_NAME = "Escalation event02 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String EVENT_DOCUMENTATION = "Escalation event02 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String EVENT_REF = "escalation02";
        String EVENT_DATA_INPUT = "input:String||||[din]processGlobalVar->input";
        Diagram<Graph, Metadata> diagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, BPMN_THROWING_INTERMEDIATE_EVENT_FILE_PATH);
        this.assertDiagram(diagram, 23);
        IntermediateEscalationEventThrowing filledSubprocessEvent = (IntermediateEscalationEventThrowing)this.getThrowingIntermediateNodeById(diagram, FILLED_WITH_INCOME_TOP_LEVEL_EVENT_ID, true);
        this.assertGeneralSet(filledSubprocessEvent.getGeneral(), "Escalation event02 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "Escalation event02 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertEscalationEventExecutionSet(filledSubprocessEvent.getExecutionSet(), "escalation02");
        this.assertDataIOSet(filledSubprocessEvent.getDataIOSet(), "input:String||||[din]processGlobalVar->input");
    }

    @Override
    @Test
    public void testUnmarshallTopLevelEventWithIncomeEmptyProperties() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, BPMN_THROWING_INTERMEDIATE_EVENT_FILE_PATH);
        this.assertDiagram(diagram, 23);
        IntermediateEscalationEventThrowing emptyEvent = (IntermediateEscalationEventThrowing)this.getThrowingIntermediateNodeById(diagram, EMPTY_WITH_INCOME_TOP_LEVEL_EVENT_ID, true);
        this.assertGeneralSet(emptyEvent.getGeneral(), "", "");
        this.assertEscalationEventExecutionSet(emptyEvent.getExecutionSet(), "");
        this.assertDataIOSet(emptyEvent.getDataIOSet(), "");
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelEventWithIncomeEmptyProperties() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, BPMN_THROWING_INTERMEDIATE_EVENT_FILE_PATH);
        this.assertDiagram(diagram, 23);
        IntermediateEscalationEventThrowing emptySubprocessEvent = (IntermediateEscalationEventThrowing)this.getThrowingIntermediateNodeById(diagram, EMPTY_WITH_INCOME_SUBPROCESS_LEVEL_EVENT_ID, true);
        this.assertGeneralSet(emptySubprocessEvent.getGeneral(), "", "");
        this.assertEscalationEventExecutionSet(emptySubprocessEvent.getExecutionSet(), "");
        this.assertDataIOSet(emptySubprocessEvent.getDataIOSet(), "");
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelEventWithIncomeFilledProperties() throws Exception {
        String EVENT_NAME = "Escalation event04 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String EVENT_DOCUMENTATION = "Escalation event04 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String EVENT_REF = "escalation04";
        String EVENT_DATA_INPUT = "input:String||||[din]processGlobalVar->input";
        Diagram<Graph, Metadata> diagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, BPMN_THROWING_INTERMEDIATE_EVENT_FILE_PATH);
        this.assertDiagram(diagram, 23);
        IntermediateEscalationEventThrowing filledSubprocessEvent = (IntermediateEscalationEventThrowing)this.getThrowingIntermediateNodeById(diagram, FILLED_WITH_INCOME_SUBPROCESS_LEVEL_EVENT_ID, true);
        this.assertGeneralSet(filledSubprocessEvent.getGeneral(), "Escalation event04 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "Escalation event04 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertEscalationEventExecutionSet(filledSubprocessEvent.getExecutionSet(), "escalation04");
        this.assertDataIOSet(filledSubprocessEvent.getDataIOSet(), "input:String||||[din]processGlobalVar->input");
    }

    @Override
    String getBpmnThrowingIntermediateEventFilePath() {
        return BPMN_THROWING_INTERMEDIATE_EVENT_FILE_PATH;
    }

    @Override
    Class<IntermediateEscalationEventThrowing> getThrowingIntermediateEventType() {
        return IntermediateEscalationEventThrowing.class;
    }

    @Override
    String getFilledTopLevelEventId() {
        return FILLED_TOP_LEVEL_EVENT_ID;
    }

    @Override
    String getEmptyTopLevelEventId() {
        return EMPTY_TOP_LEVEL_EVENT_ID;
    }

    @Override
    String getFilledSubprocessLevelEventId() {
        return FILLED_SUBPROCESS_LEVEL_EVENT_ID;
    }

    @Override
    String getEmptySubprocessLevelEventId() {
        return EMPTY_SUBPROCESS_LEVEL_EVENT_ID;
    }

    @Override
    String getFilledTopLevelEventWithIncomeId() {
        return FILLED_WITH_INCOME_TOP_LEVEL_EVENT_ID;
    }

    @Override
    String getEmptyTopLevelEventWithIncomeId() {
        return EMPTY_WITH_INCOME_TOP_LEVEL_EVENT_ID;
    }

    @Override
    String getFilledSubprocessLevelEventWithIncomeId() {
        return FILLED_WITH_INCOME_SUBPROCESS_LEVEL_EVENT_ID;
    }

    @Override
    String getEmptySubprocessLevelEventWithIncomeId() {
        return EMPTY_WITH_INCOME_SUBPROCESS_LEVEL_EVENT_ID;
    }

    private void assertEscalationEventExecutionSet(EscalationEventExecutionSet executionSet, String eventReference) {
        Assert.assertNotNull((Object)executionSet);
        Assert.assertNotNull((Object)executionSet.getEscalationRef());
        Assert.assertEquals((Object)eventReference, (Object)executionSet.getEscalationRef().getValue());
    }
}

