/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend;

import bpsim.impl.BpsimFactoryImpl;
import bpsim.impl.BpsimPackageImpl;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import org.apache.commons.lang3.StringEscapeUtils;
import org.eclipse.bpmn2.Bpmn2Package;
import org.eclipse.bpmn2.Definitions;
import org.eclipse.bpmn2.DocumentRoot;
import org.eclipse.bpmn2.util.Bpmn2Resource;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.jboss.drools.DroolsPackage;
import org.jboss.drools.impl.DroolsFactoryImpl;
import org.jboss.drools.impl.DroolsPackageImpl;
import org.kie.workbench.common.stunner.bpmn.backend.converters.TypedFactoryManager;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.ConverterFactory;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.DefinitionsBuildingContext;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.DefinitionsConverter;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.PropertyWriterFactory;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.BaseConverterFactory;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.BpmnNode;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.DefinitionResolver;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.GraphBuilder;
import org.kie.workbench.common.stunner.bpmn.backend.resource.JBPMBpmn2Resource;
import org.kie.workbench.common.stunner.bpmn.backend.resource.JBPMBpmn2ResourceFactory;
import org.kie.workbench.common.stunner.bpmn.backend.workitem.service.WorkItemDefinitionBackendService;
import org.kie.workbench.common.stunner.bpmn.definition.BPMNViewDefinition;
import org.kie.workbench.common.stunner.core.api.DefinitionManager;
import org.kie.workbench.common.stunner.core.api.FactoryManager;
import org.kie.workbench.common.stunner.core.backend.service.XMLEncoderDiagramMetadataMarshaller;
import org.kie.workbench.common.stunner.core.definition.service.DiagramMarshaller;
import org.kie.workbench.common.stunner.core.definition.service.DiagramMetadataMarshaller;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandManager;
import org.kie.workbench.common.stunner.core.graph.command.impl.GraphCommandFactory;
import org.kie.workbench.common.stunner.core.graph.content.definition.DefinitionSet;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.content.view.ViewConnector;
import org.kie.workbench.common.stunner.core.rule.RuleManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseDirectDiagramMarshaller
implements DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>> {
    private static final Logger LOG = LoggerFactory.getLogger(BaseDirectDiagramMarshaller.class);
    private final XMLEncoderDiagramMetadataMarshaller diagramMetadataMarshaller;
    private final DefinitionManager definitionManager;
    private final RuleManager ruleManager;
    private final WorkItemDefinitionBackendService workItemDefinitionService;
    protected final TypedFactoryManager typedFactoryManager;
    private final GraphCommandFactory commandFactory;
    private final GraphCommandManager commandManager;

    public BaseDirectDiagramMarshaller(XMLEncoderDiagramMetadataMarshaller diagramMetadataMarshaller, DefinitionManager definitionManager, RuleManager ruleManager, WorkItemDefinitionBackendService workItemDefinitionService, FactoryManager factoryManager, GraphCommandFactory commandFactory, GraphCommandManager commandManager) {
        this.diagramMetadataMarshaller = diagramMetadataMarshaller;
        this.definitionManager = definitionManager;
        this.ruleManager = ruleManager;
        this.workItemDefinitionService = workItemDefinitionService;
        this.typedFactoryManager = new TypedFactoryManager(factoryManager);
        this.commandFactory = commandFactory;
        this.commandManager = commandManager;
    }

    public String marshall(Diagram<Graph, Metadata> diagram) throws IOException {
        LOG.debug("Starting diagram marshalling...");
        Bpmn2Resource resource = this.createBpmn2Resource();
        PropertyWriterFactory propertyWriterFactory = new PropertyWriterFactory();
        DefinitionsConverter definitionsConverter = new DefinitionsConverter(new ConverterFactory(new DefinitionsBuildingContext((Graph<DefinitionSet, Node<View<? extends BPMNViewDefinition>, Edge<ViewConnector<BPMNViewDefinition>, Node<? extends View<? extends BPMNViewDefinition>, ?>>>>)diagram.getGraph(), this.getDiagramClass()), propertyWriterFactory), propertyWriterFactory);
        Definitions definitions = definitionsConverter.toDefinitions();
        resource.getContents().add((Object)definitions);
        LOG.debug("Diagram marshalling completed successfully.");
        String outputString = this.renderToString(resource);
        LOG.trace(outputString);
        return outputString;
    }

    public Definitions marshallToBpmn2Definitions(Diagram<Graph, Metadata> diagram) throws IOException {
        String marshalled = this.marshall(diagram);
        try (BufferedInputStream inputStream = new BufferedInputStream(new ByteArrayInputStream(marshalled.getBytes(StandardCharsets.UTF_8)));){
            Definitions definitions = BaseDirectDiagramMarshaller.parseDefinitions(inputStream).getDefinitions();
            return definitions;
        }
    }

    private String renderToString(Bpmn2Resource resource) throws IOException {
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            resource.save((OutputStream)outputStream, new HashMap());
        }
        return StringEscapeUtils.unescapeHtml4((String)outputStream.toString("UTF-8"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Graph<DefinitionSet, Node> unmarshall(Metadata metadata, InputStream inputStream) throws IOException {
        DefinitionResolver definitionResolver;
        LOG.debug("Starting diagram unmarshalling...");
        try {
            DefinitionsHandler definitionsHandler = BaseDirectDiagramMarshaller.parseDefinitions(inputStream);
            definitionResolver = new DefinitionResolver(definitionsHandler.getDefinitions(), this.workItemDefinitionService.execute(metadata), definitionsHandler.isJbpm());
        }
        finally {
            inputStream.close();
        }
        metadata.setCanvasRootUUID(definitionResolver.getDefinitions().getId());
        metadata.setTitle(definitionResolver.getProcess().getName());
        BaseConverterFactory converterFactory = this.createToStunnerConverterFactory(definitionResolver, this.typedFactoryManager);
        BpmnNode diagramRoot = converterFactory.rootProcessConverter().convertProcess();
        LOG.debug("Diagram unmarshalling completed successfully.");
        Diagram<Graph<DefinitionSet, Node>, Metadata> diagram = this.typedFactoryManager.newDiagram(definitionResolver.getDefinitions().getId(), this.getDefinitionSetClass(), metadata);
        GraphBuilder graphBuilder = new GraphBuilder((Graph<DefinitionSet, Node>)diagram.getGraph(), this.definitionManager, this.typedFactoryManager, this.ruleManager, this.commandFactory, this.commandManager);
        graphBuilder.render(diagramRoot);
        LOG.debug("Diagram drawing completed successfully.");
        return diagram.getGraph();
    }

    private Bpmn2Resource createBpmn2Resource() {
        DroolsFactoryImpl.init();
        BpsimFactoryImpl.init();
        ResourceSetImpl rSet = new ResourceSetImpl();
        rSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("bpmn2", new JBPMBpmn2ResourceFactory());
        Bpmn2Resource resource = (Bpmn2Resource)rSet.createResource(URI.createURI((String)"virtual.bpmn2"));
        rSet.getResources().add((Object)resource);
        return resource;
    }

    public DiagramMetadataMarshaller<Metadata> getMetadataMarshaller() {
        return this.diagramMetadataMarshaller;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DefinitionsHandler parseDefinitions(InputStream inputStream) throws IOException {
        DroolsPackageImpl.init();
        BpsimPackageImpl.init();
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource.Factory.Registry resourceFactoryRegistry = resourceSet.getResourceFactoryRegistry();
        resourceFactoryRegistry.getExtensionToFactoryMap().put("*", new JBPMBpmn2ResourceFactory());
        EPackage.Registry packageRegistry = resourceSet.getPackageRegistry();
        packageRegistry.put((Object)"http://www.omg.org/spec/BPMN/20100524/MODEL", (Object)Bpmn2Package.eINSTANCE);
        packageRegistry.put((Object)"http://www.jboss.org/drools", (Object)DroolsPackage.eINSTANCE);
        JBPMBpmn2Resource resource = (JBPMBpmn2Resource)resourceSet.createResource(URI.createURI((String)"inputStream://dummyUriWithValidSuffix.xml"));
        resource.getDefaultLoadOptions().put("ENCODING", "UTF-8");
        resource.setEncoding("UTF-8");
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("ENCODING", "UTF-8");
        options.put("DEFER_IDREF_RESOLUTION", true);
        options.put("DISABLE_NOTIFY", true);
        options.put("PROCESS_DANGLING_HREF", "RECORD");
        try {
            resource.load(inputStream, options);
        }
        finally {
            inputStream.close();
        }
        DocumentRoot root = (DocumentRoot)resource.getContents().get(0);
        return new DefinitionsHandler(root);
    }

    protected abstract BaseConverterFactory createToStunnerConverterFactory(DefinitionResolver var1, TypedFactoryManager var2);

    protected abstract Class<?> getDefinitionSetClass();

    protected abstract Class<?> getDiagramClass();

    static class DefinitionsHandler {
        private static final String JBPM_PREFIX = "jBPM";
        private static final String DROOLS_NAMESPACE = "http://www.jboss.org/drools";
        private final Definitions definitions;
        private final boolean jbpm;

        DefinitionsHandler(DocumentRoot root) {
            this.definitions = root.getDefinitions();
            this.jbpm = DefinitionsHandler.isJbpmnDocument(root, this.definitions);
        }

        public Definitions getDefinitions() {
            return this.definitions;
        }

        public boolean isJbpm() {
            return this.jbpm;
        }

        private static boolean isJbpmnDocument(DocumentRoot root, Definitions definitions) {
            String exporter = definitions.getExporter();
            if (exporter != null) {
                return exporter.toLowerCase().startsWith(JBPM_PREFIX.toLowerCase());
            }
            return root.getXMLNSPrefixMap().values().contains(DROOLS_NAMESPACE) || root.getXSISchemaLocation().keySet().contains(DROOLS_NAMESPACE);
        }
    }
}

