/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters;

import java.util.LinkedList;
import java.util.Optional;
import java.util.function.Function;
import org.kie.workbench.common.stunner.bpmn.backend.converters.Result;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.View;

public class Match<In, Out> {
    private final Class<?> outputType;
    private final LinkedList<Case<?, Out>> cases = new LinkedList();
    private Function<In, Out> orElse;

    public Match(Class<?> outputType) {
        this.outputType = outputType;
    }

    public static <In, Out> Match<In, Out> of(Class<In> inputType, Class<Out> outputType) {
        return new Match<In, Out>(outputType);
    }

    public static <In, Out> Match<In, Node<? extends View<? extends Out>, ?>> ofNode(Class<In> inputType, Class<Out> outputType) {
        return new Match<In, Out>(outputType);
    }

    public static <In, Out> Match<Node<? extends View<? extends In>, ?>, Out> fromNode(Class<In> inputType, Class<Out> outputType) {
        return new Match<In, Out>(outputType);
    }

    public static <In, Out> Match<In, Edge<? extends View<? extends Out>, ?>> ofEdge(Class<In> inputType, Class<Out> outputType) {
        return new Match<In, Out>(outputType);
    }

    private static <T, U> Function<T, Result<U>> reportMissing(Class<?> expectedClass) {
        return t -> Result.failure("Not yet implemented: " + Optional.ofNullable(t).map(o -> o.getClass().getCanonicalName()).orElse("null -- expected " + expectedClass.getCanonicalName()));
    }

    private static <T, U> Function<T, Result<U>> ignored(Class<?> expectedClass) {
        return t -> Result.ignored("Ignored: " + Optional.ofNullable(t).map(o -> o.getClass().getCanonicalName()).orElse("null -- expected " + expectedClass.getCanonicalName()));
    }

    public <Sub> Match<In, Out> when(Class<Sub> type, Function<Sub, Out> then) {
        Function<Object, Result> thenWrapped = sub -> Result.of(then.apply(sub));
        return this.when_(type, thenWrapped);
    }

    private <Sub> Match<In, Out> when_(Class<Sub> type, Function<Sub, Result<Out>> then) {
        this.cases.add(new Case(type, then));
        return this;
    }

    public <Sub> Match<In, Out> missing(Class<Sub> type) {
        return this.when_(type, Match.reportMissing(type));
    }

    public <Sub> Match<In, Out> ignore(Class<Sub> type) {
        return this.when_(type, Match.ignored(type));
    }

    public Match<In, Out> orElse(Function<In, Out> then) {
        this.orElse = then;
        return this;
    }

    public Result<Out> apply(In value) {
        return this.cases.stream().map(c -> c.match(value)).filter(Result::nonFailure).findFirst().orElseGet(() -> this.applyFallback(value));
    }

    private Result<Out> applyFallback(In value) {
        if (this.orElse == null) {
            return Result.failure(value == null ? "Null" : value.getClass().getName());
        }
        return Result.of(this.orElse.apply(value));
    }

    private static class Case<T, R> {
        public final Class<T> when;
        public final Function<T, Result<R>> then;

        private Case(Class<T> when, Function<T, Result<R>> then) {
            this.when = when;
            this.then = then;
        }

        public Result<R> match(Object value) {
            return this.when.isAssignableFrom(value.getClass()) ? this.then.apply(value) : Result.failure(value.getClass().getName());
        }
    }
}

