/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters;

import java.util.NoSuchElementException;
import java.util.function.Consumer;

public interface Result<T> {
    public static <R> Result<R> of(R value) {
        return new Success<R>(value);
    }

    public static <R> Result<R> success(R value) {
        return new Success<R>(value);
    }

    public static <R> Result<R> failure(String reason) {
        return new Failure(reason);
    }

    public static <U> Result<U> ignored(String reason) {
        return new Ignored(reason);
    }

    public boolean isFailure();

    public boolean isIgnored();

    public boolean isSuccess();

    default public boolean nonFailure() {
        return !this.isFailure();
    }

    default public boolean notIgnored() {
        return !this.isIgnored();
    }

    default public T value() {
        return this.asSuccess().value();
    }

    default public void ifSuccess(Consumer<T> consumer) {
        if (this.isSuccess()) {
            consumer.accept(this.asSuccess().value());
        }
    }

    default public void ifFailure(Consumer<String> consumer) {
        if (this.isFailure()) {
            consumer.accept(this.asFailure().reason());
        }
    }

    public Success<T> asSuccess();

    public Failure<T> asFailure();

    public Ignored<T> asIgnored();

    public static class Failure<T>
    implements Result<T> {
        private final String reason;

        Failure(String reason) {
            this.reason = reason;
        }

        public String reason() {
            return this.reason;
        }

        @Override
        public Success<T> asSuccess() {
            throw new NoSuchElementException(this.reason);
        }

        @Override
        public Ignored<T> asIgnored() {
            throw new ClassCastException("Could not convert Failure to Ignored");
        }

        @Override
        public Failure<T> asFailure() {
            return this;
        }

        @Override
        public boolean isSuccess() {
            return false;
        }

        @Override
        public boolean isIgnored() {
            return false;
        }

        @Override
        public boolean isFailure() {
            return true;
        }
    }

    public static class Ignored<T>
    implements Result<T> {
        private final String reason;

        Ignored(String reason) {
            this.reason = reason;
        }

        public String reason() {
            return this.reason;
        }

        @Override
        public Success<T> asSuccess() {
            throw new NoSuchElementException(this.reason);
        }

        @Override
        public Ignored<T> asIgnored() {
            return this;
        }

        @Override
        public Failure<T> asFailure() {
            throw new ClassCastException("Could not convert Ignored to Success");
        }

        @Override
        public boolean isSuccess() {
            return false;
        }

        @Override
        public boolean isIgnored() {
            return true;
        }

        @Override
        public boolean isFailure() {
            return false;
        }
    }

    public static class Success<T>
    implements Result<T> {
        private final T value;

        Success(T value) {
            this.value = value;
        }

        @Override
        public T value() {
            return this.value;
        }

        @Override
        public Success<T> asSuccess() {
            return this;
        }

        @Override
        public Ignored<T> asIgnored() {
            throw new ClassCastException("Could not convert Success to Ignored");
        }

        @Override
        public Failure<T> asFailure() {
            throw new ClassCastException("Could not convert Success to Failure");
        }

        @Override
        public boolean isSuccess() {
            return true;
        }

        @Override
        public boolean isIgnored() {
            return false;
        }

        @Override
        public boolean isFailure() {
            return false;
        }
    }
}

