/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.associations.AssociationType;
import org.kie.workbench.common.stunner.bpmn.definition.property.notification.NotificationTypeListValue;
import org.kie.workbench.common.stunner.bpmn.definition.property.notification.NotificationValue;

public class ParsedNotificationsInfos {
    NotificationValue notification = new NotificationValue();

    private ParsedNotificationsInfos(String type, String body) {
        this.notification.setType(type);
        if (body != null && !body.isEmpty()) {
            String temp;
            if (body.contains("@")) {
                String[] parts = body.split("@");
                ParsedNotificationsInfos.parsePeriod(this.notification, parts[1]);
                temp = parts[0];
            } else {
                temp = body;
            }
            temp = ParsedNotificationsInfos.replaceBracket(temp);
            ParsedNotificationsInfos.getFrom(this.notification, temp);
            ParsedNotificationsInfos.getUsers(this.notification, temp);
            ParsedNotificationsInfos.getGroups(this.notification, temp);
            ParsedNotificationsInfos.getReplyTo(this.notification, temp);
            ParsedNotificationsInfos.getSubject(this.notification, temp);
            ParsedNotificationsInfos.getBody(this.notification, temp);
        }
    }

    private static void getFrom(NotificationValue notification, String body) {
        notification.setFrom(ParsedNotificationsInfos.parseElement(body, "from", 0));
    }

    private static String parseElement(String group, String type, int position) {
        String result;
        if (group.contains(type) && !(result = group.split("\\|")[position].replace(type + ":", "")).isEmpty()) {
            return result;
        }
        return null;
    }

    private static void getUsers(NotificationValue notification, String body) {
        notification.setUsers(ParsedNotificationsInfos.parseGroup(body, "tousers", 1));
    }

    private static List<String> parseGroup(String group, String type, int position) {
        String result;
        if (group.contains(type) && !(result = group.split("\\|")[position].replace(type + ":", "")).isEmpty()) {
            return Arrays.stream(result.split(",")).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }

    private static void getGroups(NotificationValue notification, String body) {
        notification.setGroups(ParsedNotificationsInfos.parseGroup(body, "togroups", 2));
    }

    private static void getReplyTo(NotificationValue notification, String body) {
        notification.setReplyTo(ParsedNotificationsInfos.parseElement(body, "replyTo", 3));
    }

    private static void getSubject(NotificationValue notification, String body) {
        notification.setSubject(ParsedNotificationsInfos.parseElement(body, "subject", 4));
    }

    private static void getBody(NotificationValue notification, String body) {
        notification.setBody(ParsedNotificationsInfos.parseElement(body, "body", 5));
    }

    private static void parsePeriod(NotificationValue notification, String part) {
        notification.setExpiresAt(ParsedNotificationsInfos.replaceBracket(part));
    }

    private static String replaceBracket(String original) {
        return original.replaceFirst("\\[", "").replace("]", "");
    }

    public static NotificationValue of(String type, String body) {
        return new ParsedNotificationsInfos((String)type, (String)body).notification;
    }

    public static String ofCDATA(NotificationTypeListValue values, AssociationType type) {
        return new CDATA(values, type).get();
    }

    private static class CDATA {
        private List<NotificationValue> notifications;
        private AssociationType type;

        CDATA(NotificationTypeListValue value, AssociationType type) {
            this.type = type;
            this.notifications = value.getValues();
        }

        String get() {
            return this.notifications.stream().filter(m -> m.getType().equals(this.type.getName())).map(m -> m.toCDATAFormat()).collect(Collectors.joining("^"));
        }
    }
}

