/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties;

import bpsim.ElementParameters;
import java.util.List;
import org.eclipse.bpmn2.Activity;
import org.eclipse.bpmn2.DataInput;
import org.eclipse.bpmn2.DataInputAssociation;
import org.eclipse.bpmn2.DataOutput;
import org.eclipse.bpmn2.DataOutputAssociation;
import org.eclipse.bpmn2.FlowElement;
import org.eclipse.bpmn2.InputOutputSpecification;
import org.eclipse.bpmn2.InputSet;
import org.eclipse.bpmn2.OutputSet;
import org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties.InitializedVariable;
import org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties.ParsedAssignmentsInfo;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.Factories;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.PropertyWriter;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.VariableScope;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.AssignmentsInfos;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.SimulationSets;
import org.kie.workbench.common.stunner.bpmn.definition.property.dataio.AssignmentsInfo;
import org.kie.workbench.common.stunner.bpmn.definition.property.simulation.SimulationSet;

public class ActivityPropertyWriter
extends PropertyWriter {
    protected final Activity activity;
    private ElementParameters simulationParameters;

    public ActivityPropertyWriter(Activity activity, VariableScope variableScope) {
        super((FlowElement)activity, variableScope);
        this.activity = activity;
    }

    public Activity getFlowElement() {
        return this.activity;
    }

    public void setSimulationSet(SimulationSet simulationSet) {
        this.simulationParameters = SimulationSets.toElementParameters(simulationSet);
        this.simulationParameters.setElementRef(this.activity.getId());
    }

    @Override
    public ElementParameters getSimulationParameters() {
        return this.simulationParameters;
    }

    public void setAssignmentsInfo(AssignmentsInfo info) {
        ParsedAssignmentsInfo assignmentsInfo = ParsedAssignmentsInfo.of(info);
        InputOutputSpecification ioSpec = this.getIoSpecification();
        List<InitializedVariable.InitializedInputVariable> inputs = assignmentsInfo.createInitializedInputVariables(this.getId(), this.variableScope);
        for (InitializedVariable.InitializedInputVariable input : inputs) {
            if (AssignmentsInfos.isReservedIdentifier(input.getIdentifier())) continue;
            DataInput dataInput = input.getDataInput();
            this.getInputSet(ioSpec).getDataInputRefs().add(dataInput);
            ioSpec.getDataInputs().add(dataInput);
            this.addItemDefinition(input.getItemDefinition());
            DataInputAssociation dataInputAssociation = input.getDataInputAssociation();
            if (dataInputAssociation == null) continue;
            this.activity.getDataInputAssociations().add(dataInputAssociation);
        }
        List<InitializedVariable.InitializedOutputVariable> outputs = assignmentsInfo.createInitializedOutputVariables(this.getId(), this.variableScope);
        for (InitializedVariable.InitializedOutputVariable output : outputs) {
            DataOutput dataOutput = output.getDataOutput();
            this.getOutputSet(ioSpec).getDataOutputRefs().add(dataOutput);
            ioSpec.getDataOutputs().add(dataOutput);
            this.addItemDefinition(output.getItemDefinition());
            DataOutputAssociation dataOutputAssociation = output.getDataOutputAssociation();
            if (dataOutputAssociation == null) continue;
            this.activity.getDataOutputAssociations().add(dataOutputAssociation);
        }
    }

    protected InputOutputSpecification getIoSpecification() {
        InputOutputSpecification ioSpecification = this.activity.getIoSpecification();
        if (ioSpecification == null) {
            ioSpecification = Factories.bpmn2.createInputOutputSpecification();
            this.activity.setIoSpecification(ioSpecification);
        }
        return ioSpecification;
    }

    protected InputSet getInputSet(InputOutputSpecification ioSpecification) {
        InputSet inputSet;
        List inputSets = ioSpecification.getInputSets();
        if (inputSets.isEmpty()) {
            inputSet = Factories.bpmn2.createInputSet();
            inputSets.add(inputSet);
        } else {
            inputSet = (InputSet)inputSets.get(0);
        }
        return inputSet;
    }

    protected OutputSet getOutputSet(InputOutputSpecification ioSpecification) {
        OutputSet outputSet;
        List outputSets = ioSpecification.getOutputSets();
        if (outputSets.isEmpty()) {
            outputSet = Factories.bpmn2.createOutputSet();
            outputSets.add(outputSet);
        } else {
            outputSet = (OutputSet)outputSets.get(0);
        }
        return outputSet;
    }
}

