/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner;

import org.kie.workbench.common.stunner.bpmn.backend.converters.TypedFactoryManager;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.DefinitionResolver;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.EdgeConverter;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.FlowElementConverter;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.ProcessPostConverter;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.activities.BaseCallActivityConverter;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.events.EndEventConverter;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.events.IntermediateCatchEventConverter;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.events.IntermediateThrowEventConverter;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.events.StartEventConverter;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.gateways.GatewayConverter;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.lanes.LaneConverter;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.processes.BaseRootProcessConverter;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.processes.BaseSubProcessConverter;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.PropertyReaderFactory;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.tasks.BaseTaskConverter;

public abstract class BaseConverterFactory {
    protected final DefinitionResolver definitionResolver;
    protected final TypedFactoryManager factoryManager;
    protected final PropertyReaderFactory propertyReaderFactory;
    private final EdgeConverter edgeConverter;
    private final FlowElementConverter flowElementConverter;
    private final StartEventConverter startEventConverter;
    private final IntermediateCatchEventConverter intermediateCatchEventConverter;
    private final IntermediateThrowEventConverter intermediateThrowEventConverter;
    private final EndEventConverter endEventConverter;
    private final LaneConverter laneConverter;
    private final GatewayConverter gatewayConverter;

    public BaseConverterFactory(DefinitionResolver definitionResolver, TypedFactoryManager factoryManager, PropertyReaderFactory propertyReaderFactory) {
        this.definitionResolver = definitionResolver;
        this.factoryManager = factoryManager;
        this.propertyReaderFactory = propertyReaderFactory;
        this.flowElementConverter = new FlowElementConverter(this);
        this.startEventConverter = new StartEventConverter(factoryManager, propertyReaderFactory);
        this.intermediateCatchEventConverter = new IntermediateCatchEventConverter(factoryManager, propertyReaderFactory);
        this.intermediateThrowEventConverter = new IntermediateThrowEventConverter(factoryManager, propertyReaderFactory);
        this.endEventConverter = new EndEventConverter(factoryManager, propertyReaderFactory);
        this.laneConverter = new LaneConverter(factoryManager, propertyReaderFactory);
        this.gatewayConverter = new GatewayConverter(factoryManager, propertyReaderFactory);
        this.edgeConverter = new EdgeConverter(factoryManager, propertyReaderFactory);
    }

    public FlowElementConverter flowElementConverter() {
        return this.flowElementConverter;
    }

    public EdgeConverter edgeConverter() {
        return this.edgeConverter;
    }

    public StartEventConverter startEventConverter() {
        return this.startEventConverter;
    }

    public IntermediateCatchEventConverter intermediateCatchEventConverter() {
        return this.intermediateCatchEventConverter;
    }

    public IntermediateThrowEventConverter intermediateThrowEventConverter() {
        return this.intermediateThrowEventConverter;
    }

    public EndEventConverter endEventConverter() {
        return this.endEventConverter;
    }

    public abstract BaseCallActivityConverter callActivityConverter();

    public abstract BaseRootProcessConverter rootProcessConverter();

    public abstract BaseSubProcessConverter subProcessConverter();

    public LaneConverter laneConverter() {
        return this.laneConverter;
    }

    public GatewayConverter gatewayConverter() {
        return this.gatewayConverter;
    }

    public abstract BaseTaskConverter taskConverter();

    public ProcessPostConverter newProcessPostConverter() {
        return new ProcessPostConverter();
    }
}

