/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.bpmn2.di.BPMNEdge;
import org.eclipse.dd.dc.Bounds;
import org.eclipse.dd.dc.Point;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.BpmnEdge;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.BpmnNode;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.DefinitionResolver;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.SequenceFlowPropertyReader;
import org.kie.workbench.common.stunner.bpmn.definition.AdHocSubprocess;
import org.kie.workbench.common.stunner.bpmn.definition.BaseSubprocess;
import org.kie.workbench.common.stunner.bpmn.definition.EmbeddedSubprocess;
import org.kie.workbench.common.stunner.bpmn.definition.EventSubprocess;
import org.kie.workbench.common.stunner.bpmn.definition.Lane;
import org.kie.workbench.common.stunner.bpmn.definition.property.dimensions.Height;
import org.kie.workbench.common.stunner.bpmn.definition.property.dimensions.RectangleDimensionsSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.dimensions.Width;
import org.kie.workbench.common.stunner.core.graph.content.Bound;
import org.kie.workbench.common.stunner.core.graph.content.view.Connection;
import org.kie.workbench.common.stunner.core.graph.content.view.MagnetConnection;
import org.kie.workbench.common.stunner.core.graph.content.view.Point2D;
import org.kie.workbench.common.stunner.core.graph.content.view.View;

public class ProcessPostConverter {
    private static double PRECISION = 1.0;
    private PostConverterContext context;

    ProcessPostConverter() {
    }

    public void postConvert(BpmnNode rootNode, DefinitionResolver definitionResolver) {
        if (definitionResolver.getResolutionFactor() != 1.0) {
            this.context = PostConverterContext.of(rootNode, definitionResolver.isJbpm());
            ProcessPostConverter.adjustAllEdgeConnections(rootNode, true);
            if (this.context.hasCollapsedNodes()) {
                ArrayList laneInfos = new ArrayList();
                new ArrayList<BpmnNode>(rootNode.getChildren()).stream().filter(ProcessPostConverter::isLane).filter(BpmnNode::hasChildren).forEach(lane -> {
                    LaneInfo laneInfo = new LaneInfo((BpmnNode)lane, Padding.of(lane), (List<BpmnNode>)new ArrayList<BpmnNode>(lane.getChildren()));
                    laneInfos.add(laneInfo);
                    laneInfo.getChildren().forEach(child -> child.setParent(rootNode));
                    rootNode.removeChild((BpmnNode)lane);
                });
                rootNode.getChildren().stream().filter(ProcessPostConverter::isSubProcess).forEach(this::postConvertSubProcess);
                List<BpmnNode> resizedChildren = this.context.getResizedChildren(rootNode);
                resizedChildren.forEach(resizedChild -> this.applyNodeResize(rootNode, (BpmnNode)resizedChild));
                laneInfos.forEach(laneInfo -> {
                    laneInfo.getLane().setParent(rootNode);
                    laneInfo.getChildren().forEach(node -> node.setParent(laneInfo.getLane()));
                    ProcessPostConverter.adjustLane(laneInfo.getLane(), laneInfo.getPadding());
                });
                ProcessPostConverter.adjustAllEdgeConnections(rootNode, false);
            }
        }
    }

    private void postConvertSubProcess(BpmnNode subProcess) {
        subProcess.getChildren().stream().filter(ProcessPostConverter::isSubProcess).forEach(this::postConvertSubProcess);
        List<BpmnNode> resizedChildren = this.context.getResizedChildren(subProcess);
        resizedChildren.forEach(resizedChild -> this.applyNodeResize(subProcess, (BpmnNode)resizedChild));
        if (this.context.isCollapsed(subProcess) && subProcess.hasChildren() || !resizedChildren.isEmpty()) {
            this.resizeSubProcess(subProcess);
        }
        if (this.context.isCollapsed(subProcess)) {
            Bound subProcessUl = ((View)subProcess.value().getContent()).getBounds().getUpperLeft();
            subProcess.getChildren().stream().filter(child -> !child.isDocked()).forEach(child -> this.translate((BpmnNode)child, subProcessUl.getX(), subProcessUl.getY()));
            ProcessPostConverter.translate(subProcess.getEdges(), (double)subProcessUl.getX(), (double)subProcessUl.getY());
            this.context.setCollapsed(subProcess, false);
        }
    }

    private void resizeSubProcess(BpmnNode subProcess) {
        if (subProcess.hasChildren()) {
            ViewPort viewPort = ViewPort.of(subProcess, true);
            double leftPadding = viewPort.getUpperLeftX();
            double topPadding = viewPort.getUpperLeftY();
            double width = viewPort.getLowerRightX() + leftPadding;
            double height = viewPort.getLowerRightY() + topPadding;
            org.kie.workbench.common.stunner.core.graph.content.Bounds subProcessBounds = ((View)subProcess.value().getContent()).getBounds();
            Bound subProcessUl = subProcessBounds.getUpperLeft();
            Bound subProcessLr = subProcessBounds.getLowerRight();
            org.kie.workbench.common.stunner.core.graph.content.Bounds subProcessOriginalBounds = org.kie.workbench.common.stunner.core.graph.content.Bounds.create((double)subProcessUl.getX(), (double)subProcessUl.getY(), (double)subProcessLr.getX(), (double)subProcessLr.getY());
            double originalWidth = subProcessBounds.getWidth();
            double originalHeight = subProcessBounds.getHeight();
            subProcessLr.setX(Double.valueOf(subProcessUl.getX() + width));
            subProcessLr.setY(Double.valueOf(subProcessUl.getY() + height));
            RectangleDimensionsSet subProcessRectangle = ((BaseSubprocess)((View)subProcess.value().getContent()).getDefinition()).getDimensionsSet();
            subProcessRectangle.setWidth(new Width(Double.valueOf(width)));
            subProcessRectangle.setHeight(new Height(Double.valueOf(height)));
            this.context.setResized(subProcess, true);
            double widthFactor = width / originalWidth;
            double heightFactor = height / originalHeight;
            ProcessPostConverter.inEdges(subProcess.getParent(), subProcess).forEach(edge -> ProcessPostConverter.scale(edge.getTargetConnection().getLocation(), widthFactor, heightFactor));
            ProcessPostConverter.outEdges(subProcess.getParent(), subProcess).forEach(edge -> ProcessPostConverter.scale(edge.getSourceConnection().getLocation(), widthFactor, heightFactor));
            ProcessPostConverter.dockedNodes(subProcess.getParent(), subProcess).forEach(node -> ProcessPostConverter.scaleBoundaryEventPosition(node, subProcessOriginalBounds, subProcessBounds, widthFactor, heightFactor));
        }
    }

    private static void scaleBoundaryEventPosition(BpmnNode boundaryEvent, org.kie.workbench.common.stunner.core.graph.content.Bounds subProcessOriginalBounds, org.kie.workbench.common.stunner.core.graph.content.Bounds subProcessCurrentBounds, double widthFactor, double heightFactor) {
        org.kie.workbench.common.stunner.core.graph.content.Bounds bounds = ((View)boundaryEvent.value().getContent()).getBounds();
        Bound ul = bounds.getUpperLeft();
        Bound lr = bounds.getLowerRight();
        double width = bounds.getWidth();
        double height = bounds.getHeight();
        if (ul.getX() > 0.0 && ul.getY() <= 0.0) {
            ul.setX(Double.valueOf(ul.getX() * widthFactor));
        } else if (ul.getX() >= subProcessOriginalBounds.getWidth() - width / 2.0 && ul.getY() > 0.0) {
            ul.setX(Double.valueOf(ul.getX() + subProcessCurrentBounds.getWidth() - subProcessOriginalBounds.getWidth()));
            ul.setY(Double.valueOf(ul.getY() * heightFactor));
        } else if (ul.getX() > 0.0 && ul.getY() >= subProcessOriginalBounds.getHeight() - height / 2.0) {
            ul.setX(Double.valueOf(ul.getX() * widthFactor));
            ul.setY(Double.valueOf(ul.getY() + subProcessCurrentBounds.getHeight() - subProcessOriginalBounds.getHeight()));
        } else if (ul.getX() <= 0.0 && ul.getY() > 0.0) {
            ul.setY(Double.valueOf(ul.getY() * heightFactor));
        }
        lr.setX(Double.valueOf(ul.getX() + width));
        lr.setY(Double.valueOf(ul.getY() + height));
    }

    private static void adjustLane(BpmnNode lane, Padding padding) {
        if (lane.hasChildren()) {
            ViewPort viewPort = ViewPort.of(lane, false);
            org.kie.workbench.common.stunner.core.graph.content.Bounds laneBounds = ((View)lane.value().getContent()).getBounds();
            Bound laneUl = laneBounds.getUpperLeft();
            Bound laneLr = laneBounds.getLowerRight();
            laneUl.setX(Double.valueOf(viewPort.getUpperLeftX() - padding.getLeft()));
            laneUl.setY(Double.valueOf(viewPort.getUpperLeftY() - padding.getTop()));
            laneLr.setX(Double.valueOf(viewPort.getLowerRightX() + padding.getRight()));
            laneLr.setY(Double.valueOf(viewPort.getLowerRightY() + padding.getBottom()));
            RectangleDimensionsSet laneRectangle = ((Lane)((View)lane.value().getContent()).getDefinition()).getDimensionsSet();
            laneRectangle.setWidth(new Width(Double.valueOf(laneBounds.getWidth())));
            laneRectangle.setHeight(new Height(Double.valueOf(laneBounds.getHeight())));
        }
    }

    private static void adjustEdgeConnections(BpmnEdge.Simple edge, boolean includeMagnets) {
        if (includeMagnets) {
            ProcessPostConverter.adjustMagnet(edge, true);
            ProcessPostConverter.adjustMagnet(edge, false);
        }
        ProcessPostConverter.adjustEdgeConnection(edge, true);
        ProcessPostConverter.adjustEdgeConnection(edge, false);
    }

    private static void adjustMagnet(BpmnEdge.Simple edge, boolean targetConnection) {
        SequenceFlowPropertyReader propertyReader = (SequenceFlowPropertyReader)edge.getPropertyReader();
        BPMNEdge bpmnEdge = propertyReader.getDefinitionResolver().getEdge(propertyReader.getElement().getId());
        if (bpmnEdge.getWaypoint().size() >= 2) {
            org.kie.workbench.common.stunner.core.graph.content.Bounds nodeBounds;
            Point2D magnetLocation;
            Connection magnetConnection;
            Bounds bounds;
            Point wayPoint;
            if (targetConnection) {
                wayPoint = (Point)bpmnEdge.getWaypoint().get(bpmnEdge.getWaypoint().size() - 1);
                bounds = edge.getTarget().getPropertyReader().getShape().getBounds();
                magnetConnection = edge.getTargetConnection();
                magnetLocation = magnetConnection.getLocation();
                nodeBounds = ((View)edge.getTarget().value().getContent()).getBounds();
            } else {
                wayPoint = (Point)bpmnEdge.getWaypoint().get(0);
                bounds = edge.getSource().getPropertyReader().getShape().getBounds();
                magnetConnection = edge.getSourceConnection();
                magnetLocation = magnetConnection.getLocation();
                nodeBounds = ((View)edge.getSource().value().getContent()).getBounds();
            }
            double wayPointX = wayPoint.getX();
            double wayPointY = wayPoint.getY();
            double boundX = bounds.getX();
            double boundY = bounds.getY();
            double width = bounds.getWidth();
            double height = bounds.getHeight();
            if (ProcessPostConverter.equals(wayPointY, boundY, PRECISION)) {
                magnetLocation.setX(nodeBounds.getWidth() / 2.0);
                magnetLocation.setY(0.0);
            } else if (ProcessPostConverter.equals(wayPointY, boundY + height, PRECISION)) {
                magnetLocation.setX(nodeBounds.getWidth() / 2.0);
                magnetLocation.setY(nodeBounds.getHeight());
            } else if (ProcessPostConverter.equals(wayPointX, boundX, PRECISION)) {
                magnetLocation.setX(0.0);
                magnetLocation.setY(nodeBounds.getHeight() / 2.0);
            } else if (ProcessPostConverter.equals(wayPointX, boundX + width, PRECISION)) {
                magnetLocation.setX(nodeBounds.getWidth());
                magnetLocation.setY(nodeBounds.getHeight() / 2.0);
            } else if (magnetConnection instanceof MagnetConnection) {
                ((MagnetConnection)magnetConnection).setAuto(true);
            }
        }
    }

    private static void adjustAllEdgeConnections(BpmnNode parentNode, boolean includeMagnets) {
        parentNode.getChildren().stream().filter(child -> !child.isDocked()).forEach(node -> ProcessPostConverter.adjustAllEdgeConnections(node, includeMagnets));
        ProcessPostConverter.simpleEdges(parentNode.getEdges()).forEach(edge -> ProcessPostConverter.adjustEdgeConnections(edge, includeMagnets));
    }

    private static void adjustEdgeConnection(BpmnEdge.Simple edge, boolean targetConnection) {
        BpmnNode connectionPointNode;
        Point2D magnetPoint;
        Connection magnetConnection;
        Point2D siblingPoint = null;
        List<Point2D> controlPoints = edge.getControlPoints();
        if (targetConnection) {
            magnetConnection = edge.getTargetConnection();
            magnetPoint = magnetConnection.getLocation();
            connectionPointNode = edge.getTarget();
            if (controlPoints.size() >= 1) {
                siblingPoint = controlPoints.get(controlPoints.size() - 1);
            }
        } else {
            magnetConnection = edge.getSourceConnection();
            magnetPoint = magnetConnection.getLocation();
            connectionPointNode = edge.getSource();
            if (controlPoints.size() >= 1) {
                siblingPoint = controlPoints.get(0);
            }
        }
        if (siblingPoint != null) {
            BpmnNode dockedNodeTarget;
            org.kie.workbench.common.stunner.core.graph.content.Bounds bounds = ((View)connectionPointNode.value().getContent()).getBounds();
            Bound nodeUl = bounds.getUpperLeft();
            if (connectionPointNode.isDocked() && (dockedNodeTarget = ProcessPostConverter.findDockedNodeTarget(connectionPointNode)) != null) {
                double width = bounds.getWidth();
                double height = bounds.getHeight();
                org.kie.workbench.common.stunner.core.graph.content.Bounds dockedNodeTargetBounds = ((View)dockedNodeTarget.value().getContent()).getBounds();
                Bound dockingNodeUL = dockedNodeTargetBounds.getUpperLeft();
                nodeUl = new Bound(Double.valueOf(nodeUl.getX() + dockingNodeUL.getX()), Double.valueOf(nodeUl.getY() + dockingNodeUL.getY()));
                Bound nodeLr = new Bound(Double.valueOf(nodeUl.getX() + width), Double.valueOf(nodeUl.getY() + height));
                bounds = org.kie.workbench.common.stunner.core.graph.content.Bounds.create((Bound)nodeUl, (Bound)nodeLr);
            }
            if (!(magnetConnection instanceof MagnetConnection) || !((MagnetConnection)magnetConnection).isAuto()) {
                if (ProcessPostConverter.equals(magnetPoint.getY(), 0.0, PRECISION) || ProcessPostConverter.equals(magnetPoint.getY(), bounds.getHeight(), PRECISION)) {
                    if (siblingPoint.getY() != magnetPoint.getY() + nodeUl.getY()) {
                        siblingPoint.setX(nodeUl.getX() + bounds.getWidth() / 2.0);
                    }
                } else if (siblingPoint.getX() != magnetPoint.getX() + nodeUl.getX()) {
                    siblingPoint.setY(nodeUl.getY() + bounds.getHeight() / 2.0);
                }
            }
        }
    }

    private static BpmnNode findDockedNodeTarget(BpmnNode dockedNode) {
        BpmnNode parent;
        for (parent = dockedNode.getParent(); parent != null && ProcessPostConverter.isLane(parent); parent = parent.getParent()) {
        }
        if (parent != null) {
            return parent.getEdges().stream().filter(BpmnEdge::isDocked).filter(edge -> edge.getTarget() == dockedNode).map(BpmnEdge::getSource).findFirst().orElse(null);
        }
        return null;
    }

    private void applyNodeResize(BpmnNode container, BpmnNode resizedChild) {
        org.kie.workbench.common.stunner.core.graph.content.Bounds originalBounds = resizedChild.getPropertyReader().getBounds();
        org.kie.workbench.common.stunner.core.graph.content.Bounds currentBounds = ((View)resizedChild.value().getContent()).getBounds();
        double deltaX = currentBounds.getWidth() - originalBounds.getWidth();
        double deltaY = currentBounds.getHeight() - originalBounds.getHeight();
        container.getChildren().stream().filter(child -> child != resizedChild).filter(child -> !child.isDocked()).forEach(child -> this.applyTranslationIfRequired(currentBounds.getX(), currentBounds.getY(), deltaX, deltaY, (BpmnNode)child));
        ProcessPostConverter.simpleEdges(container.getEdges()).forEach(edge -> {
            ProcessPostConverter.applyTranslationIfRequired(currentBounds.getX(), currentBounds.getY(), deltaX, deltaY, edge);
            ProcessPostConverter.adjustEdgeConnections(edge, false);
        });
    }

    private void translate(BpmnNode node, double deltaX, double deltaY) {
        org.kie.workbench.common.stunner.core.graph.content.Bounds childBounds = ((View)node.value().getContent()).getBounds();
        ProcessPostConverter.translate(childBounds.getUpperLeft(), deltaX, deltaY);
        ProcessPostConverter.translate(childBounds.getLowerRight(), deltaX, deltaY);
        if (!this.context.isCollapsed(node)) {
            node.getChildren().forEach(child -> this.translate((BpmnNode)child, deltaX, deltaY));
            ProcessPostConverter.translate(node.getEdges(), deltaX, deltaY);
        }
    }

    private static void translate(List<BpmnEdge> edges, double deltaX, double deltaY) {
        ProcessPostConverter.simpleEdges(edges).forEach(edge -> ProcessPostConverter.translate(edge, deltaX, deltaY));
    }

    private static void translate(BpmnEdge.Simple edge, double deltaX, double deltaY) {
        edge.getControlPoints().forEach(controlPoint -> ProcessPostConverter.translate(controlPoint, deltaX, deltaY));
    }

    private static void translate(Point2D point, double deltaX, double deltaY) {
        point.setX(point.getX() + deltaX);
        point.setY(point.getY() + deltaY);
    }

    private static void translate(Bound bound, double deltaX, double deltaY) {
        bound.setX(Double.valueOf(bound.getX() + deltaX));
        bound.setY(Double.valueOf(bound.getY() + deltaY));
    }

    private static void scale(Point2D point2D, double widthFactor, double heightFactor) {
        point2D.setX(point2D.getX() * widthFactor);
        point2D.setY(point2D.getY() * heightFactor);
    }

    private void applyTranslationIfRequired(double x, double y, double deltaX, double deltaY, BpmnNode node) {
        org.kie.workbench.common.stunner.core.graph.content.Bounds bounds = ((View)node.value().getContent()).getBounds();
        Bound ul = bounds.getUpperLeft();
        if (ul.getX() >= x && ul.getY() >= y) {
            this.translate(node, deltaX, deltaY);
        } else if (ul.getX() >= x && ul.getY() < y) {
            this.translate(node, deltaX, 0.0);
        } else if (ul.getX() < x && ul.getY() >= y) {
            this.translate(node, 0.0, deltaY);
        }
    }

    private static void applyTranslationIfRequired(double x, double y, double deltaX, double deltaY, BpmnEdge.Simple edge) {
        edge.getControlPoints().forEach(point -> ProcessPostConverter.applyTranslationIfRequired(x, y, deltaX, deltaY, point));
    }

    private static void applyTranslationIfRequired(double x, double y, double deltaX, double deltaY, Point2D point) {
        if (point.getX() >= x && point.getY() >= y) {
            ProcessPostConverter.translate(point, deltaX, deltaY);
        } else if (point.getX() >= x && point.getY() < y) {
            ProcessPostConverter.translate(point, deltaX, 0.0);
        } else if (point.getX() < x && point.getY() >= y) {
            ProcessPostConverter.translate(point, 0.0, deltaY);
        }
    }

    private static boolean isSubProcess(BpmnNode node) {
        return ((View)node.value().getContent()).getDefinition() instanceof EmbeddedSubprocess || ((View)node.value().getContent()).getDefinition() instanceof EventSubprocess || ((View)node.value().getContent()).getDefinition() instanceof AdHocSubprocess;
    }

    private static boolean isLane(BpmnNode node) {
        return ((View)node.value().getContent()).getDefinition() instanceof Lane;
    }

    private static List<BpmnEdge.Simple> inEdges(BpmnNode container, BpmnNode targetNode) {
        return ProcessPostConverter.simpleEdges(container.getEdges()).filter(edge -> edge.getTarget() == targetNode).collect(Collectors.toList());
    }

    private static List<BpmnEdge.Simple> outEdges(BpmnNode container, BpmnNode sourceNode) {
        return ProcessPostConverter.simpleEdges(container.getEdges()).filter(edge -> edge.getSource() == sourceNode).collect(Collectors.toList());
    }

    private static Stream<BpmnNode> dockedNodes(BpmnNode container, BpmnNode node) {
        return container.getEdges().stream().filter(BpmnEdge::isDocked).filter(edge -> edge.getSource() == node).map(BpmnEdge::getTarget);
    }

    private static Stream<BpmnEdge.Simple> simpleEdges(List<BpmnEdge> edges) {
        return edges.stream().filter(edge -> edge instanceof BpmnEdge.Simple).map(edge -> (BpmnEdge.Simple)edge);
    }

    private static <X, T> T min(List<X> values, Function<X, T> mapper) {
        return Collections.min(values.stream().map(mapper).collect(Collectors.toList()));
    }

    private static <X, T> T max(List<X> values, Function<X, T> mapper) {
        return Collections.max(values.stream().map(mapper).collect(Collectors.toList()));
    }

    private static boolean equals(double a, double b, double delta) {
        if (Double.compare(a, b) == 0) {
            return true;
        }
        return Math.abs(a - b) < delta;
    }

    private static class ViewPort {
        private double ulx;
        private double uly;
        private double lrx;
        private double lry;

        public ViewPort(double ulx, double uly, double lrx, double lry) {
            this.ulx = ulx;
            this.uly = uly;
            this.lrx = lrx;
            this.lry = lry;
        }

        public double getUpperLeftX() {
            return this.ulx;
        }

        public double getUpperLeftY() {
            return this.uly;
        }

        public double getLowerRightX() {
            return this.lrx;
        }

        public double getLowerRightY() {
            return this.lry;
        }

        public static ViewPort of(BpmnNode node, boolean includeEdges) {
            List ulBounds = node.getChildren().stream().filter(child -> !child.isDocked()).map(child -> ((View)child.value().getContent()).getBounds().getUpperLeft()).collect(Collectors.toList());
            List lrBounds = node.getChildren().stream().filter(child -> !child.isDocked()).map(child -> ((View)child.value().getContent()).getBounds().getLowerRight()).collect(Collectors.toList());
            List controlPoints = includeEdges ? ProcessPostConverter.simpleEdges(node.getEdges()).map(BpmnEdge.Simple::getControlPoints).flatMap(Collection::stream).collect(Collectors.toList()) : Collections.emptyList();
            double ulx = (Double)ProcessPostConverter.min(ulBounds, Bound::getX);
            double uly = (Double)ProcessPostConverter.min(ulBounds, Bound::getY);
            double lrx = (Double)ProcessPostConverter.max(lrBounds, Bound::getX);
            double lry = (Double)ProcessPostConverter.max(lrBounds, Bound::getY);
            if (!controlPoints.isEmpty()) {
                ulx = Math.min(ulx, (Double)ProcessPostConverter.min(controlPoints, Point2D::getX));
                uly = Math.min(uly, (Double)ProcessPostConverter.min(controlPoints, Point2D::getY));
                lrx = Math.max(lrx, (Double)ProcessPostConverter.max(controlPoints, Point2D::getX));
                lry = Math.max(lry, (Double)ProcessPostConverter.max(controlPoints, Point2D::getY));
            }
            return new ViewPort(ulx, uly, lrx, lry);
        }
    }

    private static class Padding {
        private double top;
        private double right;
        private double bottom;
        private double left;

        public Padding() {
        }

        public Padding(double top, double right, double bottom, double left) {
            this.top = top;
            this.right = right;
            this.bottom = bottom;
            this.left = left;
        }

        public double getTop() {
            return this.top;
        }

        public double getRight() {
            return this.right;
        }

        public double getBottom() {
            return this.bottom;
        }

        public double getLeft() {
            return this.left;
        }

        public static Padding of(BpmnNode node) {
            if (!node.hasChildren()) {
                return new Padding();
            }
            ViewPort viewPort = ViewPort.of(node, false);
            org.kie.workbench.common.stunner.core.graph.content.Bounds bounds = ((View)node.value().getContent()).getBounds();
            double topPadding = Math.abs(viewPort.getUpperLeftY() - bounds.getUpperLeft().getY());
            double rightPadding = Math.abs(viewPort.getLowerRightX() - bounds.getLowerRight().getX());
            double bottomPadding = Math.abs(viewPort.getLowerRightY() - bounds.getLowerRight().getY());
            double leftPadding = Math.abs(viewPort.getUpperLeftX() - bounds.getUpperLeft().getX());
            return new Padding(topPadding, rightPadding, bottomPadding, leftPadding);
        }
    }

    private static class LaneInfo {
        private BpmnNode lane;
        private Padding padding;
        private List<BpmnNode> children;

        public LaneInfo(BpmnNode lane, Padding padding, List<BpmnNode> children) {
            this.lane = lane;
            this.padding = padding;
            this.children = children;
        }

        public BpmnNode getLane() {
            return this.lane;
        }

        public Padding getPadding() {
            return this.padding;
        }

        public List<BpmnNode> getChildren() {
            return this.children;
        }
    }

    private static class PostConverterContext {
        private HashMap<BpmnNode, Boolean> collapsedNodes;
        private HashMap<BpmnNode, Boolean> resizedNodes = new HashMap();

        private PostConverterContext(HashMap<BpmnNode, Boolean> collapsedNodes) {
            this.collapsedNodes = collapsedNodes;
        }

        public boolean isCollapsed(BpmnNode node) {
            return this.collapsedNodes.getOrDefault(node, false);
        }

        public void setCollapsed(BpmnNode node, boolean collapsed) {
            this.collapsedNodes.put(node, collapsed);
        }

        public boolean hasCollapsedNodes() {
            return this.collapsedNodes.values().stream().filter(value -> value).findFirst().orElse(false);
        }

        public boolean isResized(BpmnNode node) {
            return this.resizedNodes.getOrDefault(node, false);
        }

        public void setResized(BpmnNode node, boolean resized) {
            this.resizedNodes.put(node, resized);
        }

        public List<BpmnNode> getResizedChildren(BpmnNode node) {
            return node.getChildren().stream().filter(this::isResized).collect(Collectors.toList());
        }

        public static PostConverterContext of(BpmnNode rootNode, boolean jbpmnModel) {
            HashMap<BpmnNode, Boolean> collapsedNodes = new HashMap<BpmnNode, Boolean>();
            PostConverterContext.calculateCollapsedNodes(rootNode, jbpmnModel, collapsedNodes);
            return new PostConverterContext(collapsedNodes);
        }

        private static void calculateCollapsedNodes(BpmnNode rootNode, boolean jbpmnModel, HashMap<BpmnNode, Boolean> collapsedNodes) {
            if (jbpmnModel) {
                return;
            }
            for (BpmnNode child : rootNode.getChildren()) {
                if (ProcessPostConverter.isLane(child)) {
                    PostConverterContext.calculateCollapsedNodes(child, jbpmnModel, collapsedNodes);
                    continue;
                }
                if (!ProcessPostConverter.isSubProcess(child)) continue;
                boolean collapsed = !child.getPropertyReader().isExpanded();
                collapsedNodes.put(child, collapsed);
                PostConverterContext.calculateCollapsedNodes(child, jbpmnModel, collapsedNodes);
            }
        }
    }
}

