/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.activities;

import org.eclipse.bpmn2.CallActivity;
import org.kie.workbench.common.stunner.bpmn.backend.converters.TypedFactoryManager;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.BpmnNode;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.CallActivityPropertyReader;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.PropertyReaderFactory;
import org.kie.workbench.common.stunner.bpmn.definition.BaseReusableSubprocess;
import org.kie.workbench.common.stunner.bpmn.definition.property.dataio.DataIOSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.general.BPMNGeneralSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.general.Documentation;
import org.kie.workbench.common.stunner.bpmn.definition.property.general.Name;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.BaseReusableSubprocessTaskExecutionSet;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.View;

public abstract class BaseCallActivityConverter<R extends BaseReusableSubprocess, E extends BaseReusableSubprocessTaskExecutionSet> {
    protected final TypedFactoryManager factoryManager;
    private final PropertyReaderFactory propertyReaderFactory;

    public BaseCallActivityConverter(TypedFactoryManager factoryManager, PropertyReaderFactory propertyReaderFactory) {
        this.factoryManager = factoryManager;
        this.propertyReaderFactory = propertyReaderFactory;
    }

    public BpmnNode convert(CallActivity activity) {
        CallActivityPropertyReader p = this.propertyReaderFactory.of(activity);
        Node<View<R>, Edge> node = this.createNode(activity, p);
        BaseReusableSubprocess definition = (BaseReusableSubprocess)((View)node.getContent()).getDefinition();
        definition.setGeneral(new BPMNGeneralSet(new Name(p.getName()), new Documentation(p.getDocumentation())));
        definition.setExecutionSet(this.createReusableSubprocessTaskExecutionSet(activity, p));
        definition.setDataIOSet(new DataIOSet(p.getAssignmentsInfo()));
        ((View)node.getContent()).setBounds(p.getBounds());
        definition.setSimulationSet(p.getSimulationSet());
        definition.setDimensionsSet(p.getRectangleDimensionsSet());
        definition.setFontSet(p.getFontSet());
        definition.setBackgroundSet(p.getBackgroundSet());
        return BpmnNode.of(node, p);
    }

    protected abstract Node<View<R>, Edge> createNode(CallActivity var1, CallActivityPropertyReader var2);

    protected abstract E createReusableSubprocessTaskExecutionSet(CallActivity var1, CallActivityPropertyReader var2);
}

