/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.lanes;

import org.eclipse.bpmn2.Lane;
import org.kie.workbench.common.stunner.bpmn.backend.converters.TypedFactoryManager;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.BpmnNode;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.LanePropertyReader;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.PropertyReaderFactory;
import org.kie.workbench.common.stunner.bpmn.definition.property.general.BPMNGeneralSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.general.Documentation;
import org.kie.workbench.common.stunner.bpmn.definition.property.general.Name;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.View;

public class LaneConverter {
    private final TypedFactoryManager typedFactoryManager;
    private PropertyReaderFactory propertyReaderFactory;

    public LaneConverter(TypedFactoryManager typedFactoryManager, PropertyReaderFactory propertyReaderFactory) {
        this.typedFactoryManager = typedFactoryManager;
        this.propertyReaderFactory = propertyReaderFactory;
    }

    public BpmnNode convert(Lane lane) {
        return this.convert(lane, this.propertyReaderFactory.of(lane));
    }

    public BpmnNode convert(Lane lane, Lane parent) {
        return this.convert(lane, this.propertyReaderFactory.of(lane, parent));
    }

    private BpmnNode convert(Lane lane, LanePropertyReader p) {
        Node node = this.typedFactoryManager.newNode(lane.getId(), org.kie.workbench.common.stunner.bpmn.definition.Lane.class);
        org.kie.workbench.common.stunner.bpmn.definition.Lane definition = (org.kie.workbench.common.stunner.bpmn.definition.Lane)((View)node.getContent()).getDefinition();
        definition.setGeneral(new BPMNGeneralSet(new Name(p.getName()), new Documentation(p.getDocumentation())));
        ((View)node.getContent()).setBounds(p.getBounds());
        definition.setDimensionsSet(p.getRectangleDimensionsSet());
        definition.setFontSet(p.getFontSet());
        definition.setBackgroundSet(p.getBackgroundSet());
        return BpmnNode.of(node, p);
    }
}

