/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.processes;

import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.bpmn2.Process;
import org.kie.workbench.common.stunner.bpmn.backend.converters.TypedFactoryManager;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.BaseConverterFactory;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.BpmnNode;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.DefinitionResolver;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.processes.ProcessConverterDelegate;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.ProcessPropertyReader;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.PropertyReaderFactory;
import org.kie.workbench.common.stunner.bpmn.definition.BPMNDiagram;
import org.kie.workbench.common.stunner.bpmn.definition.property.cm.CaseFileVariables;
import org.kie.workbench.common.stunner.bpmn.definition.property.cm.CaseIdPrefix;
import org.kie.workbench.common.stunner.bpmn.definition.property.cm.CaseManagementSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.cm.CaseRoles;
import org.kie.workbench.common.stunner.bpmn.definition.property.diagram.BaseDiagramSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.variables.BaseProcessData;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.View;

public abstract class BaseRootProcessConverter<D extends BPMNDiagram<S, P>, S extends BaseDiagramSet, P extends BaseProcessData> {
    final ProcessConverterDelegate delegate;

    public BaseRootProcessConverter(TypedFactoryManager typedFactoryManager, PropertyReaderFactory propertyReaderFactory, DefinitionResolver definitionResolver, BaseConverterFactory factory) {
        this.delegate = new ProcessConverterDelegate(typedFactoryManager, propertyReaderFactory, definitionResolver, factory);
    }

    public BpmnNode convertProcess() {
        Process process = this.delegate.definitionResolver.getProcess();
        String definitionsId = this.delegate.definitionResolver.getDefinitions().getId();
        BpmnNode processRoot = this.convertProcessNode(definitionsId, process);
        Map<String, BpmnNode> nodes = this.delegate.convertChildNodes(processRoot, process.getFlowElements(), process.getLaneSets());
        this.delegate.convertEdges(processRoot, Stream.concat(process.getFlowElements().stream(), process.getArtifacts().stream()).collect(Collectors.toList()), nodes);
        this.delegate.postConvert(processRoot);
        return processRoot;
    }

    private BpmnNode convertProcessNode(String id, Process process) {
        Node<View<D>, Edge> diagramNode = this.createNode(id);
        BPMNDiagram definition = (BPMNDiagram)((View)diagramNode.getContent()).getDefinition();
        ProcessPropertyReader e = this.delegate.propertyReaderFactory.of(process);
        definition.setDiagramSet(this.createDiagramSet(process, e));
        definition.setCaseManagementSet(new CaseManagementSet(new CaseIdPrefix(e.getCaseIdPrefix()), new CaseRoles(e.getCaseRoles()), new CaseFileVariables(e.getCaseFileVariables())));
        definition.setProcessData(this.createProcessData(e.getProcessVariables()));
        ((View)diagramNode.getContent()).setBounds(e.getBounds());
        definition.setFontSet(e.getFontSet());
        definition.setBackgroundSet(e.getBackgroundSet());
        return BpmnNode.of(diagramNode, e);
    }

    protected abstract Node<View<D>, Edge> createNode(String var1);

    protected abstract S createDiagramSet(Process var1, ProcessPropertyReader var2);

    protected abstract P createProcessData(String var1);
}

