/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.processes;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.FlowElement;
import org.eclipse.bpmn2.Lane;
import org.eclipse.bpmn2.LaneSet;
import org.kie.workbench.common.stunner.bpmn.backend.converters.Result;
import org.kie.workbench.common.stunner.bpmn.backend.converters.TypedFactoryManager;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.BaseConverterFactory;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.BpmnNode;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.DefinitionResolver;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.PropertyReaderFactory;

final class ProcessConverterDelegate {
    protected final TypedFactoryManager factoryManager;
    protected final PropertyReaderFactory propertyReaderFactory;
    protected final DefinitionResolver definitionResolver;
    private final BaseConverterFactory converterFactory;

    ProcessConverterDelegate(TypedFactoryManager typedFactoryManager, PropertyReaderFactory propertyReaderFactory, DefinitionResolver definitionResolver, BaseConverterFactory factory) {
        this.factoryManager = typedFactoryManager;
        this.definitionResolver = definitionResolver;
        this.propertyReaderFactory = propertyReaderFactory;
        this.converterFactory = factory;
    }

    Map<String, BpmnNode> convertChildNodes(BpmnNode firstNode, List<FlowElement> flowElements, List<LaneSet> laneSets) {
        Map<String, BpmnNode> freeFloatingNodes = this.convertFlowElements(flowElements);
        freeFloatingNodes.values().forEach(n -> n.setParent(firstNode));
        this.convertLaneSets(laneSets, freeFloatingNodes, firstNode);
        return freeFloatingNodes;
    }

    void convertEdges(BpmnNode processRoot, List<BaseElement> flowElements, Map<String, BpmnNode> nodes) {
        flowElements.stream().map(e -> this.converterFactory.edgeConverter().convertEdge((BaseElement)e, nodes)).filter(Result::isSuccess).map(Result::value).forEach(processRoot::addEdge);
    }

    private Map<String, BpmnNode> convertFlowElements(List<FlowElement> flowElements) {
        LinkedHashMap<String, BpmnNode> result = new LinkedHashMap<String, BpmnNode>();
        flowElements.stream().map(this.converterFactory.flowElementConverter()::convertNode).filter(Result::isSuccess).map(Result::value).forEach(n -> result.put(n.value().getUUID(), (BpmnNode)n));
        return result;
    }

    private void convertLaneSets(List<LaneSet> laneSets, Map<String, BpmnNode> freeFloatingNodes, BpmnNode firstDiagramNode) {
        laneSets.forEach(laneSet -> this.convertLaneSet((LaneSet)laneSet, (List<Lane>)new ArrayList<Lane>(), freeFloatingNodes, firstDiagramNode));
    }

    private void convertLane(Lane lane, List<Lane> parents, Map<String, BpmnNode> freeFloatingNodes, BpmnNode firstDiagramNode) {
        if (lane.getChildLaneSet() != null) {
            parents.add(lane);
            this.convertLaneSet(lane.getChildLaneSet(), parents, freeFloatingNodes, firstDiagramNode);
            parents.removeIf(parent -> Objects.equals(parent.getId(), lane.getId()));
        } else {
            BpmnNode laneNode = !parents.isEmpty() && lane != parents.get(0) ? this.converterFactory.laneConverter().convert(lane, parents.get(0)) : this.converterFactory.laneConverter().convert(lane);
            laneNode.setParent(firstDiagramNode);
            lane.getFlowNodeRefs().forEach(node -> ((BpmnNode)freeFloatingNodes.get(node.getId())).setParent(laneNode));
        }
    }

    private void convertLaneSet(LaneSet laneSet, List<Lane> parents, Map<String, BpmnNode> freeFloatingNodes, BpmnNode firstDiagramNode) {
        laneSet.getLanes().forEach(lane -> this.convertLane((Lane)lane, parents, freeFloatingNodes, firstDiagramNode));
    }

    void postConvert(BpmnNode processRoot) {
        this.converterFactory.newProcessPostConverter().postConvert(processRoot, this.definitionResolver);
    }
}

