/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties;

import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.bpmn2.BusinessRuleTask;
import org.eclipse.bpmn2.DataAssociation;
import org.eclipse.bpmn2.DataInput;
import org.eclipse.bpmn2.DataInputAssociation;
import org.eclipse.bpmn2.DataOutput;
import org.eclipse.bpmn2.DataOutputAssociation;
import org.eclipse.bpmn2.Task;
import org.eclipse.bpmn2.di.BPMNDiagram;
import org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties.CustomAttribute;
import org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties.CustomElement;
import org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties.CustomInput;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.DefinitionResolver;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.TaskPropertyReader;

public class BusinessRuleTaskPropertyReader
extends TaskPropertyReader {
    private final BusinessRuleTask task;

    public BusinessRuleTaskPropertyReader(BusinessRuleTask task, BPMNDiagram diagram, DefinitionResolver definitionResolver) {
        super((Task)task, diagram, definitionResolver);
        this.task = task;
    }

    public String getImplementation() {
        return this.task.getImplementation();
    }

    public String getRuleFlowGroup() {
        return CustomAttribute.ruleFlowGroup.of(this.element).get();
    }

    public String getNamespace() {
        return CustomInput.namespace.of((Task)this.task).get();
    }

    public String getDecisionName() {
        return CustomInput.decisionName.of((Task)this.task).get();
    }

    public String getDmnModelName() {
        return CustomInput.dmnModelName.of((Task)this.task).get();
    }

    public boolean isAsync() {
        return (Boolean)CustomElement.async.of(this.element).get();
    }

    public boolean isAdHocAutoStart() {
        return (Boolean)CustomElement.autoStart.of(this.element).get();
    }

    @Override
    protected List<DataInput> getDataInputs() {
        List<DataInput> filteredInputs = super.getDataInputs().stream().filter(dataInput -> !BusinessRuleTaskPropertyReader.isReservedDataInput(dataInput)).collect(Collectors.toList());
        return filteredInputs;
    }

    @Override
    protected List<DataInputAssociation> getDataInputAssociations() {
        List<DataInput> rawDataInputs = super.getDataInputs();
        List<DataInputAssociation> filteredInputs = super.getDataInputAssociations().stream().filter(dia -> !BusinessRuleTaskPropertyReader.isReservedDataInputAssociation(rawDataInputs, dia)).collect(Collectors.toList());
        return filteredInputs;
    }

    @Override
    protected List<DataOutput> getDataOutputs() {
        List<DataOutput> filterOutputs = super.getDataOutputs().stream().filter(dataOutput -> !BusinessRuleTaskPropertyReader.isReservedDataOutput(dataOutput)).collect(Collectors.toList());
        return filterOutputs;
    }

    @Override
    protected List<DataOutputAssociation> getDataOutputAssociations() {
        List<DataOutput> rawDataOutputs = super.getDataOutputs();
        List<DataOutputAssociation> filteredOutputs = super.getDataOutputAssociations().stream().filter(doa -> !BusinessRuleTaskPropertyReader.isReservedDataOutputAssociation(rawDataOutputs, doa)).collect(Collectors.toList());
        return filteredOutputs;
    }

    private static String getTargetRefID(DataAssociation dataAssociation) {
        return dataAssociation.getTargetRef() != null ? dataAssociation.getTargetRef().getId() : "";
    }

    private static boolean isReservedDataInputAssociation(List<DataInput> dataInputs, DataInputAssociation dataInputAssociation) {
        DataInput dataInput = dataInputs.stream().filter(input -> input.getId().equals(BusinessRuleTaskPropertyReader.getTargetRefID((DataAssociation)dataInputAssociation))).findFirst().orElse(null);
        return BusinessRuleTaskPropertyReader.isReservedDataInput(dataInput);
    }

    private static boolean isReservedDataOutputAssociation(List<DataOutput> dataOutputs, DataOutputAssociation dataOutputAssociation) {
        DataOutput dataOutput = dataOutputs.stream().filter(output -> output.getId().equals(BusinessRuleTaskPropertyReader.getTargetRefID((DataAssociation)dataOutputAssociation))).findFirst().orElse(null);
        return BusinessRuleTaskPropertyReader.isReservedDataOutput(dataOutput);
    }

    private static boolean isReservedDataInput(DataInput dataInput) {
        if (dataInput == null) {
            return false;
        }
        String dataName = dataInput.getName();
        return BusinessRuleTaskPropertyReader.isReservedDataName(dataName);
    }

    private static boolean isReservedDataOutput(DataOutput dataOutput) {
        if (dataOutput == null) {
            return false;
        }
        String dataName = dataOutput.getName();
        return BusinessRuleTaskPropertyReader.isReservedDataName(dataName);
    }

    private static boolean isReservedDataName(String dataName) {
        if (dataName.isEmpty()) {
            return false;
        }
        return dataName.equals("namespace") || dataName.equals("model") || dataName.equals("decision");
    }
}

