/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.workitem.service;

import java.util.Collection;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import javax.annotation.PreDestroy;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.workbench.common.stunner.bpmn.backend.workitem.deploy.WorkItemDefinitionDeployServices;
import org.kie.workbench.common.stunner.bpmn.backend.workitem.service.WorkItemDefinitionVFSLookupService;
import org.kie.workbench.common.stunner.bpmn.workitem.WorkItemDefinition;
import org.kie.workbench.common.stunner.bpmn.workitem.WorkItemDefinitionCacheRegistry;
import org.kie.workbench.common.stunner.bpmn.workitem.WorkItemDefinitionRegistry;
import org.kie.workbench.common.stunner.bpmn.workitem.service.WorkItemDefinitionLookupService;
import org.kie.workbench.common.stunner.core.diagram.Metadata;

@RequestScoped
@Service
public class WorkItemDefinitionBackendService
implements WorkItemDefinitionLookupService {
    private final WorkItemDefinitionCacheRegistry registry;
    private final WorkItemDefinitionVFSLookupService vfsService;
    private final WorkItemDefinitionDeployServices deployServices;
    private final BiPredicate<Metadata, Collection<WorkItemDefinition>> deployPredicate;
    private static final BiPredicate<Metadata, Collection<WorkItemDefinition>> DEFAULT_DEPLOY_PREDICATE = (metadata, workItemDefinitions) -> workItemDefinitions.isEmpty();

    protected WorkItemDefinitionBackendService() {
        this(null, null, null, null);
    }

    @Inject
    public WorkItemDefinitionBackendService(WorkItemDefinitionCacheRegistry registry, WorkItemDefinitionVFSLookupService vfsService, WorkItemDefinitionDeployServices deployServices) {
        this(registry, vfsService, deployServices, DEFAULT_DEPLOY_PREDICATE);
    }

    WorkItemDefinitionBackendService(WorkItemDefinitionCacheRegistry registry, WorkItemDefinitionVFSLookupService vfsService, WorkItemDefinitionDeployServices deployServices, BiPredicate<Metadata, Collection<WorkItemDefinition>> deployPredicate) {
        this.registry = registry;
        this.vfsService = vfsService;
        this.deployServices = deployServices;
        this.deployPredicate = deployPredicate;
    }

    @Produces
    @Default
    public WorkItemDefinitionRegistry getRegistry() {
        return this.registry;
    }

    public Collection<WorkItemDefinition> execute(Metadata metadata) {
        return this.load(metadata).items();
    }

    @PreDestroy
    public void destroy() {
        this.registry.destroy();
    }

    private WorkItemDefinitionCacheRegistry load(Metadata metadata) {
        List<WorkItemDefinition> items = this.search(metadata);
        if (this.deployPredicate.test(metadata, items)) {
            this.deployServices.deploy(metadata);
            items = this.search(metadata);
        }
        items.forEach(arg_0 -> ((WorkItemDefinitionCacheRegistry)this.registry).register(arg_0));
        return this.registry;
    }

    private List<WorkItemDefinition> search(Metadata metadata) {
        return this.vfsService.search(metadata).stream().collect(Collectors.toList());
    }
}

