/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.forms.validation.notification;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.kie.workbench.common.stunner.bpmn.definition.property.notification.NotificationValue;
import org.kie.workbench.common.stunner.bpmn.forms.validation.notification.ValidNotificationValue;

public class NotificationValueValidator
implements ConstraintValidator<ValidNotificationValue, NotificationValue> {
    public static final String NOT_NEGATIVE = "The value should not be negative.";
    public static final String INVALID_CHARACTERS = "Period property contains invalid characters. Only positive number can be used as the value.";
    private String errorMessage;

    public void initialize(ValidNotificationValue constraintAnnotation) {
    }

    public boolean isValid(NotificationValue value, ConstraintValidatorContext context) {
        this.isNegative(value.getExpiresAt());
        this.isTooBig(value.getExpiresAt());
        if (this.errorMessage != null) {
            context.disableDefaultConstraintViolation();
            context.buildConstraintViolationWithTemplate(this.errorMessage).addConstraintViolation();
            return false;
        }
        return true;
    }

    private void isTooBig(String value) {
        if (value != null) {
            String duration = value.substring(0, value.length() - 1);
            try {
                Integer.valueOf(duration);
            }
            catch (NumberFormatException nfe) {
                this.errorMessage = INVALID_CHARACTERS;
            }
        }
    }

    private void isNegative(String value) {
        if (value != null && value.startsWith("-")) {
            this.errorMessage = NOT_NEGATIVE;
        }
    }
}

