/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.docker;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.command.InspectContainerResponse;
import java.util.HashMap;
import org.jbpm.process.workitem.core.AbstractLogOrThrowWorkItemHandler;
import org.jbpm.process.workitem.core.util.RequiredParameterValidator;
import org.jbpm.process.workitem.core.util.Wid;
import org.jbpm.process.workitem.core.util.WidMavenDepends;
import org.jbpm.process.workitem.core.util.WidParameter;
import org.jbpm.process.workitem.core.util.WidResult;
import org.jbpm.process.workitem.core.util.service.WidAction;
import org.jbpm.process.workitem.core.util.service.WidService;
import org.jbpm.process.workitem.docker.DockerClientConnector;
import org.jbpm.process.workitem.docker.responses.SerializableInspectContainerResponse;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Wid(widfile="DockerInspectContainerDefinitions.wid", name="DockerInspectContainer", displayName="DockerInspectContainer", defaultHandler="mvel: new org.jbpm.process.workitem.docker.InspectContainerWorkitemHandler()", documentation="docker-workitem/index.html", category="docker-workitem", icon="DockerInspectContainer.png", parameters={@WidParameter(name="ContainerId", required=true)}, results={@WidResult(name="ContainerInfo", runtimeType="org.jbpm.process.workitem.docker.responses.SerializableInspectContainerResponse")}, mavenDepends={@WidMavenDepends(group="org.jbpm.contrib", artifact="docker-workitem", version="7.25.0.Final")}, serviceInfo=@WidService(category="Docker", description="Connect to and interact with a running Docker deamon", keywords="Docker,inspect,container", action=@WidAction(title="Inspect Docker container")))
public class InspectContainerWorkitemHandler
extends AbstractLogOrThrowWorkItemHandler {
    private static final Logger logger = LoggerFactory.getLogger(InspectContainerWorkitemHandler.class);
    private static final String RESULTS_DOCUMENT = "ContainerInfo";
    private DockerClient dockerClient;

    public void executeWorkItem(WorkItem workItem, WorkItemManager workItemManager) {
        HashMap<String, SerializableInspectContainerResponse> results = new HashMap<String, SerializableInspectContainerResponse>();
        try {
            RequiredParameterValidator.validate(((Object)((Object)this)).getClass(), (WorkItem)workItem);
            String containerId = (String)workItem.getParameter("ContainerId");
            if (this.dockerClient == null) {
                DockerClientConnector connector = new DockerClientConnector();
                this.dockerClient = connector.getDockerClient();
            }
            InspectContainerResponse containerResponse = this.dockerClient.inspectContainerCmd(containerId).exec();
            results.put(RESULTS_DOCUMENT, new SerializableInspectContainerResponse(containerResponse));
            workItemManager.completeWorkItem(workItem.getId(), results);
        }
        catch (Exception e) {
            logger.error("Unable to inspect container: " + e.getMessage());
            this.handleException(e);
        }
    }

    public void abortWorkItem(WorkItem wi, WorkItemManager wim) {
    }

    public void setDockerClient(DockerClient dockerClient) {
        this.dockerClient = dockerClient;
    }
}

