/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.command.runtime.pmml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import org.drools.core.command.IdentifiableResult;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.ruleunit.RuleUnitDescription;
import org.drools.core.ruleunit.RuleUnitDescriptionRegistry;
import org.drools.core.runtime.impl.ExecutionResultImpl;
import org.kie.api.KieBase;
import org.kie.api.command.ExecutableCommand;
import org.kie.api.pmml.OutputFieldFactory;
import org.kie.api.pmml.PMML4Result;
import org.kie.api.pmml.PMMLRequestData;
import org.kie.api.pmml.ParameterInfo;
import org.kie.api.runtime.Context;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.DataSource;
import org.kie.api.runtime.rule.RuleUnit;
import org.kie.api.runtime.rule.RuleUnitExecutor;
import org.kie.internal.command.RegistryContext;

@XmlRootElement(name="apply-pmml-model-command")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ApplyPmmlModelCommand
implements ExecutableCommand<PMML4Result>,
IdentifiableResult {
    private static final long serialVersionUID = 19630331L;
    @XmlAttribute(name="outIdentifier")
    private String outIdentifier;
    @XmlAttribute(name="packageName")
    private String packageName;
    @XmlAttribute(name="hasMining")
    private Boolean hasMining;
    @XmlElement(name="requestData")
    private PMMLRequestData requestData;
    @XmlElements(value={@XmlElement(name="complexInputObject", type=Object.class)})
    private List<Object> complexInputObjects;

    public ApplyPmmlModelCommand() {
    }

    public ApplyPmmlModelCommand(PMMLRequestData requestData) {
        this.initialize(requestData, null, null);
    }

    public ApplyPmmlModelCommand(PMMLRequestData requestData, List<Object> complexInputList) {
        this.initialize(requestData, complexInputList, null);
    }

    public ApplyPmmlModelCommand(PMMLRequestData requestData, List<Object> complexInputList, Boolean hasMining) {
        this.initialize(requestData, complexInputList, hasMining);
    }

    private void initialize(PMMLRequestData requestData, List<Object> complexInputList, Boolean hasMining) {
        this.requestData = requestData;
        this.complexInputObjects = complexInputList != null ? new ArrayList<Object>(complexInputList) : new ArrayList();
        this.hasMining = hasMining != null ? hasMining : Boolean.FALSE;
    }

    public PMMLRequestData getRequestData() {
        return this.requestData;
    }

    public void setRequestData(PMMLRequestData requestData) {
        this.requestData = requestData;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public Boolean getHasMining() {
        return this.hasMining;
    }

    public void setHasMining(Boolean hasMining) {
        this.hasMining = hasMining;
    }

    public boolean isMining() {
        return this.hasMining != null && this.hasMining != false;
    }

    public void addComplexInputObject(Object o) {
        if (o != null) {
            this.complexInputObjects.add(o);
        }
    }

    @Override
    public String getOutIdentifier() {
        return this.outIdentifier;
    }

    @Override
    public void setOutIdentifier(String outIdentifier) {
        this.outIdentifier = outIdentifier;
    }

    private Class<? extends RuleUnit> getStartingRuleUnit(String startingRule, InternalKnowledgeBase ikb, List<String> possiblePackages) {
        RuleUnitDescriptionRegistry unitRegistry = ikb.getRuleUnitDescriptionRegistry();
        Map<String, InternalKnowledgePackage> pkgs = ikb.getPackagesMap();
        RuleImpl ruleImpl = null;
        for (String pkgName : possiblePackages) {
            RuleUnitDescription descr;
            InternalKnowledgePackage pkg;
            if (!pkgs.containsKey(pkgName) || (ruleImpl = (pkg = pkgs.get(pkgName)).getRule(startingRule)) == null || (descr = (RuleUnitDescription)unitRegistry.getDescription(ruleImpl).orElse(null)) == null) continue;
            return descr.getRuleUnitClass();
        }
        return null;
    }

    private List<String> calculatePossiblePackageNames(String modelId, String ... knownPackageNames) {
        ArrayList<String> packageNames = new ArrayList<String>();
        String javaModelId = modelId.replaceAll("\\s", "");
        if (knownPackageNames != null && knownPackageNames.length > 0) {
            for (String knownPkgName : knownPackageNames) {
                packageNames.add(knownPkgName + "." + javaModelId);
            }
        }
        String basePkgName = "org.kie.pmml.pmml_4_2." + javaModelId;
        packageNames.add(basePkgName);
        return packageNames;
    }

    private <T> T castObject(Object o, Class<T> clazz) {
        T result = null;
        if (o != null && clazz != null) {
            result = clazz.cast(o);
        }
        return result;
    }

    private <T> DataSource<T> createDataSource(RuleUnitExecutor executor, String dsName, Object o) {
        Object object = this.castObject(o, o.getClass());
        return executor.newDataSource(dsName, new Object[]{object});
    }

    private <T> void insertDataObject(DataSource<T> ds, Object object) {
        if (object == null) {
            throw new IllegalArgumentException("Cannot insert null object into a DataSource");
        }
        Object obj = null;
        try {
            obj = object;
        }
        catch (ClassCastException ccx) {
            throw new IllegalArgumentException("Invalid attempt to insert a " + object.getClass().getName() + " object into a DataSource");
        }
        ds.insert(object);
    }

    private KieBase lookupKieBase(RegistryContext ctx) {
        KieSession session;
        if (ctx == null) {
            return null;
        }
        KieBase kbase = (KieBase)ctx.lookup(KieBase.class);
        if (kbase == null && (session = (KieSession)ctx.lookup(KieSession.class)) != null) {
            kbase = session.getKieBase();
        }
        return kbase;
    }

    public PMML4Result execute(Context context) {
        KieBase kbase;
        if (this.requestData == null) {
            throw new IllegalStateException("ApplyPmmlModelCommand requires request data (PMMLRequestData) to execute");
        }
        PMML4Result resultHolder = new PMML4Result(this.requestData.getCorrelationId());
        RegistryContext ctx = (RegistryContext)context;
        if (this.packageName == null) {
            this.packageName = (String)ctx.get("packageName");
        }
        if ((kbase = this.lookupKieBase(ctx)) == null) {
            resultHolder.setResultCode("ERROR-1");
        } else {
            boolean hasUnits = ((InternalKnowledgeBase)kbase).getRuleUnitDescriptionRegistry().hasUnits();
            if (!hasUnits) {
                resultHolder.setResultCode("ERROR-2");
            } else {
                RuleUnitExecutor executor = RuleUnitExecutor.create().bind(kbase);
                DataSource data = executor.newDataSource("request", (Object[])new PMMLRequestData[]{this.requestData});
                DataSource resultData = executor.newDataSource("results", (Object[])new PMML4Result[]{resultHolder});
                if (this.complexInputObjects != null && !this.complexInputObjects.isEmpty()) {
                    HashMap datasources = new HashMap();
                    for (Object obj : this.complexInputObjects) {
                        String dsName = "externalBean" + obj.getClass().getSimpleName();
                        if (datasources.containsKey(dsName)) {
                            this.insertDataObject((DataSource)datasources.get(dsName), obj);
                            continue;
                        }
                        datasources.put(dsName, this.createDataSource(executor, dsName, obj));
                    }
                }
                executor.newDataSource("pmmlData", new Object[0]);
                if (this.isMining()) {
                    executor.newDataSource("childModelSegments", new Object[0]);
                    executor.newDataSource("miningModelPojo", new Object[0]);
                }
                Collection parms = this.requestData.getRequestParams();
                for (ParameterInfo pi : parms) {
                    Class clazz = pi.getType();
                    if (clazz.isAssignableFrom(pi.getValue().getClass())) continue;
                    try {
                        Object o = clazz.getDeclaredConstructor(pi.getValue().getClass()).newInstance(pi.getValue());
                        pi.setValue(o);
                    }
                    catch (Throwable t) {
                        resultHolder.setResultCode("ERROR-3");
                        return resultHolder;
                    }
                }
                data.insert((Object)this.requestData);
                resultData.insert((Object)resultHolder);
                String startingRule = this.isMining() ? "Start Mining - " + this.requestData.getModelName() : "RuleUnitIndicator";
                List<String> possibleStartingPackages = this.calculatePossiblePackageNames(this.requestData.getModelName(), this.packageName);
                Class<? extends RuleUnit> ruleUnitClass = this.getStartingRuleUnit(startingRule, (InternalKnowledgeBase)kbase, possibleStartingPackages);
                executor.run(ruleUnitClass);
            }
        }
        List outputs = OutputFieldFactory.createOutputsFromResults((PMML4Result)resultHolder);
        Optional<Object> execRes = Optional.ofNullable(ctx.lookup(ExecutionResultImpl.class));
        ctx.register(PMML4Result.class, (Object)resultHolder);
        execRes.ifPresent(result -> result.setResult("results", resultHolder));
        outputs.forEach(out -> {
            execRes.ifPresent(result -> result.setResult(out.getName(), out));
            resultHolder.updateResultVariable(out.getName(), out);
        });
        return resultHolder;
    }
}

