/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.config.phase.custom;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamConverter;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.optaplanner.core.config.heuristic.policy.HeuristicConfigPolicy;
import org.optaplanner.core.config.phase.PhaseConfig;
import org.optaplanner.core.config.solver.EnvironmentMode;
import org.optaplanner.core.config.util.ConfigUtils;
import org.optaplanner.core.config.util.KeyAsElementMapConverter;
import org.optaplanner.core.impl.phase.custom.CustomPhase;
import org.optaplanner.core.impl.phase.custom.CustomPhaseCommand;
import org.optaplanner.core.impl.phase.custom.DefaultCustomPhase;
import org.optaplanner.core.impl.solver.recaller.BestSolutionRecaller;
import org.optaplanner.core.impl.solver.termination.Termination;

@XStreamAlias(value="customPhase")
public class CustomPhaseConfig
extends PhaseConfig<CustomPhaseConfig> {
    @XStreamImplicit(itemFieldName="customPhaseCommandClass")
    protected List<Class<? extends CustomPhaseCommand>> customPhaseCommandClassList = null;
    @XStreamConverter(value=KeyAsElementMapConverter.class)
    protected Map<String, String> customProperties = null;
    protected Boolean forceUpdateBestSolution = null;

    public List<Class<? extends CustomPhaseCommand>> getCustomPhaseCommandClassList() {
        return this.customPhaseCommandClassList;
    }

    public void setCustomPhaseCommandClassList(List<Class<? extends CustomPhaseCommand>> customPhaseCommandClassList) {
        this.customPhaseCommandClassList = customPhaseCommandClassList;
    }

    public Map<String, String> getCustomProperties() {
        return this.customProperties;
    }

    public void setCustomProperties(Map<String, String> customProperties) {
        this.customProperties = customProperties;
    }

    public Boolean getForceUpdateBestSolution() {
        return this.forceUpdateBestSolution;
    }

    public void setForceUpdateBestSolution(Boolean forceUpdateBestSolution) {
        this.forceUpdateBestSolution = forceUpdateBestSolution;
    }

    @Override
    public CustomPhase buildPhase(int phaseIndex, HeuristicConfigPolicy solverConfigPolicy, BestSolutionRecaller bestSolutionRecaller, Termination solverTermination) {
        HeuristicConfigPolicy phaseConfigPolicy = solverConfigPolicy.createPhaseConfigPolicy();
        DefaultCustomPhase phase = new DefaultCustomPhase(phaseIndex, solverConfigPolicy.getLogIndentation(), bestSolutionRecaller, this.buildPhaseTermination(phaseConfigPolicy, solverTermination));
        if (ConfigUtils.isEmptyCollection(this.customPhaseCommandClassList)) {
            throw new IllegalArgumentException("Configure at least 1 <customPhaseCommandClass> in the <customPhase> configuration.");
        }
        ArrayList customPhaseCommandList = new ArrayList(this.customPhaseCommandClassList.size());
        for (Class<? extends CustomPhaseCommand> customPhaseCommandClass : this.customPhaseCommandClassList) {
            CustomPhaseCommand customPhaseCommand = ConfigUtils.newInstance(this, "customPhaseCommandClass", customPhaseCommandClass);
            ConfigUtils.applyCustomProperties(customPhaseCommand, "customPhaseCommandClass", this.customProperties, "customProperties");
            customPhaseCommandList.add(customPhaseCommand);
        }
        phase.setCustomPhaseCommandList(customPhaseCommandList);
        phase.setForceUpdateBestSolution(this.forceUpdateBestSolution == null ? false : this.forceUpdateBestSolution);
        EnvironmentMode environmentMode = phaseConfigPolicy.getEnvironmentMode();
        if (environmentMode.isNonIntrusiveFullAsserted()) {
            phase.setAssertStepScoreFromScratch(true);
        }
        return phase;
    }

    @Override
    public void inherit(CustomPhaseConfig inheritedConfig) {
        super.inherit(inheritedConfig);
        this.customPhaseCommandClassList = ConfigUtils.inheritMergeableListProperty(this.customPhaseCommandClassList, inheritedConfig.getCustomPhaseCommandClassList());
        this.customProperties = ConfigUtils.inheritMergeableMapProperty(this.customProperties, inheritedConfig.getCustomProperties());
        this.forceUpdateBestSolution = ConfigUtils.inheritOverwritableProperty(this.forceUpdateBestSolution, inheritedConfig.getForceUpdateBestSolution());
    }
}

