/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.solver.scope;

import java.util.List;
import java.util.Random;
import java.util.concurrent.Semaphore;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.score.definition.ScoreDefinition;
import org.optaplanner.core.impl.score.director.InnerScoreDirector;
import org.optaplanner.core.impl.solver.ChildThreadType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSolverScope<Solution_> {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    protected int startingSolverCount;
    protected Random workingRandom;
    protected InnerScoreDirector<Solution_> scoreDirector;
    protected Semaphore runnableThreadSemaphore = null;
    protected volatile Long startingSystemTimeMillis;
    protected volatile Long endingSystemTimeMillis;
    protected long childThreadsScoreCalculationCount = 0L;
    protected Score startingInitializedScore;
    protected volatile Solution_ bestSolution;
    protected volatile Score bestScore;
    protected Long bestSolutionTimeMillis;

    public int getStartingSolverCount() {
        return this.startingSolverCount;
    }

    public void setStartingSolverCount(int startingSolverCount) {
        this.startingSolverCount = startingSolverCount;
    }

    public Random getWorkingRandom() {
        return this.workingRandom;
    }

    public void setWorkingRandom(Random workingRandom) {
        this.workingRandom = workingRandom;
    }

    public InnerScoreDirector<Solution_> getScoreDirector() {
        return this.scoreDirector;
    }

    public void setScoreDirector(InnerScoreDirector<Solution_> scoreDirector) {
        this.scoreDirector = scoreDirector;
    }

    public void setRunnableThreadSemaphore(Semaphore runnableThreadSemaphore) {
        this.runnableThreadSemaphore = runnableThreadSemaphore;
    }

    public Long getStartingSystemTimeMillis() {
        return this.startingSystemTimeMillis;
    }

    public Long getEndingSystemTimeMillis() {
        return this.endingSystemTimeMillis;
    }

    public SolutionDescriptor<Solution_> getSolutionDescriptor() {
        return this.scoreDirector.getSolutionDescriptor();
    }

    public ScoreDefinition getScoreDefinition() {
        return this.scoreDirector.getScoreDefinition();
    }

    public Solution_ getWorkingSolution() {
        return this.scoreDirector.getWorkingSolution();
    }

    public int getWorkingEntityCount() {
        return this.scoreDirector.getWorkingEntityCount();
    }

    public List<Object> getWorkingEntityList() {
        return this.scoreDirector.getWorkingEntityList();
    }

    public int getWorkingValueCount() {
        return this.scoreDirector.getWorkingValueCount();
    }

    public Score calculateScore() {
        return this.scoreDirector.calculateScore();
    }

    public void assertScoreFromScratch(Solution_ solution) {
        this.scoreDirector.getScoreDirectorFactory().assertScoreFromScratch(solution);
    }

    public Score getStartingInitializedScore() {
        return this.startingInitializedScore;
    }

    public void setStartingInitializedScore(Score startingInitializedScore) {
        this.startingInitializedScore = startingInitializedScore;
    }

    public void addChildThreadsScoreCalculationCount(long addition) {
        this.childThreadsScoreCalculationCount += addition;
    }

    public long getScoreCalculationCount() {
        return this.scoreDirector.getCalculationCount() + this.childThreadsScoreCalculationCount;
    }

    public Solution_ getBestSolution() {
        return this.bestSolution;
    }

    public void setBestSolution(Solution_ bestSolution) {
        this.bestSolution = bestSolution;
    }

    public Score getBestScore() {
        return this.bestScore;
    }

    public void setBestScore(Score bestScore) {
        this.bestScore = bestScore;
    }

    public Long getBestSolutionTimeMillis() {
        return this.bestSolutionTimeMillis;
    }

    public void setBestSolutionTimeMillis(Long bestSolutionTimeMillis) {
        this.bestSolutionTimeMillis = bestSolutionTimeMillis;
    }

    public void startingNow() {
        this.startingSystemTimeMillis = System.currentTimeMillis();
        this.endingSystemTimeMillis = null;
    }

    public Long getBestSolutionTimeMillisSpent() {
        return this.bestSolutionTimeMillis - this.startingSystemTimeMillis;
    }

    public void endingNow() {
        this.endingSystemTimeMillis = System.currentTimeMillis();
    }

    public boolean isBestSolutionInitialized() {
        return this.bestScore.isSolutionInitialized();
    }

    public long calculateTimeMillisSpentUpToNow() {
        long now = System.currentTimeMillis();
        return now - this.startingSystemTimeMillis;
    }

    public long getTimeMillisSpent() {
        return this.endingSystemTimeMillis - this.startingSystemTimeMillis;
    }

    public long getScoreCalculationSpeed() {
        long timeMillisSpent = this.getTimeMillisSpent();
        return this.getScoreCalculationCount() * 1000L / (timeMillisSpent == 0L ? 1L : timeMillisSpent);
    }

    public void setWorkingSolutionFromBestSolution() {
        this.scoreDirector.setWorkingSolution(this.scoreDirector.cloneSolution(this.bestSolution));
    }

    public DefaultSolverScope<Solution_> createChildThreadSolverScope(ChildThreadType childThreadType) {
        DefaultSolverScope<Solution_> childThreadSolverScope = new DefaultSolverScope<Solution_>();
        childThreadSolverScope.startingSolverCount = this.startingSolverCount;
        childThreadSolverScope.workingRandom = new Random(this.workingRandom.nextLong());
        childThreadSolverScope.scoreDirector = this.scoreDirector.createChildThreadScoreDirector(childThreadType);
        childThreadSolverScope.startingSystemTimeMillis = this.startingSystemTimeMillis;
        childThreadSolverScope.endingSystemTimeMillis = null;
        childThreadSolverScope.startingInitializedScore = null;
        childThreadSolverScope.bestSolution = null;
        childThreadSolverScope.bestScore = null;
        childThreadSolverScope.bestSolutionTimeMillis = null;
        return childThreadSolverScope;
    }

    public void initializeYielding() {
        if (this.runnableThreadSemaphore != null) {
            try {
                this.runnableThreadSemaphore.acquire();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public void checkYielding() {
        if (this.runnableThreadSemaphore != null) {
            this.runnableThreadSemaphore.release();
            try {
                this.runnableThreadSemaphore.acquire();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public void destroyYielding() {
        if (this.runnableThreadSemaphore != null) {
            this.runnableThreadSemaphore.release();
        }
    }
}

