/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datasource.management.backend.service;

import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.dashbuilder.dataset.DataColumn;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.DataSetLookup;
import org.dashbuilder.dataset.DataSetManager;
import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.dataset.def.DataSetDefRegistry;
import org.dashbuilder.displayer.DisplayerSettings;
import org.dashbuilder.displayer.DisplayerSettingsFactory;
import org.dashbuilder.displayer.impl.TableDisplayerSettingsBuilderImpl;
import org.guvnor.common.services.shared.exceptions.GenericPortableException;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.workbench.common.screens.datasource.management.backend.core.DataSourceRuntimeManager;
import org.kie.workbench.common.screens.datasource.management.metadata.DatabaseMetadata;
import org.kie.workbench.common.screens.datasource.management.model.DataSourceDeploymentInfo;
import org.kie.workbench.common.screens.datasource.management.service.DataManagementService;
import org.kie.workbench.common.screens.datasource.management.service.DatabaseMetadataService;
import org.kie.workbench.common.screens.datasource.management.util.DataSetDefBuilder;

@Service
@ApplicationScoped
public class DataManagementServiceImpl
implements DataManagementService {
    private DataSourceRuntimeManager dataSourceRuntimeManager;
    private DatabaseMetadataService databaseMetadataService;
    private DataSetDefRegistry dataSetDefRegistry;
    private DataSetManager dataSetManager;
    private static final int COLUMN_WIDTH = 100;
    private static final String SEPARATOR = "#";

    @Inject
    public DataManagementServiceImpl(DataSourceRuntimeManager dataSourceRuntimeManager, DatabaseMetadataService databaseMetadataService, DataSetDefRegistry dataSetDefRegistry, DataSetManager dataSetManager) {
        this.dataSourceRuntimeManager = dataSourceRuntimeManager;
        this.databaseMetadataService = databaseMetadataService;
        this.dataSetDefRegistry = dataSetDefRegistry;
        this.dataSetManager = dataSetManager;
    }

    public DisplayerSettings getDisplayerSettings(String dataSourceUuid, String schema, String table) {
        PortablePreconditions.checkNotNull((String)"dataSourceUuid", (Object)dataSourceUuid);
        PortablePreconditions.checkNotNull((String)"table", (Object)table);
        try {
            DataSourceDeploymentInfo deploymentInfo = this.dataSourceRuntimeManager.getDataSourceDeploymentInfo(dataSourceUuid);
            DataSetDef dataSetDef = DataSetDefBuilder.newBuilder().dataSetUuid(this.buildDataSetUuid(dataSourceUuid, schema, table)).dataSetName(this.buildDataSetName(schema, table)).dataSourceUuid(deploymentInfo.getUuid()).schema(schema).table(this.buildDataSetTableName(dataSourceUuid, table)).isPublic(false).build();
            this.dataSetDefRegistry.registerDataSetDef(dataSetDef);
            DataSetLookup lookup = new DataSetLookup();
            lookup.setDataSetUUID(dataSetDef.getUUID());
            DataSet dataSet = this.dataSetManager.lookupDataSet(lookup);
            TableDisplayerSettingsBuilderImpl settingsBuilder = ((TableDisplayerSettingsBuilderImpl)((TableDisplayerSettingsBuilderImpl)((TableDisplayerSettingsBuilderImpl)DisplayerSettingsFactory.newTableSettings().dataset(dataSetDef.getUUID())).title(table)).titleVisible(true)).tablePageSize(20).tableOrderEnabled(true);
            List columns = dataSet.getColumns();
            for (DataColumn column : columns) {
                settingsBuilder.column(column.getId());
            }
            int tableWith = columns.size() * 100;
            settingsBuilder.tableWidth(tableWith);
            settingsBuilder.renderer("default");
            return settingsBuilder.buildSettings();
        }
        catch (Exception e) {
            throw new GenericPortableException(e.getMessage());
        }
    }

    private String buildDataSetUuid(String dataSourceUuid, String schema, String table) {
        return dataSourceUuid + SEPARATOR + schema + SEPARATOR + table;
    }

    private String buildDataSetName(String schema, String table) {
        return schema + "." + table;
    }

    private String buildDataSetTableName(String dataSourceUuid, String table) throws Exception {
        String result = table;
        DatabaseMetadata metadata = this.databaseMetadataService.getMetadata(dataSourceUuid, false, false);
        if (metadata.getDatabaseType() != null) {
            switch (metadata.getDatabaseType()) {
                case POSTGRESQL: {
                    result = "\"" + table + "\"";
                    break;
                }
                case H2: 
                case MYSQL: 
                case MARIADB: 
                case ORACLE: 
                case SQLSERVER: 
                case DB2: {
                    result = table;
                }
            }
        }
        return result;
    }
}

