/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.project.backend.factory;

import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Typed;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.bpmn.backend.workitem.service.WorkItemDefinitionBackendService;
import org.kie.workbench.common.stunner.bpmn.definition.BPMNDiagram;
import org.kie.workbench.common.stunner.bpmn.definition.property.diagram.AdHoc;
import org.kie.workbench.common.stunner.bpmn.factory.BPMNGraphFactoryImpl;
import org.kie.workbench.common.stunner.bpmn.workitem.ServiceTask;
import org.kie.workbench.common.stunner.bpmn.workitem.ServiceTaskFactory;
import org.kie.workbench.common.stunner.bpmn.workitem.service.WorkItemDefinitionService;
import org.kie.workbench.common.stunner.core.api.DefinitionManager;
import org.kie.workbench.common.stunner.core.api.FactoryManager;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.definition.adapter.DefinitionAdapter;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.BindableAdapterUtils;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandManager;
import org.kie.workbench.common.stunner.core.graph.command.impl.GraphCommandFactory;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.kie.workbench.common.stunner.core.graph.content.definition.DefinitionSet;
import org.kie.workbench.common.stunner.core.graph.content.view.Point2D;
import org.kie.workbench.common.stunner.core.graph.processing.index.GraphIndexBuilder;
import org.kie.workbench.common.stunner.core.rule.RuleManager;
import org.kie.workbench.common.stunner.core.util.UUID;

@Dependent
@Typed(value={CaseGraphFactoryImpl.class})
public class CaseGraphFactoryImpl
extends BPMNGraphFactoryImpl {
    private ServiceTaskFactory serviceTaskFactory;
    private WorkItemDefinitionService workItemDefinitionService;

    public CaseGraphFactoryImpl() {
    }

    @Inject
    public CaseGraphFactoryImpl(DefinitionManager definitionManager, FactoryManager factoryManager, RuleManager ruleManager, GraphCommandManager graphCommandManager, GraphCommandFactory graphCommandFactory, GraphIndexBuilder<?> indexBuilder, ServiceTaskFactory serviceTaskFactory, WorkItemDefinitionBackendService workItemDefinitionService) {
        super(definitionManager, factoryManager, ruleManager, graphCommandManager, graphCommandFactory, indexBuilder);
        this.serviceTaskFactory = serviceTaskFactory;
        this.workItemDefinitionService = workItemDefinitionService;
    }

    public Graph<DefinitionSet, Node> build(String uuid, String definition, Metadata metadata) {
        this.workItemDefinitionService.execute((Object)metadata);
        return super.build(uuid, definition);
    }

    protected List<Command> buildInitialisationCommands() {
        ArrayList<Command> commands = new ArrayList<Command>();
        Node diagramNode = (Node)this.factoryManager.newElement(UUID.uuid(), BindableAdapterUtils.getDefinitionId((Class)this.getDiagramType()));
        ServiceTask milestone = this.serviceTaskFactory.buildItem("Milestone");
        DefinitionAdapter adapter = this.definitionManager.adapters().registry().getDefinitionAdapter(milestone.getClass());
        Node firstElement = (Node)this.factoryManager.newElement(UUID.uuid(), adapter.getId((Object)milestone).value());
        AdHoc adHoc = ((BPMNDiagram)((Definition)diagramNode.getContent()).getDefinition()).getDiagramSet().getAdHoc();
        String adHocPropertyId = this.definitionManager.adapters().forProperty().getId((Object)adHoc);
        commands.add((Command)this.graphCommandFactory.addNode(diagramNode));
        commands.add((Command)this.graphCommandFactory.addChildNode(diagramNode, firstElement, new Point2D(100.0, 100.0)));
        commands.add((Command)this.graphCommandFactory.updatePropertyValue((Element)diagramNode, adHocPropertyId, (Object)true));
        return commands;
    }
}

