/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.bavet.uni;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.api.score.stream.ConstraintFactory;
import org.optaplanner.core.api.score.stream.bi.BiConstraintStream;
import org.optaplanner.core.api.score.stream.bi.BiJoiner;
import org.optaplanner.core.api.score.stream.tri.TriConstraintStream;
import org.optaplanner.core.api.score.stream.uni.UniConstraintCollector;
import org.optaplanner.core.api.score.stream.uni.UniConstraintStream;
import org.optaplanner.core.impl.score.stream.bavet.BavetConstraint;
import org.optaplanner.core.impl.score.stream.bavet.BavetConstraintFactory;
import org.optaplanner.core.impl.score.stream.bavet.bi.BavetGroupBiConstraintStream;
import org.optaplanner.core.impl.score.stream.bavet.bi.BavetJoinBiConstraintStream;
import org.optaplanner.core.impl.score.stream.bavet.common.BavetAbstractConstraintStream;
import org.optaplanner.core.impl.score.stream.bavet.common.BavetNodeBuildPolicy;
import org.optaplanner.core.impl.score.stream.bavet.common.index.BavetIndexFactory;
import org.optaplanner.core.impl.score.stream.bavet.uni.BavetAbstractUniNode;
import org.optaplanner.core.impl.score.stream.bavet.uni.BavetFilterUniConstraintStream;
import org.optaplanner.core.impl.score.stream.bavet.uni.BavetGroupBridgeUniConstraintStream;
import org.optaplanner.core.impl.score.stream.bavet.uni.BavetJoinBridgeUniConstraintStream;
import org.optaplanner.core.impl.score.stream.bavet.uni.BavetScoringUniConstraintStream;
import org.optaplanner.core.impl.score.stream.bi.AbstractBiJoiner;
import org.optaplanner.core.impl.score.stream.uni.InnerUniConstraintStream;

public abstract class BavetAbstractUniConstraintStream<Solution_, A>
extends BavetAbstractConstraintStream<Solution_>
implements InnerUniConstraintStream<A> {
    protected final List<BavetAbstractUniConstraintStream<Solution_, A>> childStreamList = new ArrayList<BavetAbstractUniConstraintStream<Solution_, A>>(2);

    public BavetAbstractUniConstraintStream(BavetConstraintFactory<Solution_> constraintFactory) {
        super(constraintFactory);
    }

    public void addChildStream(BavetAbstractUniConstraintStream<Solution_, A> childStream) {
        this.childStreamList.add(childStream);
    }

    public BavetAbstractUniConstraintStream<Solution_, A> filter(Predicate<A> predicate) {
        BavetFilterUniConstraintStream stream = new BavetFilterUniConstraintStream(this.constraintFactory, this, predicate);
        this.childStreamList.add(stream);
        return stream;
    }

    @Override
    public <B> BiConstraintStream<A, B> join(UniConstraintStream<B> otherStream, BiJoiner<A, B> joiner) {
        if (!(otherStream instanceof BavetAbstractUniConstraintStream)) {
            throw new IllegalStateException("The streams (" + this + ", " + otherStream + ") are not build from the same " + ConstraintFactory.class.getSimpleName() + ".");
        }
        BavetAbstractUniConstraintStream other = (BavetAbstractUniConstraintStream)otherStream;
        if (this.constraintFactory != other.getConstraintFactory()) {
            throw new IllegalStateException("The streams (" + this + ", " + other + ") are build from different constraintFactories (" + this.constraintFactory + ", " + other.getConstraintFactory() + ").");
        }
        if (!(joiner instanceof AbstractBiJoiner)) {
            throw new IllegalArgumentException("The joiner class (" + joiner.getClass() + ") is not supported.");
        }
        AbstractBiJoiner castedJoiner = (AbstractBiJoiner)joiner;
        BavetIndexFactory indexFactory = new BavetIndexFactory(castedJoiner);
        BavetJoinBridgeUniConstraintStream leftBridge = new BavetJoinBridgeUniConstraintStream(this.constraintFactory, this, true, castedJoiner.getLeftCombinedMapping(), indexFactory);
        this.childStreamList.add(leftBridge);
        BavetJoinBridgeUniConstraintStream rightBridge = new BavetJoinBridgeUniConstraintStream(this.constraintFactory, other, false, castedJoiner.getRightCombinedMapping(), indexFactory);
        other.childStreamList.add(rightBridge);
        BavetJoinBiConstraintStream joinStream = new BavetJoinBiConstraintStream(this.constraintFactory, leftBridge, rightBridge);
        leftBridge.setJoinStream(joinStream);
        rightBridge.setJoinStream(joinStream);
        return joinStream;
    }

    @Override
    public <GroupKey_, ResultContainer_, Result_> UniConstraintStream<Result_> groupBy(UniConstraintCollector<A, ResultContainer_, Result_> collector) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <GroupKey_> UniConstraintStream<GroupKey_> groupBy(Function<A, GroupKey_> groupKeyMapping) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <GroupKey_, ResultContainer_, Result_> BiConstraintStream<GroupKey_, Result_> groupBy(Function<A, GroupKey_> groupKeyMapping, UniConstraintCollector<A, ResultContainer_, Result_> collector) {
        BavetGroupBridgeUniConstraintStream bridge = new BavetGroupBridgeUniConstraintStream(this.constraintFactory, this, groupKeyMapping, collector);
        this.childStreamList.add(bridge);
        BavetGroupBiConstraintStream groupStream = new BavetGroupBiConstraintStream(this.constraintFactory, bridge, collector.finisher());
        bridge.setGroupStream(groupStream);
        return groupStream;
    }

    @Override
    public <GroupKeyA_, GroupKeyB_> BiConstraintStream<GroupKeyA_, GroupKeyB_> groupBy(Function<A, GroupKeyA_> groupKeyAMapping, Function<A, GroupKeyB_> groupKeyBMapping) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <GroupKeyA_, GroupKeyB_, ResultContainer_, Result_> TriConstraintStream<GroupKeyA_, GroupKeyB_, Result_> groupBy(Function<A, GroupKeyA_> groupKeyAMapping, Function<A, GroupKeyB_> groupKeyBMapping, UniConstraintCollector<A, ResultContainer_, Result_> collector) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final Constraint impactScore(String constraintPackage, String constraintName, Score<?> constraintWeight, boolean positive) {
        BavetConstraint constraint = this.buildConstraint(constraintPackage, constraintName, constraintWeight, positive);
        BavetScoringUniConstraintStream stream = new BavetScoringUniConstraintStream(this.constraintFactory, this, constraint);
        this.childStreamList.add(stream);
        return constraint;
    }

    @Override
    public final Constraint impactScore(String constraintPackage, String constraintName, Score<?> constraintWeight, ToIntFunction<A> matchWeigher, boolean positive) {
        BavetConstraint constraint = this.buildConstraint(constraintPackage, constraintName, constraintWeight, positive);
        BavetScoringUniConstraintStream stream = new BavetScoringUniConstraintStream(this.constraintFactory, this, constraint, matchWeigher);
        this.childStreamList.add(stream);
        return constraint;
    }

    @Override
    public final Constraint impactScoreLong(String constraintPackage, String constraintName, Score<?> constraintWeight, ToLongFunction<A> matchWeigher, boolean positive) {
        BavetConstraint constraint = this.buildConstraint(constraintPackage, constraintName, constraintWeight, positive);
        BavetScoringUniConstraintStream stream = new BavetScoringUniConstraintStream(this.constraintFactory, this, constraint, matchWeigher);
        this.childStreamList.add(stream);
        return constraint;
    }

    @Override
    public final Constraint impactScoreBigDecimal(String constraintPackage, String constraintName, Score<?> constraintWeight, Function<A, BigDecimal> matchWeigher, boolean positive) {
        BavetConstraint constraint = this.buildConstraint(constraintPackage, constraintName, constraintWeight, positive);
        BavetScoringUniConstraintStream stream = new BavetScoringUniConstraintStream(this.constraintFactory, this, constraint, matchWeigher);
        this.childStreamList.add(stream);
        return constraint;
    }

    @Override
    public final Constraint impactScoreConfigurable(String constraintPackage, String constraintName, boolean positive) {
        BavetConstraint constraint = this.buildConstraintConfigurable(constraintPackage, constraintName, positive);
        BavetScoringUniConstraintStream stream = new BavetScoringUniConstraintStream(this.constraintFactory, this, constraint);
        this.childStreamList.add(stream);
        return constraint;
    }

    @Override
    public final Constraint impactScoreConfigurable(String constraintPackage, String constraintName, ToIntFunction<A> matchWeigher, boolean positive) {
        BavetConstraint constraint = this.buildConstraintConfigurable(constraintPackage, constraintName, positive);
        BavetScoringUniConstraintStream stream = new BavetScoringUniConstraintStream(this.constraintFactory, this, constraint, matchWeigher);
        this.childStreamList.add(stream);
        return constraint;
    }

    @Override
    public final Constraint impactScoreConfigurableLong(String constraintPackage, String constraintName, ToLongFunction<A> matchWeigher, boolean positive) {
        BavetConstraint constraint = this.buildConstraintConfigurable(constraintPackage, constraintName, positive);
        BavetScoringUniConstraintStream stream = new BavetScoringUniConstraintStream(this.constraintFactory, this, constraint, matchWeigher);
        this.childStreamList.add(stream);
        return constraint;
    }

    @Override
    public final Constraint impactScoreConfigurableBigDecimal(String constraintPackage, String constraintName, Function<A, BigDecimal> matchWeigher, boolean positive) {
        BavetConstraint constraint = this.buildConstraintConfigurable(constraintPackage, constraintName, positive);
        BavetScoringUniConstraintStream stream = new BavetScoringUniConstraintStream(this.constraintFactory, this, constraint, matchWeigher);
        this.childStreamList.add(stream);
        return constraint;
    }

    public BavetAbstractUniNode<A> createNodeChain(BavetNodeBuildPolicy<Solution_> buildPolicy, Score<?> constraintWeight, int nodeOrder, BavetAbstractUniNode<A> parentNode) {
        BavetAbstractUniNode<A> node = this.createNode(buildPolicy, constraintWeight, nodeOrder, parentNode);
        node = this.processNode(buildPolicy, nodeOrder, parentNode, node);
        this.createChildNodeChains(buildPolicy, constraintWeight, nodeOrder, node);
        return node;
    }

    protected BavetAbstractUniNode<A> processNode(BavetNodeBuildPolicy<Solution_> buildPolicy, int nodeOrder, BavetAbstractUniNode<A> parentNode, BavetAbstractUniNode<A> node) {
        buildPolicy.updateNodeOrderMaximum(nodeOrder);
        BavetAbstractUniNode<A> sharedNode = buildPolicy.retrieveSharedNode(node);
        if (sharedNode != node) {
            node = sharedNode;
        } else if (parentNode != null) {
            parentNode.addChildNode(node);
        }
        return node;
    }

    protected void createChildNodeChains(BavetNodeBuildPolicy<Solution_> buildPolicy, Score<?> constraintWeight, int nodeOrder, BavetAbstractUniNode<A> node) {
        if (this.childStreamList.isEmpty()) {
            throw new IllegalStateException("The stream (" + this + ") leads to nowhere.\nMaybe don't create it.");
        }
        for (BavetAbstractUniConstraintStream<Solution_, A> childStream : this.childStreamList) {
            childStream.createNodeChain(buildPolicy, constraintWeight, nodeOrder + 1, node);
        }
    }

    protected abstract BavetAbstractUniNode<A> createNode(BavetNodeBuildPolicy<Solution_> var1, Score<?> var2, int var3, BavetAbstractUniNode<A> var4);
}

