/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools;

import java.util.List;
import org.kie.api.KieBase;
import org.kie.api.definition.rule.Rule;
import org.kie.api.runtime.KieSession;
import org.kie.internal.event.rule.RuleEventListener;
import org.kie.internal.event.rule.RuleEventManager;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.holder.AbstractScoreHolder;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.score.definition.ScoreDefinition;
import org.optaplanner.core.impl.score.director.drools.OptaPlannerRuleEventListener;
import org.optaplanner.core.impl.score.stream.ConstraintSession;
import org.optaplanner.core.impl.score.stream.ConstraintSessionFactory;
import org.optaplanner.core.impl.score.stream.drools.DroolsConstraint;
import org.optaplanner.core.impl.score.stream.drools.DroolsConstraintSession;

public class DroolsConstraintSessionFactory<Solution_>
implements ConstraintSessionFactory<Solution_> {
    private final SolutionDescriptor<Solution_> solutionDescriptor;
    private final KieBase kieBase;
    private List<DroolsConstraint<Solution_>> constraintList;

    public DroolsConstraintSessionFactory(SolutionDescriptor<Solution_> solutionDescriptor, KieBase kieBase, List<DroolsConstraint<Solution_>> constraintList) {
        this.solutionDescriptor = solutionDescriptor;
        this.kieBase = kieBase;
        this.constraintList = constraintList;
    }

    @Override
    public ConstraintSession<Solution_> buildSession(boolean constraintMatchEnabled, Solution_ workingSolution) {
        KieSession kieSession = this.kieBase.newKieSession();
        ((RuleEventManager)kieSession).addEventListener((RuleEventListener)new OptaPlannerRuleEventListener());
        ScoreDefinition scoreDefinition = this.solutionDescriptor.getScoreDefinition();
        AbstractScoreHolder scoreHolder = (AbstractScoreHolder)scoreDefinition.buildScoreHolder(constraintMatchEnabled);
        for (DroolsConstraint<Solution_> constraint : this.constraintList) {
            Score<?> constraintWeight = constraint.extractConstraintWeight(workingSolution);
            Rule rule = this.kieBase.getRule(constraint.getConstraintPackage(), constraint.getConstraintName());
            scoreHolder.configureConstraintWeight(rule, constraintWeight);
        }
        kieSession.setGlobal("scoreHolder", (Object)scoreHolder);
        return new DroolsConstraintSession(constraintMatchEnabled, kieSession, scoreHolder);
    }
}

